/*
 * Decompiled with CFR 0.152.
 */
package recoder.bytecode;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import recoder.abstraction.ClassTypeContainer;
import recoder.abstraction.ElementValuePair;
import recoder.abstraction.TypeArgument;
import recoder.bytecode.AbstractBytecodeParser;
import recoder.bytecode.AnnotationPropertyInfo;
import recoder.bytecode.AnnotationUseInfo;
import recoder.bytecode.ByteCodeFormatException;
import recoder.bytecode.ClassFile;
import recoder.bytecode.ConstructorInfo;
import recoder.bytecode.ElementValuePairInfo;
import recoder.bytecode.EnumConstantInfo;
import recoder.bytecode.EnumConstantReferenceInfo;
import recoder.bytecode.FieldInfo;
import recoder.bytecode.MethodInfo;
import recoder.bytecode.TypeArgumentInfo;
import recoder.bytecode.TypeNameReferenceInfo;
import recoder.bytecode.TypeParameterInfo;
import recoder.convenience.Naming;

public class ByteCodeParser
extends AbstractBytecodeParser {
    private DataInput in;
    private String className;
    private String fullName;
    private String pathPrefix;
    private String shortName;
    private String superName;
    private int accessFlags;
    private String[] interfaceNames;
    private ArrayList<FieldInfo> fields;
    private ArrayList<MethodInfo> methods;
    private ArrayList<ConstructorInfo> constructors;
    private String[] innerClasses;
    private String[] pool;
    private Object currentDefaultValue;
    private AnnotationUseInfo[][] currentParamAnnotations;
    private boolean readJava5Signatures;
    private ClassFile cf;
    protected static final byte CLASS = 7;
    protected static final byte FIELD_REF = 9;
    protected static final byte METHOD_REF = 10;
    protected static final byte INTERFACE_METHOD_REF = 11;
    protected static final byte STRING = 8;
    protected static final byte INTEGER = 3;
    protected static final byte FLOAT = 4;
    protected static final byte LONG = 5;
    protected static final byte DOUBLE = 6;
    protected static final byte NAME_AND_TYPE = 12;
    protected static final byte UTF8 = 1;
    private String[] longRes = new String[256];
    private boolean readAttributes_ret_is_type_arg = false;
    private Set<String> staticInners = new HashSet<String>(256);

    @Override
    public ClassFile parseClassFile(InputStream is, String location, boolean useJava5Signatures) throws ByteCodeFormatException, IOException {
        this.readJava5Signatures = useJava5Signatures;
        return this.parseClassFile(new DataInputStream(is), location);
    }

    private ClassFile parseClassFile(DataInput inStr, String location) throws ByteCodeFormatException, IOException {
        this.cf = new ClassFile();
        this.in = inStr;
        if (inStr.readInt() != -889275714) {
            throw new ByteCodeFormatException("Bad magic in bytecode file");
        }
        int minorVersion = inStr.readUnsignedShort();
        int majorVersion = inStr.readUnsignedShort();
        int constantPoolCount = inStr.readUnsignedShort();
        this.makeConstantPool(constantPoolCount);
        this.accessFlags = inStr.readUnsignedShort();
        this.className = this.pool[inStr.readUnsignedShort()];
        this.className = this.className.replace('/', '.');
        this.fullName = this.className.replace('$', '.');
        int ldp = this.fullName.lastIndexOf(46);
        this.pathPrefix = ldp > 0 ? this.fullName.substring(0, ldp) : "";
        this.shortName = this.fullName.substring(ldp + 1);
        this.superName = this.pool[inStr.readUnsignedShort()];
        if (this.superName != null) {
            this.superName = this.superName.replace('/', '.').replace('$', '.');
        }
        int interfacesCount = inStr.readUnsignedShort();
        this.interfaceNames = new String[interfacesCount];
        int i = 0;
        while (i < interfacesCount) {
            this.interfaceNames[i] = this.pool[inStr.readUnsignedShort()];
            this.interfaceNames[i] = this.interfaceNames[i].replace('/', '.').replace('$', '.');
            ++i;
        }
        int fieldsCount = inStr.readUnsignedShort();
        this.fields = new ArrayList(fieldsCount);
        int i2 = 0;
        while (i2 < fieldsCount) {
            this.fields.add(this.readFieldInfo());
            ++i2;
        }
        int methodsCount = inStr.readUnsignedShort();
        this.methods = new ArrayList();
        this.constructors = new ArrayList();
        int i3 = 0;
        while (i3 < methodsCount) {
            MethodInfo minfo = this.readMethodInfo();
            if (minfo != null) {
                if (minfo instanceof ConstructorInfo) {
                    this.constructors.add((ConstructorInfo)minfo);
                } else {
                    this.methods.add(minfo);
                }
            }
            ++i3;
        }
        ArrayList<AnnotationUseInfo> annotations = new ArrayList<AnnotationUseInfo>();
        ArrayList<TypeParameterInfo> typeParams = new ArrayList<TypeParameterInfo>();
        ArrayList<List<TypeArgumentInfo>> typeArgList = new ArrayList<List<TypeArgumentInfo>>();
        ArrayList<String> typeNames = new ArrayList<String>();
        this.innerClasses = this.readAttributesForClassFile(annotations, typeParams, typeArgList, typeNames);
        annotations.trimToSize();
        typeParams.trimToSize();
        this.pool = null;
        this.cf.setLocation(location);
        this.cf.setPhysicalName(this.className);
        this.cf.setFullName(this.fullName);
        this.cf.setName(this.shortName);
        this.cf.setSuperName(this.superName);
        this.cf.setAccessFlags(this.accessFlags);
        this.cf.setInterfaceNames(this.interfaceNames);
        this.fields.trimToSize();
        this.cf.setFields(this.fields);
        this.constructors.trimToSize();
        this.cf.setConstructors(this.constructors);
        this.methods.trimToSize();
        this.cf.setMethods(this.methods);
        this.cf.setInnerClassNames(this.innerClasses);
        this.cf.setAnnotations(annotations);
        this.cf.setTypeParameters(typeParams);
        if (typeArgList.size() > 0) {
            ((ArrayList)typeArgList.get(0)).trimToSize();
            this.cf.superClassTypeArguments = typeArgList.get(0);
            if (typeArgList.size() > 1) {
                ArrayList[] arrayLists = new ArrayList[typeArgList.size() - 1];
                this.cf.superInterfacesTypeArguments = arrayLists;
                int i4 = 1;
                while (i4 < typeArgList.size()) {
                    ((ArrayList)typeArgList.get(i4)).trimToSize();
                    this.cf.superInterfacesTypeArguments[i4 - 1] = typeArgList.get(i4);
                    ++i4;
                }
            }
        }
        return this.cf;
    }

    protected void makeConstantPool(int count) throws IOException, ByteCodeFormatException {
        this.pool = new String[count];
        int[] targetIndex = new int[count];
        int[] dblIndex = new int[count];
        int i = 1;
        while (i < count) {
            byte tag = this.in.readByte();
            switch (tag) {
                case 7: 
                case 8: {
                    int j = this.in.readUnsignedShort();
                    if (this.pool[j] != null) {
                        this.pool[i] = this.pool[j];
                        break;
                    }
                    targetIndex[i] = j;
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    this.in.skipBytes(4);
                    break;
                }
                case 12: {
                    short ch1 = this.in.readShort();
                    short ch2 = this.in.readShort();
                    if (ch1 > i || ch2 > i) {
                        targetIndex[i] = ch1;
                        dblIndex[i] = ch2;
                        break;
                    }
                    this.pool[i] = String.valueOf(this.pool[ch1]) + this.pool[ch2];
                    break;
                }
                case 3: {
                    this.pool[i] = String.valueOf(this.in.readInt());
                    break;
                }
                case 4: {
                    this.pool[i] = String.valueOf(this.in.readFloat());
                    break;
                }
                case 5: {
                    this.pool[i] = String.valueOf(this.in.readLong());
                    ++i;
                    break;
                }
                case 6: {
                    this.pool[i] = String.valueOf(this.in.readDouble());
                    ++i;
                    break;
                }
                case 1: {
                    this.pool[i] = this.in.readUTF();
                    break;
                }
                default: {
                    throw new ByteCodeFormatException("Bad Constant Pool Type " + tag);
                }
            }
            ++i;
        }
        i = 1;
        while (i < count) {
            if (targetIndex[i] > 0) {
                this.pool[i] = this.pool[targetIndex[i]];
                if (dblIndex[i] > 0) {
                    int n = i;
                    this.pool[n] = String.valueOf(this.pool[n]) + this.pool[dblIndex[i]];
                }
            }
            ++i;
        }
    }

    static String decodeType(String in) throws ByteCodeFormatException {
        int dim = 0;
        int i = 0;
        char c = in.charAt(i);
        if (c == '[') {
            dim = i;
            while ((c = in.charAt(++i)) == '[') {
            }
            dim = i - dim;
        }
        String type = null;
        switch (c) {
            case 'B': {
                type = "byte";
                break;
            }
            case 'C': {
                type = "char";
                break;
            }
            case 'D': {
                type = "double";
                break;
            }
            case 'F': {
                type = "float";
                break;
            }
            case 'I': {
                type = "int";
                break;
            }
            case 'J': {
                type = "long";
                break;
            }
            case 'S': {
                type = "short";
                break;
            }
            case 'Z': {
                type = "boolean";
                break;
            }
            case 'V': {
                type = "void";
                break;
            }
            case 'L': {
                int j = in.indexOf(59, i);
                type = in.substring(i + 1, j).replace('/', '.').replace('$', '.');
                break;
            }
            default: {
                throw new ByteCodeFormatException("Illegal type code");
            }
        }
        return Naming.toArrayTypeName(type, dim);
    }

    public final String[] decodeTypes(String inStr) throws ByteCodeFormatException {
        int count = 0;
        if (inStr.charAt(0) != '(') {
            throw new ByteCodeFormatException("Bad method descriptor");
        }
        boolean returnValue = false;
        int i = 1;
        while (i < inStr.length()) {
            int dim = 0;
            char c = inStr.charAt(i);
            if (c == ')') {
                if (returnValue) {
                    throw new ByteCodeFormatException("Bad method descriptor");
                }
                returnValue = true;
                c = inStr.charAt(++i);
            }
            if (c == '[') {
                dim = i;
                while ((c = inStr.charAt(++i)) == '[') {
                }
                dim = i - dim;
            }
            String type = null;
            switch (c) {
                case 'B': {
                    type = "byte";
                    ++i;
                    break;
                }
                case 'C': {
                    type = "char";
                    ++i;
                    break;
                }
                case 'D': {
                    type = "double";
                    ++i;
                    break;
                }
                case 'F': {
                    type = "float";
                    ++i;
                    break;
                }
                case 'I': {
                    type = "int";
                    ++i;
                    break;
                }
                case 'J': {
                    type = "long";
                    ++i;
                    break;
                }
                case 'S': {
                    type = "short";
                    ++i;
                    break;
                }
                case 'Z': {
                    type = "boolean";
                    ++i;
                    break;
                }
                case 'V': {
                    if (!returnValue) {
                        throw new ByteCodeFormatException("Void parameter type");
                    }
                    type = "void";
                    ++i;
                    break;
                }
                case 'L': {
                    int j = inStr.indexOf(59, i);
                    type = inStr.substring(i + 1, j).replace('/', '.').replace('$', '.');
                    i = j + 1;
                    break;
                }
                default: {
                    throw new ByteCodeFormatException("Illegal type code " + c);
                }
            }
            this.longRes[count++] = Naming.toArrayTypeName(type, dim);
        }
        String[] r = new String[count];
        System.arraycopy(this.longRes, 0, r, 0, count);
        return r;
    }

    private String[] readAttributesForMethod(ArrayList<AnnotationUseInfo> emptyListForAnnotations, String[] prereadParams, List<TypeArgumentInfo>[] typeArgs, List<TypeParameterInfo> typeParams) throws IOException, ByteCodeFormatException {
        String[] exceptions = null;
        int count = this.in.readUnsignedShort();
        int i = 0;
        while (i < count) {
            int j;
            int number;
            String name = this.pool[this.in.readUnsignedShort()];
            int length = this.in.readInt();
            if ("Exceptions".equals(name)) {
                if (exceptions != null) {
                    throw new ByteCodeFormatException("Multiple exceptions lists");
                }
                number = this.in.readUnsignedShort();
                exceptions = new String[number];
                j = 0;
                while (j < number) {
                    exceptions[j] = this.pool[this.in.readUnsignedShort()].replace('/', '.').replace('$', '.');
                    ++j;
                }
            } else if ("Signature".equals(name)) {
                if (this.readJava5Signatures) {
                    List<TypeArgumentInfo>[] typeArgInfos = this.readMethodSignature(prereadParams, typeParams, null);
                    int jj = 0;
                    while (jj < typeArgs.length) {
                        typeArgs[jj] = typeArgInfos[jj];
                        ++jj;
                    }
                } else {
                    this.in.skipBytes(length);
                }
            } else if ("RuntimeVisibleAnnotation".equals(name) || "RuntimeInvisibleAnnotation".equals(name)) {
                if (this.readJava5Signatures) {
                    number = this.in.readUnsignedShort();
                    emptyListForAnnotations.ensureCapacity(number);
                    j = 0;
                    while (j < number) {
                        emptyListForAnnotations.add(this.readAnnotation());
                        ++j;
                    }
                } else {
                    this.in.skipBytes(length);
                }
            } else if ("RuntimeVisibleParameterAnnotations".equals(name) || "RuntimeInvisibleParameterAnnotations".equals(name)) {
                if (this.readJava5Signatures) {
                    int paramNum = this.in.readUnsignedByte();
                    this.currentParamAnnotations = new AnnotationUseInfo[paramNum][];
                    j = 0;
                    while (j < paramNum) {
                        int number2 = this.in.readUnsignedShort();
                        this.currentParamAnnotations[j] = new AnnotationUseInfo[number2];
                        int k = 0;
                        while (k < number2) {
                            this.currentParamAnnotations[j][k] = this.readAnnotation();
                            ++k;
                        }
                        ++j;
                    }
                } else {
                    this.in.skipBytes(length);
                }
            } else if ("AnnotationDefault".equals(name)) {
                if (this.readJava5Signatures) {
                    this.currentDefaultValue = this.readElementValue();
                } else {
                    this.in.skipBytes(length);
                }
            } else {
                this.in.skipBytes(length);
            }
            ++i;
        }
        return exceptions;
    }

    /*
     * Could not resolve type clashes
     */
    private String[] readAttributesForClassFile(ArrayList<AnnotationUseInfo> emptyListForAnnotations, List<TypeParameterInfo> emptyListForTypeParams, List<List<TypeArgumentInfo>> emptyListForTypeArgumentLists, List<String> emptyListForTypeNames) throws IOException, ByteCodeFormatException {
        String[] innerClassesRes = null;
        int count = this.in.readUnsignedShort();
        int i = 0;
        while (i < count) {
            String name = this.pool[this.in.readUnsignedShort()];
            int length = this.in.readInt();
            if ("InnerClasses".equals(name)) {
                if (innerClassesRes != null) {
                    throw new ByteCodeFormatException("Multiple inner classes lists");
                }
                int number = this.in.readUnsignedShort();
                innerClassesRes = new String[number];
                int k = 0;
                int j = 0;
                while (j < number) {
                    String s = this.readInnerClassInfo();
                    if (s != null) {
                        innerClassesRes[k++] = s;
                    }
                    ++j;
                }
                if (k != number) {
                    String[] tmpInnerClassesRes = new String[k];
                    System.arraycopy(innerClassesRes, 0, tmpInnerClassesRes, 0, k);
                    innerClassesRes = tmpInnerClassesRes;
                }
            } else if ("RuntimeVisibleAnnotations".equals(name) || "RuntimeInvisibleAnnotations".equals(name)) {
                if (this.readJava5Signatures) {
                    int number = this.in.readUnsignedShort();
                    emptyListForAnnotations.ensureCapacity(number);
                    int j = 0;
                    while (j < number) {
                        emptyListForAnnotations.add(this.readAnnotation());
                        ++j;
                    }
                } else {
                    this.in.skipBytes(length);
                }
            } else if ("EnclosingMethod".equals(name)) {
                short clazz = this.in.readShort();
                short meth = this.in.readShort();
                if (meth != 0) {
                    String clName = this.pool[clazz];
                    String mDesc = this.pool[meth];
                    this.cf.enclosingMethod = String.valueOf(clName) + "." + mDesc;
                }
            } else if ("Synthetic".equals(name)) {
                this.in.skipBytes(length);
            } else if ("SourceFile".equals(name)) {
                this.in.skipBytes(length);
            } else if ("Signature".equals(name)) {
                if (this.readJava5Signatures) {
                    ReadClassSignatureResult res = this.readClassSignature();
                    for (TypeParameterInfo tai : res.typeParams) {
                        emptyListForTypeParams.add(tai);
                    }
                    for (List tai : res.typeArgumentArray) {
                        emptyListForTypeArgumentLists.add(tai);
                    }
                    for (String n : res.typeNameArray) {
                        emptyListForTypeNames.add(n);
                    }
                } else {
                    this.in.skipBytes(length);
                }
            } else if ("Deprecated".equals(name)) {
                this.in.skipBytes(length);
            } else {
                this.in.skipBytes(length);
            }
            ++i;
        }
        return innerClassesRes;
    }

    private String[] readAttributesForField(ArrayList<AnnotationUseInfo> emptyListForAnnotations, List<TypeArgumentInfo> emptyListForTypeArgs) throws IOException, ByteCodeFormatException {
        assert (emptyListForAnnotations != null && emptyListForAnnotations.isEmpty());
        String constant = null;
        String type = null;
        int count = this.in.readUnsignedShort();
        int i = 0;
        while (i < count) {
            String id = this.pool[this.in.readUnsignedShort()];
            int length = this.in.readInt();
            if ("ConstantValue".equals(id)) {
                if (constant != null) {
                    throw new ByteCodeFormatException("Multiple constant values for field");
                }
                constant = this.pool[this.in.readUnsignedShort()];
            } else if ("Signature".equals(id)) {
                if (this.readJava5Signatures) {
                    type = this.readFieldSignature(this.pool[this.in.readUnsignedShort()], emptyListForTypeArgs);
                } else {
                    this.in.skipBytes(length);
                }
            } else if ("RuntimeVisibleAnnotation".equals(id) || "RuntimeInvisibleAnnotation".equals(id)) {
                if (this.readJava5Signatures) {
                    int number = this.in.readUnsignedShort();
                    emptyListForAnnotations.ensureCapacity(number);
                    int j = 0;
                    while (j < number) {
                        emptyListForAnnotations.add(this.readAnnotation());
                        ++j;
                    }
                } else {
                    this.in.skipBytes(length);
                }
            } else {
                this.in.skipBytes(length);
            }
            ++i;
        }
        return new String[]{constant, type};
    }

    FieldInfo readFieldInfo() throws IOException, ByteCodeFormatException {
        int fieldAccessFlags = this.in.readUnsignedShort();
        String name = this.pool[this.in.readUnsignedShort()];
        String type = ByteCodeParser.decodeType(this.pool[this.in.readUnsignedShort()]);
        ArrayList<AnnotationUseInfo> annotations = new ArrayList<AnnotationUseInfo>();
        ArrayList<TypeArgumentInfo> typeArgs = new ArrayList<TypeArgumentInfo>();
        String[] tmp = this.readAttributesForField(annotations, typeArgs);
        String constant = tmp[0];
        if (tmp[1] != null) {
            type = tmp[1].replace('$', '.');
        }
        FieldInfo res = (fieldAccessFlags & 0x4000) > 0 ? new EnumConstantInfo(fieldAccessFlags, name, type, this.cf, constant, typeArgs) : new FieldInfo(fieldAccessFlags, name, type, this.readAttributes_ret_is_type_arg, this.cf, constant, typeArgs);
        res.setAnnotations(annotations);
        return res;
    }

    MethodInfo readMethodInfo() throws IOException, ByteCodeFormatException {
        int methAccessFlags = this.in.readUnsignedShort();
        String name = this.pool[this.in.readUnsignedShort()];
        boolean isConstructor = "<init>".equals(name);
        boolean isInitializer = false;
        if (isConstructor) {
            name = this.shortName;
        } else {
            isInitializer = "<clinit>".equals(name);
        }
        String[] types = this.decodeTypes(this.pool[this.in.readUnsignedShort()]);
        ArrayList<AnnotationUseInfo> annotations = new ArrayList<AnnotationUseInfo>();
        this.currentDefaultValue = null;
        this.currentParamAnnotations = null;
        List[] typeArgs = new List[types.length];
        ArrayList<TypeParameterInfo> typeParams = new ArrayList<TypeParameterInfo>();
        String[] exceptions = this.readAttributesForMethod(annotations, types, typeArgs, typeParams);
        String rtype = types[types.length - 1];
        int firstParam = 0;
        int paramCount = types.length - 1;
        if (isConstructor && types[0].equals(this.pathPrefix) && !this.staticInners.contains(this.fullName)) {
            firstParam = 1;
            --paramCount;
        }
        String[] ptypes = new String[paramCount];
        System.arraycopy(types, firstParam, ptypes, 0, paramCount);
        if (isInitializer) {
            return null;
        }
        MethodInfo res = isConstructor ? new ConstructorInfo(methAccessFlags, name, ptypes, exceptions, this.cf) : ((this.accessFlags & 0x2000) != 0 ? new AnnotationPropertyInfo(methAccessFlags, rtype, this.readAttributes_ret_is_type_arg, name, this.cf, this.currentDefaultValue) : new MethodInfo(methAccessFlags, rtype, this.readAttributes_ret_is_type_arg, name, ptypes, exceptions, this.cf));
        res.setAnnotations(annotations);
        res.paramAnnotations = this.currentParamAnnotations;
        if (typeArgs.length != 0) {
            this.setTypeArgParentRec(typeArgs, res);
            res.paramTypeArgs = typeArgs;
        }
        if (typeParams.size() != 0) {
            typeParams.trimToSize();
            res.typeParms = typeParams;
            for (TypeParameterInfo tpi : typeParams) {
                tpi.setContainer(res);
            }
        }
        return res;
    }

    private void setTypeArgParentRec(List<? extends TypeArgument>[] typeArgs, MethodInfo res) {
        int i = 0;
        while (i < typeArgs.length) {
            if (typeArgs[i] != null) {
                this.setTypeArgParentRec(typeArgs[i], res);
            }
            ++i;
        }
    }

    private void setTypeArgParentRec(List<? extends TypeArgument> typeArgs, MethodInfo res) {
        for (TypeArgument typeArgument : typeArgs) {
            TypeArgumentInfo tai = (TypeArgumentInfo)typeArgument;
            tai.parent = res;
            if (tai.typeArgs == null) continue;
            this.setTypeArgParentRec(tai.typeArgs, res);
        }
    }

    public String readInnerClassInfo() throws IOException {
        String name = this.pool[this.in.readUnsignedShort()];
        if (name != null) {
            name = name.replace('/', '.').replace('$', '.');
        }
        this.in.readUnsignedShort();
        this.in.readUnsignedShort();
        int innerClassAccessFlags = this.in.readUnsignedShort();
        if (name != null && (innerClassAccessFlags & 8) == 0) {
            this.staticInners.add(name);
            if (name.equals(this.fullName)) {
                this.cf.isInner = true;
            }
        }
        if (name != null) {
            if (!this.fullName.equals(name.substring(0, name.lastIndexOf(46)))) {
                name = null;
            } else if (!Character.isJavaIdentifierStart(name.charAt(name.lastIndexOf(46) + 1))) {
                name = null;
            }
        }
        return name;
    }

    private Object readElementValue() throws IOException, ByteCodeFormatException {
        Object res;
        byte tag = this.in.readByte();
        switch (tag) {
            case 66: {
                res = Byte.valueOf(this.pool[this.in.readUnsignedShort()]);
                break;
            }
            case 67: {
                res = Character.valueOf(this.pool[this.in.readUnsignedShort()].toCharArray()[0]);
                break;
            }
            case 68: {
                res = Double.valueOf(this.pool[this.in.readUnsignedShort()]);
                break;
            }
            case 70: {
                res = Float.valueOf(this.pool[this.in.readUnsignedShort()]);
                break;
            }
            case 73: {
                res = Integer.valueOf(this.pool[this.in.readUnsignedShort()]);
                break;
            }
            case 74: {
                res = Long.valueOf(this.pool[this.in.readUnsignedShort()]);
                break;
            }
            case 83: {
                res = Short.valueOf(this.pool[this.in.readUnsignedShort()]);
                break;
            }
            case 90: {
                res = Boolean.valueOf(this.pool[this.in.readUnsignedShort()]);
                break;
            }
            case 115: {
                res = this.pool[this.in.readUnsignedShort()];
                break;
            }
            case 101: {
                String typename = this.pool[this.in.readUnsignedShort()];
                String constname = this.pool[this.in.readUnsignedShort()];
                res = new EnumConstantReferenceInfo(typename, constname);
                break;
            }
            case 99: {
                String tr = this.pool[this.in.readUnsignedShort()];
                tr.replace('/', '.').replace('$', '.');
                res = new TypeNameReferenceInfo(tr);
                break;
            }
            case 64: {
                res = this.readAnnotation();
                break;
            }
            case 91: {
                int num = this.in.readUnsignedShort();
                res = new Object[num];
                int i = 0;
                while (i < num) {
                    res[i] = this.readElementValue();
                    ++i;
                }
                break;
            }
            default: {
                throw new ByteCodeFormatException("Illegal tag in element-value: " + tag);
            }
        }
        return res;
    }

    private AnnotationUseInfo readAnnotation() throws IOException, ByteCodeFormatException {
        String name = this.pool[this.in.readUnsignedShort()];
        if (name == null) {
            throw new ByteCodeFormatException();
        }
        name = name.replace('/', '.').replace('$', '.').substring(1, name.length() - 1);
        int number = this.in.readUnsignedShort();
        ArrayList<ElementValuePair> evpl = new ArrayList<ElementValuePair>(number);
        AnnotationUseInfo res = new AnnotationUseInfo(name, evpl);
        int i = 0;
        while (i < number) {
            String elementName = this.pool[this.in.readUnsignedShort()];
            Object value = this.readElementValue();
            ElementValuePairInfo evpi = new ElementValuePairInfo(elementName, value);
            evpl.add(evpi);
            ++i;
        }
        return res;
    }

    private ReadClassSignatureResult readClassSignature() throws IOException, ByteCodeFormatException {
        ReadClassSignatureResult res = new ReadClassSignatureResult();
        String sig = this.pool[this.in.readUnsignedShort()];
        int start = 0;
        if (sig.charAt(0) == '<') {
            res.typeParams = this.readFormalTypeParameters(sig, this.cf);
            start = 1;
            int o = 1;
            while (o > 0) {
                if (sig.charAt(start) == '<') {
                    ++o;
                } else if (sig.charAt(start) == '>') {
                    --o;
                }
                ++start;
            }
        }
        ArrayList<List<TypeArgumentInfo>> l1 = new ArrayList<List<TypeArgumentInfo>>();
        ArrayList<String> l2 = new ArrayList<String>();
        while (start != sig.length()) {
            int end = start;
            int o = 0;
            while (sig.charAt(++end) != ';' || o > 0) {
                if (sig.charAt(end) == '<') {
                    ++o;
                    continue;
                }
                if (sig.charAt(end) != '>') continue;
                --o;
            }
            String sig2 = sig.substring(start, ++end);
            ArrayList<TypeArgumentInfo> ral = new ArrayList<TypeArgumentInfo>();
            l2.add(this.readFieldSignature(sig2, ral));
            l1.add(ral);
            start = end;
        }
        if (res.typeParams == null) {
            res.typeParams = new ArrayList<TypeParameterInfo>();
        }
        res.typeArgumentArray = l1;
        res.typeNameArray = l2;
        return res;
    }

    private List<TypeParameterInfo> readFormalTypeParameters(String sig, ClassTypeContainer container) throws ByteCodeFormatException {
        ArrayList<TypeParameterInfo> res = new ArrayList<TypeParameterInfo>();
        int rpos = 1;
        int cnt = 0;
        while (sig.charAt(rpos) != '>') {
            ++cnt;
            int lpos = rpos;
            while (sig.charAt(rpos) != ':') {
                ++rpos;
            }
            String paramName = sig.substring(lpos, rpos);
            ArrayList<String> boundNames = new ArrayList<String>();
            ArrayList<List<TypeArgumentInfo>> boundArgs = new ArrayList<List<TypeArgumentInfo>>();
            do {
                String typeName;
                if (sig.charAt(lpos = ++rpos) == '[') {
                    throw new ByteCodeFormatException();
                }
                switch (sig.charAt(lpos)) {
                    case ':': {
                        typeName = "java.lang.Object";
                        break;
                    }
                    case 'L': 
                    case 'T': {
                        int intopen = 0;
                        while (sig.charAt(rpos) != ';' || intopen > 0) {
                            if (sig.charAt(rpos) == '<') {
                                ++intopen;
                            }
                            if (sig.charAt(rpos) == '>') {
                                --intopen;
                            }
                            ++rpos;
                        }
                        typeName = sig.substring(lpos + 1, rpos).replace('/', '.');
                        ++rpos;
                        break;
                    }
                    default: {
                        throw new ByteCodeFormatException();
                    }
                }
                int idx = typeName.indexOf(60);
                List<TypeArgumentInfo> typeArgs = null;
                if (idx != -1) {
                    typeArgs = this.makeTypeArgs(typeName.substring(idx));
                    typeName = typeName.substring(0, idx);
                }
                boundNames.add(typeName);
                boundArgs.add(typeArgs);
            } while (sig.charAt(rpos) == ':');
            String[] bn = new String[boundNames.size()];
            boundNames.toArray(bn);
            List[] tai = new List[boundArgs.size()];
            boundArgs.toArray(tai);
            TypeParameterInfo n = new TypeParameterInfo(paramName, bn, tai, container);
            res.add(n);
        }
        return res;
    }

    private List<TypeArgumentInfo> makeTypeArgs(String tn) throws ByteCodeFormatException {
        while (tn.endsWith(">;") || tn.endsWith(">")) {
            tn = tn.substring(0, tn.lastIndexOf(">"));
        }
        ArrayList<TypeArgumentInfo> res = new ArrayList<TypeArgumentInfo>();
        assert (tn.charAt(0) == '<');
        int pos = 1;
        do {
            TypeArgument.WildcardMode wm;
            String typeName = null;
            switch (tn.charAt(pos)) {
                case '+': {
                    wm = TypeArgument.WildcardMode.Extends;
                    ++pos;
                    break;
                }
                case '-': {
                    wm = TypeArgument.WildcardMode.Super;
                    ++pos;
                    break;
                }
                case '*': {
                    wm = TypeArgument.WildcardMode.Any;
                    ++pos;
                    break;
                }
                default: {
                    wm = TypeArgument.WildcardMode.None;
                }
            }
            if (wm != TypeArgument.WildcardMode.Any) {
                boolean isTypeVariable = false;
                int dim = 0;
                while (tn.charAt(pos) == '[') {
                    ++dim;
                    ++pos;
                }
                int rpos = pos;
                switch (tn.charAt(pos)) {
                    case 'L': {
                        int o = 1;
                        while (rpos < tn.length() && o > 0 && (tn.charAt(rpos) != ';' || o != 1)) {
                            if (tn.charAt(rpos) == '<') {
                                ++o;
                            }
                            if (tn.charAt(rpos) == '>') {
                                --o;
                            }
                            ++rpos;
                        }
                        typeName = tn.substring(pos + 1, rpos).replace('/', '.');
                        if (typeName.equals("")) {
                            typeName = "java.lang.Object";
                        }
                        while (typeName.endsWith(";") || typeName.endsWith(">")) {
                            typeName = typeName.substring(0, typeName.length() - 1);
                        }
                        typeName = Naming.toArrayTypeName(typeName, dim);
                        ++rpos;
                        break;
                    }
                    case 'T': {
                        while (rpos < tn.length() && Character.isJavaIdentifierPart(tn.charAt(rpos))) {
                            ++rpos;
                        }
                        typeName = tn.substring(pos + 1, rpos);
                        typeName = Naming.toArrayTypeName(typeName, dim);
                        isTypeVariable = true;
                        ++rpos;
                        break;
                    }
                    case 'B': {
                        if (dim == 0) {
                            throw new ByteCodeFormatException("primitive type not allowed as type argument");
                        }
                        typeName = "byte";
                        ++rpos;
                        break;
                    }
                    case 'C': {
                        if (dim == 0) {
                            throw new ByteCodeFormatException("primitive type not allowed as type argument");
                        }
                        typeName = "char";
                        ++rpos;
                        break;
                    }
                    case 'D': {
                        if (dim == 0) {
                            throw new ByteCodeFormatException("primitive type not allowed as type argument");
                        }
                        typeName = "double";
                        ++rpos;
                        break;
                    }
                    case 'F': {
                        if (dim == 0) {
                            throw new ByteCodeFormatException("primitive type not allowed as type argument");
                        }
                        typeName = "float";
                        ++rpos;
                        break;
                    }
                    case 'I': {
                        if (dim == 0) {
                            throw new ByteCodeFormatException("primitive type not allowed as type argument");
                        }
                        typeName = "int";
                        ++rpos;
                        break;
                    }
                    case 'J': {
                        if (dim == 0) {
                            throw new ByteCodeFormatException("primitive type not allowed as type argument");
                        }
                        typeName = "long";
                        ++rpos;
                        break;
                    }
                    case 'S': {
                        if (dim == 0) {
                            throw new ByteCodeFormatException("primitive type not allowed as type argument");
                        }
                        typeName = "short";
                        ++rpos;
                        break;
                    }
                    case 'Z': {
                        if (dim == 0) {
                            throw new ByteCodeFormatException("primitive type not allowed as type argument");
                        }
                        typeName = "boolean";
                        ++rpos;
                        break;
                    }
                    default: {
                        throw new ByteCodeFormatException();
                    }
                }
                int idx = typeName.indexOf(60);
                List<TypeArgumentInfo> typeArgs = null;
                if (idx != -1) {
                    typeArgs = this.makeTypeArgs(typeName.substring(idx));
                    typeName = typeName.substring(0, idx);
                    typeName = Naming.toArrayTypeName(typeName, dim);
                }
                res.add(new TypeArgumentInfo(wm, typeName.replace('$', '.'), typeArgs, this.cf, isTypeVariable));
                pos = rpos;
                continue;
            }
            res.add(new TypeArgumentInfo(wm, null, null, this.cf, false));
        } while (pos < tn.length());
        res.trimToSize();
        return res;
    }

    private String readFieldSignature(String sig, List<TypeArgumentInfo> emptyListForTypeArgs) throws ByteCodeFormatException {
        String res = null;
        this.readAttributes_ret_is_type_arg = false;
        int rpos = sig.indexOf(40) + 1;
        int dim = 0;
        while (sig.charAt(rpos) == '[') {
            ++dim;
            ++rpos;
        }
        switch (sig.charAt(rpos)) {
            case 'L': {
                int lpos = rpos;
                while (sig.charAt(rpos) != ';') {
                    if (sig.charAt(rpos) == '<') {
                        int talpos = rpos;
                        int o = 1;
                        while (o > 0) {
                            if (sig.charAt(++rpos) == '<') {
                                ++o;
                            }
                            if (sig.charAt(rpos) != '>') continue;
                            --o;
                        }
                        String targs = sig.substring(talpos, rpos);
                        emptyListForTypeArgs.addAll(this.makeTypeArgs(targs));
                    }
                    ++rpos;
                }
                int idx = sig.indexOf(60);
                res = Naming.toArrayTypeName(sig.substring(lpos + 1, idx == -1 ? sig.length() - 1 : idx).replace('/', '.'), dim);
                ++rpos;
                break;
            }
            case 'T': {
                int lpos = rpos;
                while (sig.charAt(rpos) != ';') {
                    ++rpos;
                }
                res = Naming.toArrayTypeName(sig.substring(lpos + 1, rpos), dim);
                ++rpos;
                this.readAttributes_ret_is_type_arg = true;
                break;
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                ++rpos;
                break;
            }
            default: {
                ++rpos;
            }
        }
        return res;
    }

    private List<TypeArgumentInfo>[] readMethodSignature(String[] prereadParams, List<TypeParameterInfo> listForTypeParams, MethodInfo forMethod) throws IOException, ByteCodeFormatException {
        this.readAttributes_ret_is_type_arg = false;
        ArrayList[] res = new ArrayList[prereadParams.length];
        String sig = this.pool[this.in.readUnsignedShort()];
        if (sig.charAt(0) == '<') {
            listForTypeParams.addAll(this.readFormalTypeParameters(sig, forMethod));
        }
        int cur = -1;
        int rpos = sig.indexOf(40) + 1;
        boolean hasReturnValue = false;
        while (!hasReturnValue) {
            ++cur;
            if (sig.charAt(rpos) == ')') {
                hasReturnValue = true;
                ++rpos;
            }
            int dim = 0;
            while (sig.charAt(rpos) == '[') {
                ++dim;
                ++rpos;
            }
            switch (sig.charAt(rpos)) {
                case 'L': {
                    int lpos = rpos;
                    while (sig.charAt(rpos) != ';') {
                        if (sig.charAt(rpos) == '<') {
                            int talpos = rpos;
                            int o = 1;
                            while (o > 0) {
                                if (sig.charAt(++rpos) == '<') {
                                    ++o;
                                }
                                if (sig.charAt(rpos) != '>') continue;
                                --o;
                            }
                            String targs = sig.substring(talpos, rpos);
                            res[cur] = this.makeTypeArgs(targs);
                        }
                        ++rpos;
                    }
                    ++rpos;
                    break;
                }
                case 'T': {
                    int lpos = rpos;
                    while (sig.charAt(rpos) != ';') {
                        ++rpos;
                    }
                    prereadParams[cur] = Naming.toArrayTypeName(sig.substring(lpos + 1, rpos), dim);
                    ++rpos;
                    this.readAttributes_ret_is_type_arg = true;
                    break;
                }
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    ++rpos;
                    break;
                }
                default: {
                    ++rpos;
                }
            }
        }
        return res;
    }

    private static class ReadClassSignatureResult {
        List<TypeParameterInfo> typeParams;
        List<List<TypeArgumentInfo>> typeArgumentArray;
        List<String> typeNameArray;

        private ReadClassSignatureResult() {
        }
    }
}

