/*
 * Decompiled with CFR 0.152.
 */
package recoder.bytecode;

import recoder.ModelException;
import recoder.abstraction.ProgramModelElement;
import recoder.service.ByteCodeInfo;
import recoder.service.ProgramModelInfo;

public abstract class ByteCodeElement
implements ProgramModelElement {
    protected int accessFlags;
    private String name;
    protected ByteCodeInfo service;

    public ByteCodeElement() {
    }

    public ByteCodeElement(int accessFlags) {
        this.accessFlags = accessFlags;
    }

    public ByteCodeElement(int accessFlags, String name) {
        this.setName(name);
        this.accessFlags = accessFlags;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    final void setName(String name) {
        this.name = name.intern();
    }

    public abstract String getTypeName();

    public final int getAccessFlags() {
        return this.accessFlags;
    }

    public void setAccessFlags(int accessFlags) {
        this.accessFlags = accessFlags;
    }

    public boolean isAbstract() {
        return (this.accessFlags & 0x400) != 0;
    }

    public boolean isFinal() {
        return (this.accessFlags & 0x10) != 0;
    }

    public boolean isStatic() {
        return (this.accessFlags & 8) != 0;
    }

    public boolean isPrivate() {
        return (this.accessFlags & 2) != 0;
    }

    public boolean isProtected() {
        return (this.accessFlags & 4) != 0;
    }

    public boolean isPublic() {
        return (this.accessFlags & 1) != 0;
    }

    public boolean isStrictFp() {
        return (this.accessFlags & 0x800) != 0;
    }

    public boolean isNative() {
        return (this.accessFlags & 0x100) != 0;
    }

    public boolean isSynchronized() {
        return (this.accessFlags & 0x20) != 0;
    }

    @Override
    public ByteCodeInfo getProgramModelInfo() {
        return this.service;
    }

    @Override
    public void setProgramModelInfo(ProgramModelInfo service) {
        if (!(service instanceof ByteCodeInfo)) {
            throw new IllegalArgumentException("service for MethodDeclaration must be of type SourceInfo.");
        }
        this.service = (ByteCodeInfo)service;
    }

    @Override
    public void validate() throws ModelException {
    }
}

