/*
 * Decompiled with CFR 0.152.
 */
package recoder.bytecode;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.EmptyVisitor;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import recoder.abstraction.ClassTypeContainer;
import recoder.abstraction.ElementValuePair;
import recoder.abstraction.TypeArgument;
import recoder.bytecode.AbstractBytecodeParser;
import recoder.bytecode.AnnotationPropertyInfo;
import recoder.bytecode.AnnotationUseInfo;
import recoder.bytecode.ClassFile;
import recoder.bytecode.ConstructorInfo;
import recoder.bytecode.ElementValuePairInfo;
import recoder.bytecode.EnumConstantInfo;
import recoder.bytecode.EnumConstantReferenceInfo;
import recoder.bytecode.FieldInfo;
import recoder.bytecode.MethodInfo;
import recoder.bytecode.TypeArgumentInfo;
import recoder.bytecode.TypeParameterInfo;

public class ASMBytecodeParser
extends AbstractBytecodeParser {
    private boolean readJava5Signatures = true;
    private ClassFile result;
    private ArrayList<FieldInfo> fields;
    private ArrayList<MethodInfo> methods;
    private ArrayList<ConstructorInfo> constructors;
    private MethodInfo currentMethod;
    private ArrayList<String> innerClassesNames;
    private ArrayList<AnnotationUseInfo> classAnnotations;
    private ArrayList<AnnotationUseInfo> methodAnnotations;
    private ArrayList<AnnotationUseInfo>[] paramAnnotations;
    private ArrayList<AnnotationUseInfo> fieldAnnotations;

    private static String makeReplString(String s) {
        if (s == null) {
            return null;
        }
        return s.replace('$', '.').replace('/', '.');
    }

    private static String[] makeReplString(String[] s) {
        if (s == null) {
            return null;
        }
        String[] res = new String[s.length];
        int i = 0;
        while (i < s.length) {
            res[i] = ASMBytecodeParser.makeReplString(s[i]);
            ++i;
        }
        return res;
    }

    private static String[] getAsStringArr(Type[] s) {
        String[] res = new String[s.length];
        int i = 0;
        while (i < res.length) {
            res[i] = s[i].getClassName().replace('$', '.');
            ++i;
        }
        return res;
    }

    private static String makeAnnotationString(String s) {
        return ASMBytecodeParser.makeReplString(s.substring(1, s.length() - 1));
    }

    @Override
    public ClassFile parseClassFile(InputStream is, String location, boolean useJava5Features) throws IOException {
        this.readJava5Signatures = useJava5Features;
        this.result = new ClassFile();
        this.fields = new ArrayList();
        this.methods = new ArrayList();
        this.constructors = new ArrayList();
        this.innerClassesNames = new ArrayList();
        this.classAnnotations = new ArrayList();
        this.result.setLocation(location);
        ClassReader classReader = new ClassReader(is);
        classReader.accept((ClassVisitor)new ClassV(), 7);
        this.fields.trimToSize();
        this.methods.trimToSize();
        this.result.setFields(this.fields);
        this.result.setMethods(this.methods);
        this.result.setConstructors(this.constructors);
        this.result.setInnerClassNames(this.innerClassesNames.toArray(new String[this.innerClassesNames.size()]));
        this.classAnnotations.trimToSize();
        this.result.setAnnotations(this.classAnnotations);
        return this.result;
    }

    private class ClassV
    implements ClassVisitor {
        private ClassV() {
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            if (!ASMBytecodeParser.this.readJava5Signatures) {
                signature = null;
            }
            ASMBytecodeParser.this.result.setAccessFlags(access);
            String physName = name.replace('/', '.');
            ASMBytecodeParser.this.result.setPhysicalName(physName);
            String fullName = physName.replace('$', '.');
            ASMBytecodeParser.this.result.setFullName(fullName);
            ASMBytecodeParser.this.result.setName(fullName.substring(fullName.lastIndexOf(46) + 1));
            if (signature == null) {
                if (superName != null) {
                    ASMBytecodeParser.this.result.setSuperName(ASMBytecodeParser.makeReplString(superName));
                } else assert (name.equals("java/lang/Object"));
                ASMBytecodeParser.this.result.setInterfaceNames(ASMBytecodeParser.makeReplString(interfaces));
            } else {
                MySignatureVisitor mv = new MySignatureVisitor();
                new SignatureReader(signature).accept((SignatureVisitor)mv);
                ASMBytecodeParser.this.result.setSuperName(mv.superClassName);
                ASMBytecodeParser.this.result.setInterfaceNames(mv.interfaceNames.toArray(new String[mv.interfaceNames.size()]));
                ((ASMBytecodeParser)ASMBytecodeParser.this).result.superClassTypeArguments = mv.superClassTAIs;
                ((ASMBytecodeParser)ASMBytecodeParser.this).result.superInterfacesTypeArguments = mv.interfaceTAIs.toArray(new List[mv.interfaceTAIs.size()]);
                int tpCnt = mv.typeParamNames.size();
                ArrayList<TypeParameterInfo> tps = new ArrayList<TypeParameterInfo>(tpCnt);
                ASMBytecodeParser.this.result.setTypeParameters(tps);
                int i = 0;
                while (i < tpCnt) {
                    tps.add(new TypeParameterInfo((String)mv.typeParamNames.get(i), ((ArrayList)mv.typeParamBounds.get(i)).toArray(new String[0]), mv.typeParamTAIs.toArray(new List[0]), ASMBytecodeParser.this.result));
                    ++i;
                }
            }
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (!ASMBytecodeParser.this.readJava5Signatures) {
                return null;
            }
            AnnotationUseInfo currentAnnotation = new AnnotationUseInfo(ASMBytecodeParser.makeAnnotationString(desc), new ArrayList<ElementValuePair>(0));
            ASMBytecodeParser.this.classAnnotations.add(currentAnnotation);
            return new MyAnnotationVisitor(currentAnnotation);
        }

        public void visitAttribute(Attribute attr) {
        }

        public void visitEnd() {
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            ArrayList tas;
            String type;
            boolean isTypeParam;
            desc = ASMBytecodeParser.makeReplString(desc);
            if (!ASMBytecodeParser.this.readJava5Signatures) {
                signature = null;
            } else if (signature != null) {
                signature = ASMBytecodeParser.makeReplString(signature);
            }
            if (signature != null) {
                int p = 0;
                while (signature.charAt(p) == '[') {
                    ++p;
                }
                isTypeParam = signature.charAt(p) == 'T';
                MySignatureVisitor mv = new MySignatureVisitor();
                new SignatureReader(signature).acceptType((SignatureVisitor)mv);
                type = mv.mainType;
                tas = mv.fieldTAIs;
                if (tas != null) {
                    tas.trimToSize();
                }
            } else {
                isTypeParam = false;
                type = Type.getType((String)desc).getClassName();
                tas = Collections.emptyList();
            }
            FieldInfo f = (access & 0x4000) > 0 ? new EnumConstantInfo(access, name, type, ASMBytecodeParser.this.result, value == null ? null : value.toString(), tas) : new FieldInfo(access, name, type, isTypeParam, ASMBytecodeParser.this.result, value == null ? null : value.toString(), tas);
            f.typeArgs = tas;
            ASMBytecodeParser.this.fields.add(f);
            if (ASMBytecodeParser.this.readJava5Signatures) {
                ASMBytecodeParser.this.fieldAnnotations = new ArrayList(0);
                return new MyFieldVisitor();
            }
            return null;
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            if (outerName != null && outerName.equals(name.substring(0, name.lastIndexOf(36)))) {
                String nameRepl = ASMBytecodeParser.makeReplString(name);
                ASMBytecodeParser.this.innerClassesNames.add(nameRepl);
                if ((access & 8) == 0 && nameRepl.equals(ASMBytecodeParser.this.result.getFullName())) {
                    ((ASMBytecodeParser)ASMBytecodeParser.this).result.isInner = true;
                }
            } else if ((access & 8) == 0 && name.replace('/', '.').equals(ASMBytecodeParser.this.result.getBinaryName())) {
                ((ASMBytecodeParser)ASMBytecodeParser.this).result.isInner = true;
            }
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            String[] paramTypes;
            boolean resultIsTypeVar;
            String resType;
            if (name.equals("<clinit>")) {
                return null;
            }
            if (!ASMBytecodeParser.this.readJava5Signatures) {
                signature = null;
            }
            boolean isConstructor = name.equals("<init>");
            MySignatureVisitor sv = null;
            if (signature != null) {
                sv = new MySignatureVisitor();
                new SignatureReader(signature).accept((SignatureVisitor)sv);
                resType = sv.mainType;
                int checkAt = signature.indexOf(41) + 1;
                while (signature.charAt(checkAt) == '[') {
                    ++checkAt;
                }
                resultIsTypeVar = signature.charAt(checkAt) == 'T';
                paramTypes = sv.paramTypes.toArray(new String[0]);
                if (sv.exceptionNames.size() > 0) {
                    assert (sv.exceptionNames.size() == exceptions.length);
                    sv.exceptionNames.toArray(exceptions);
                }
            } else {
                resType = Type.getReturnType((String)desc).getClassName().replace('$', '.');
                resultIsTypeVar = false;
                paramTypes = ASMBytecodeParser.getAsStringArr(Type.getArgumentTypes((String)desc));
            }
            if (isConstructor) {
                ASMBytecodeParser.this.currentMethod = new ConstructorInfo(access, ASMBytecodeParser.this.result.getName(), paramTypes, ASMBytecodeParser.makeReplString(exceptions), ASMBytecodeParser.this.result);
                ASMBytecodeParser.this.constructors.add((ConstructorInfo)ASMBytecodeParser.this.currentMethod);
            } else {
                if ((ASMBytecodeParser.this.result.getAccessFlags() & 0x2000) != 0) {
                    ASMBytecodeParser.this.currentMethod = new AnnotationPropertyInfo(access, resType, resultIsTypeVar, name, ASMBytecodeParser.this.result, null);
                } else {
                    ASMBytecodeParser.this.currentMethod = new MethodInfo(access, resType, resultIsTypeVar, name, paramTypes, ASMBytecodeParser.makeReplString(exceptions), ASMBytecodeParser.this.result);
                }
                ASMBytecodeParser.this.methods.add(ASMBytecodeParser.this.currentMethod);
            }
            if (signature != null) {
                int totalSize = sv.paramTAIs.size() + 1;
                ((ASMBytecodeParser)ASMBytecodeParser.this).currentMethod.paramTypeArgs = sv.paramTAIs.toArray(new List[totalSize]);
                ((ASMBytecodeParser)ASMBytecodeParser.this).currentMethod.paramTypeArgs[totalSize - 1] = sv.returnTAIs;
                this.setTypeArgParentRec(((ASMBytecodeParser)ASMBytecodeParser.this).currentMethod.paramTypeArgs, ASMBytecodeParser.this.currentMethod);
                int tpCnt = sv.typeParamNames.size();
                ((ASMBytecodeParser)ASMBytecodeParser.this).currentMethod.typeParms = new ArrayList<TypeParameterInfo>(tpCnt);
                int i = 0;
                while (i < tpCnt) {
                    ((ASMBytecodeParser)ASMBytecodeParser.this).currentMethod.typeParms.add(new TypeParameterInfo((String)sv.typeParamNames.get(i), ((ArrayList)sv.typeParamBounds.get(i)).toArray(new String[0]), sv.typeParamTAIs.toArray(new List[0]), ASMBytecodeParser.this.currentMethod));
                    ++i;
                }
            }
            if (ASMBytecodeParser.this.readJava5Signatures) {
                ASMBytecodeParser.this.methodAnnotations = new ArrayList();
                ASMBytecodeParser.this.paramAnnotations = new ArrayList[paramTypes.length];
                int i = 0;
                while (i < paramTypes.length) {
                    ((ASMBytecodeParser)ASMBytecodeParser.this).paramAnnotations[i] = new ArrayList();
                    ++i;
                }
                return new MyMethodVisitor();
            }
            ASMBytecodeParser.this.currentMethod = null;
            return null;
        }

        public void visitOuterClass(String owner, String name, String desc) {
            if (name != null) {
                ((ASMBytecodeParser)ASMBytecodeParser.this).result.enclosingMethod = String.valueOf(owner) + "." + name + desc;
            }
        }

        public void visitSource(String source, String debug) {
        }

        private void setTypeArgParentRec(List<? extends TypeArgument>[] typeArgs, MethodInfo res) {
            int i = 0;
            while (i < typeArgs.length) {
                if (typeArgs[i] != null) {
                    this.setTypeArgParentRec(typeArgs[i], res);
                }
                ++i;
            }
        }

        private void setTypeArgParentRec(List<? extends TypeArgument> typeArgs, MethodInfo res) {
            for (TypeArgument typeArgument : typeArgs) {
                TypeArgumentInfo tai = (TypeArgumentInfo)typeArgument;
                tai.parent = res;
                if (tai.typeArgs == null) continue;
                this.setTypeArgParentRec(tai.typeArgs, res);
            }
        }
    }

    static enum CurrentlyParsing {
        RETURNTYPE,
        PARAMETER,
        TYPEARGUMENT,
        CLASSORINTERFACEBOUND,
        INTERFACE,
        SUPERCLASS,
        FORMALTYPEPARAM,
        EXCEPTION;

    }

    private static class MyAnnotationVisitor
    implements AnnotationVisitor {
        private String arrayName = null;
        private ArrayList<ArrayList<Object>> arrayValues = new ArrayList();
        private String arrayDesc = null;
        private AnnotationPropertyInfo setDefaultFor;
        private ArrayList<Object> nestedStack = new ArrayList();

        MyAnnotationVisitor(AnnotationUseInfo forAnnotationUse) {
            this.nestedStack.add(forAnnotationUse);
        }

        MyAnnotationVisitor(AnnotationPropertyInfo setDefaultFor) {
            this.setDefaultFor = setDefaultFor;
            this.nestedStack.add(null);
        }

        private ArrayList<Object> getCurrentArrayValueList() {
            return this.arrayValues.get(this.arrayValues.size() - 1);
        }

        private boolean isInArray() {
            Object o = this.nestedStack.get(this.nestedStack.size() - 1);
            return o != null && !(o instanceof AnnotationUseInfo);
        }

        private boolean isSettingDefault() {
            if (this.nestedStack.get(0) != null) {
                return false;
            }
            int i = this.nestedStack.size() - 1;
            while (i >= 1) {
                Object o = this.nestedStack.get(i);
                if (o instanceof AnnotationUseInfo) {
                    return false;
                }
                --i;
            }
            return true;
        }

        private AnnotationUseInfo getCurrentAnnotation() {
            int i = this.nestedStack.size() - 1;
            Object o;
            while (!((o = this.nestedStack.get(i)) instanceof AnnotationUseInfo)) {
                --i;
            }
            return (AnnotationUseInfo)o;
        }

        public void visitEnum(String name, String desc, String value) {
            EnumConstantReferenceInfo ecri = new EnumConstantReferenceInfo(ASMBytecodeParser.makeAnnotationString(desc), value);
            if (this.isInArray()) {
                assert (name == null);
                assert (this.arrayDesc == null || this.arrayDesc.equals(desc));
                this.arrayDesc = desc;
                this.getCurrentArrayValueList().add(ecri);
            } else if (this.isSettingDefault()) {
                this.setDefaultFor.defaultValue = ecri;
            } else {
                this.getCurrentAnnotation().elementValuePairs.add(new ElementValuePairInfo(name, ecri));
            }
        }

        public void visitEnd() {
            Object rem = this.nestedStack.remove(this.nestedStack.size() - 1);
            if (!(rem instanceof AnnotationUseInfo) && rem != null) {
                assert (this.arrayName != null || this.isSettingDefault());
                if (this.arrayName != null) {
                    this.getCurrentAnnotation().elementValuePairs.add(new ElementValuePairInfo(this.arrayName, this.getCurrentArrayValueList().toArray()));
                    this.arrayName = null;
                    this.arrayDesc = null;
                    this.arrayValues.remove(this.arrayValues.size() - 1);
                } else {
                    this.setDefaultFor.defaultValue = new Object[0];
                }
            }
        }

        public AnnotationVisitor visitArray(String name) {
            this.arrayName = name;
            this.arrayValues.add(new ArrayList());
            this.nestedStack.add(new Object());
            return this;
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            AnnotationUseInfo aui = new AnnotationUseInfo(ASMBytecodeParser.makeAnnotationString(desc), new ArrayList<ElementValuePair>(0));
            if (this.isInArray()) {
                assert (name == null);
                assert (this.arrayDesc == null || this.arrayDesc.equals(desc));
                this.arrayDesc = desc;
                this.getCurrentArrayValueList().add(aui);
            } else if (this.isSettingDefault()) {
                this.setDefaultFor.defaultValue = aui;
            } else {
                this.getCurrentAnnotation().elementValuePairs.add(new ElementValuePairInfo(name, aui));
            }
            this.nestedStack.add(aui);
            return this;
        }

        public void visit(String name, Object value) {
            if (this.isInArray()) {
                assert (name == null);
                this.getCurrentArrayValueList().add(value);
            } else if (this.isSettingDefault()) {
                this.setDefaultFor.defaultValue = value;
            } else {
                this.getCurrentAnnotation().elementValuePairs.add(new ElementValuePairInfo(name, value));
            }
        }
    }

    class MyFieldVisitor
    implements FieldVisitor {
        MyFieldVisitor() {
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            assert (ASMBytecodeParser.this.readJava5Signatures);
            AnnotationUseInfo currentAnnotation = new AnnotationUseInfo(ASMBytecodeParser.makeAnnotationString(desc), new ArrayList<ElementValuePair>(0));
            ASMBytecodeParser.this.fieldAnnotations.add(currentAnnotation);
            return new MyAnnotationVisitor(currentAnnotation);
        }

        public void visitAttribute(Attribute attr) {
        }

        public void visitEnd() {
            if (ASMBytecodeParser.this.readJava5Signatures) {
                ASMBytecodeParser.this.fieldAnnotations.trimToSize();
                ((FieldInfo)((ASMBytecodeParser)ASMBytecodeParser.this).fields.get((int)(((ASMBytecodeParser)ASMBytecodeParser.this).fields.size() - 1))).annotations = ASMBytecodeParser.this.fieldAnnotations;
                ASMBytecodeParser.this.fieldAnnotations = null;
            }
        }
    }

    class MyMethodVisitor
    extends EmptyVisitor {
        MyMethodVisitor() {
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            assert (ASMBytecodeParser.this.readJava5Signatures);
            AnnotationUseInfo currentAnnotation = new AnnotationUseInfo(ASMBytecodeParser.makeAnnotationString(desc), new ArrayList<ElementValuePair>(0));
            ASMBytecodeParser.this.methodAnnotations.add(currentAnnotation);
            return new MyAnnotationVisitor(currentAnnotation);
        }

        public AnnotationVisitor visitAnnotationDefault() {
            return new MyAnnotationVisitor((AnnotationPropertyInfo)ASMBytecodeParser.this.currentMethod);
        }

        public void visitAttribute(Attribute attr) {
        }

        public void visitEnd() {
            if (ASMBytecodeParser.this.readJava5Signatures) {
                ASMBytecodeParser.this.methodAnnotations.trimToSize();
                ((ASMBytecodeParser)ASMBytecodeParser.this).currentMethod.annotations = ASMBytecodeParser.this.methodAnnotations;
                ASMBytecodeParser.this.methodAnnotations = null;
                ((ASMBytecodeParser)ASMBytecodeParser.this).currentMethod.paramAnnotations = new AnnotationUseInfo[ASMBytecodeParser.this.paramAnnotations.length][];
                int i = 0;
                while (i < ASMBytecodeParser.this.paramAnnotations.length) {
                    ((ASMBytecodeParser)ASMBytecodeParser.this).currentMethod.paramAnnotations[i] = ASMBytecodeParser.this.paramAnnotations[i].toArray(new AnnotationUseInfo[ASMBytecodeParser.this.paramAnnotations[i].size()]);
                    ++i;
                }
                ASMBytecodeParser.this.paramAnnotations = null;
            }
            ASMBytecodeParser.this.currentMethod = null;
        }

        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            if (!ASMBytecodeParser.this.readJava5Signatures) {
                return null;
            }
            AnnotationUseInfo currentAnnotation = new AnnotationUseInfo(ASMBytecodeParser.makeAnnotationString(desc), new ArrayList<ElementValuePair>(0));
            ASMBytecodeParser.this.paramAnnotations[parameter].add(currentAnnotation);
            return new MyAnnotationVisitor(currentAnnotation);
        }
    }

    class MySignatureVisitor
    implements SignatureVisitor {
        private ArrayList<TypeArgumentInfo> curTAIs;
        private String mainType = null;
        private ArrayList<TypeArgumentInfo> returnTAIs;
        private ArrayList<TypeArgumentInfo> fieldTAIs;
        private ArrayList<ArrayList<TypeArgumentInfo>> paramTAIs = new ArrayList();
        private ArrayList<String> paramTypes = new ArrayList();
        private int dim = 0;
        private ArrayList<ArrayList<TypeArgumentInfo>> taiStack = new ArrayList();
        private TypeArgument.WildcardMode currentWM;
        private Stack<TypeArgument.WildcardMode> wmStack = new Stack();
        private String superClassName;
        private ArrayList<String> interfaceNames = new ArrayList();
        private ArrayList<TypeArgumentInfo> superClassTAIs;
        private ArrayList<ArrayList<TypeArgumentInfo>> interfaceTAIs = new ArrayList();
        private ArrayList<String> typeParamNames = new ArrayList();
        private ArrayList<ArrayList<String>> typeParamBounds = new ArrayList();
        private ArrayList<ArrayList<TypeArgumentInfo>> typeParamTAIs = new ArrayList();
        private ArrayList<String> exceptionNames = new ArrayList();
        private Stack<String> toAddStack = new Stack();
        private Stack<CurrentlyParsing> cpStack = new Stack();
        private CurrentlyParsing currentlyParsing;

        MySignatureVisitor() {
        }

        private void addType(String s, boolean isTypeVar, boolean isPrimitive) {
            if (!(isPrimitive | isTypeVar)) {
                s = ASMBytecodeParser.makeReplString(s);
            }
            boolean isArray = false;
            while (this.dim > 0) {
                isArray = true;
                s = String.valueOf(s) + "[]";
                --this.dim;
            }
            ArrayList newTAIs = new ArrayList(0);
            if (this.currentlyParsing == CurrentlyParsing.PARAMETER) {
                this.paramTAIs.add(newTAIs);
                if (isTypeVar | isPrimitive) {
                    this.paramTypes.add(s);
                }
            } else if (this.currentlyParsing == CurrentlyParsing.RETURNTYPE) {
                if (isTypeVar) {
                    this.mainType = s;
                } else {
                    this.returnTAIs = newTAIs;
                    if (isPrimitive) {
                        this.mainType = s;
                    }
                }
            } else if (this.currentlyParsing == CurrentlyParsing.TYPEARGUMENT) {
                if (isTypeVar || s == null) {
                    TypeArgumentInfo tai = new TypeArgumentInfo(this.currentWM, s, null, (ClassTypeContainer)((Object)(ASMBytecodeParser.this.currentMethod == null ? ASMBytecodeParser.this.result : ASMBytecodeParser.this.currentMethod)), s != null);
                    this.curTAIs.add(tai);
                } else {
                    this.wmStack.push(this.currentWM);
                }
                assert (isArray || !isPrimitive) : "assertion error while parsing " + ASMBytecodeParser.access$1(ASMBytecodeParser.this).getLocation();
            } else if (this.currentlyParsing == CurrentlyParsing.CLASSORINTERFACEBOUND) {
                this.typeParamTAIs.add(newTAIs);
            } else if (this.currentlyParsing == null) {
                if (isTypeVar) {
                    this.mainType = s;
                }
                this.fieldTAIs = newTAIs;
                assert (!isPrimitive);
            } else if (this.currentlyParsing == CurrentlyParsing.INTERFACE) {
                if (isTypeVar) {
                    throw new RuntimeException("???");
                }
                this.interfaceTAIs.add(newTAIs);
            } else if (this.currentlyParsing == CurrentlyParsing.SUPERCLASS) {
                this.superClassTAIs = newTAIs;
                assert (!isTypeVar);
            } else if (this.currentlyParsing == CurrentlyParsing.FORMALTYPEPARAM) {
                this.typeParamNames.add(s);
                this.typeParamBounds.add(new ArrayList(0));
            } else if (this.currentlyParsing == CurrentlyParsing.EXCEPTION) {
                if (isTypeVar) {
                    this.exceptionNames.add(s);
                }
                assert (!isPrimitive);
            } else {
                throw new RuntimeException();
            }
            if (!(s == null || isTypeVar || !isArray && isPrimitive)) {
                this.curTAIs = newTAIs;
                this.taiStack.add(this.curTAIs);
                this.cpStack.add(this.currentlyParsing);
                this.toAddStack.add(s);
            }
        }

        public void visitEnd() {
            assert (this.dim == 0);
            List oldTAIs = this.taiStack.remove(this.taiStack.size() - 1);
            this.curTAIs = !this.taiStack.isEmpty() ? this.taiStack.get(this.taiStack.size() - 1) : null;
            String s = this.toAddStack.pop();
            this.currentlyParsing = this.cpStack.pop();
            if (this.currentlyParsing == CurrentlyParsing.PARAMETER) {
                this.paramTypes.add(s);
            } else if (this.currentlyParsing == CurrentlyParsing.RETURNTYPE) {
                this.mainType = s;
            } else if (this.currentlyParsing == CurrentlyParsing.TYPEARGUMENT) {
                this.currentWM = this.wmStack.pop();
                TypeArgumentInfo tai = new TypeArgumentInfo(this.currentWM, s, oldTAIs, (ClassTypeContainer)((Object)(ASMBytecodeParser.this.currentMethod == null ? ASMBytecodeParser.this.result : ASMBytecodeParser.this.currentMethod)), false);
                this.curTAIs.add(tai);
            } else if (this.currentlyParsing == CurrentlyParsing.CLASSORINTERFACEBOUND) {
                this.typeParamBounds.get(this.typeParamBounds.size() - 1).add(s);
            } else if (this.currentlyParsing == null) {
                this.mainType = s;
            } else if (this.currentlyParsing == CurrentlyParsing.INTERFACE) {
                this.interfaceNames.add(s);
            } else if (this.currentlyParsing == CurrentlyParsing.SUPERCLASS) {
                this.superClassName = s;
            } else if (this.currentlyParsing != CurrentlyParsing.FORMALTYPEPARAM) {
                if (this.currentlyParsing == CurrentlyParsing.EXCEPTION) {
                    this.exceptionNames.add(s);
                } else {
                    throw new RuntimeException();
                }
            }
        }

        public SignatureVisitor visitArrayType() {
            ++this.dim;
            return this;
        }

        public void visitBaseType(char descriptor) {
            this.addType(Type.getType((String)String.valueOf(descriptor)).getClassName(), false, true);
        }

        public SignatureVisitor visitClassBound() {
            this.currentlyParsing = CurrentlyParsing.CLASSORINTERFACEBOUND;
            return this;
        }

        public SignatureVisitor visitInterfaceBound() {
            this.currentlyParsing = CurrentlyParsing.CLASSORINTERFACEBOUND;
            return this;
        }

        public void visitTypeArgument() {
            this.currentlyParsing = CurrentlyParsing.TYPEARGUMENT;
            this.currentWM = TypeArgument.WildcardMode.Any;
            this.addType(null, false, false);
        }

        public SignatureVisitor visitTypeArgument(char wildcard) {
            this.currentlyParsing = CurrentlyParsing.TYPEARGUMENT;
            switch (wildcard) {
                case '+': {
                    this.currentWM = TypeArgument.WildcardMode.Extends;
                    break;
                }
                case '-': {
                    this.currentWM = TypeArgument.WildcardMode.Super;
                    break;
                }
                case '=': {
                    this.currentWM = TypeArgument.WildcardMode.None;
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            return this;
        }

        public void visitClassType(String name) {
            this.addType(name, false, false);
        }

        public void visitTypeVariable(String name) {
            this.addType(name, true, false);
        }

        public SignatureVisitor visitExceptionType() {
            this.currentlyParsing = CurrentlyParsing.EXCEPTION;
            return this;
        }

        public void visitFormalTypeParameter(String name) {
            this.currentlyParsing = CurrentlyParsing.FORMALTYPEPARAM;
            this.addType(name, false, false);
        }

        public void visitInnerClassType(String name) {
            String old = this.toAddStack.pop();
            this.toAddStack.add(String.valueOf(old) + "." + name);
        }

        public SignatureVisitor visitInterface() {
            this.currentlyParsing = CurrentlyParsing.INTERFACE;
            return this;
        }

        public SignatureVisitor visitParameterType() {
            this.currentlyParsing = CurrentlyParsing.PARAMETER;
            return this;
        }

        public SignatureVisitor visitReturnType() {
            this.currentlyParsing = CurrentlyParsing.RETURNTYPE;
            return this;
        }

        public SignatureVisitor visitSuperclass() {
            this.currentlyParsing = CurrentlyParsing.SUPERCLASS;
            return this;
        }
    }
}

