/*
 * Decompiled with CFR 0.152.
 */
package recoder.abstraction;

import java.util.ArrayList;
import java.util.List;
import recoder.abstraction.ClassType;
import recoder.abstraction.ClassTypeContainer;
import recoder.abstraction.Method;
import recoder.abstraction.TypeArgument;

public interface TypeParameter
extends ClassType {
    public String getParameterName();

    public int getBoundCount();

    public String getBoundName(int var1);

    public List<? extends TypeArgument> getBoundTypeArguments(int var1);

    public boolean inheritanceEqual(TypeParameter var1);

    public static class DescrImp {
        public static String getFullSignature(TypeParameter tp) {
            String res = tp.getParameterName();
            String del = " extends ";
            int i = 0;
            while (i < tp.getBoundCount()) {
                res = String.valueOf(res) + del;
                res = String.valueOf(res) + tp.getBoundName(i);
                List<? extends TypeArgument> tas = tp.getBoundTypeArguments(i);
                if (tas != null && tas.size() > 0) {
                    res = String.valueOf(res) + "<";
                    String delim2 = "";
                    for (TypeArgument typeArgument : tas) {
                        res = String.valueOf(res) + delim2;
                        res = String.valueOf(res) + typeArgument.getFullSignature();
                        delim2 = ",";
                    }
                    res = String.valueOf(res) + ">";
                }
                del = ",";
                ++i;
            }
            return res;
        }
    }

    public static class EqualsImplementor {
        private static boolean checkSameBounds(TypeParameter tp1, TypeParameter tp2) {
            int tp1s = tp1.getBoundCount();
            int tp2s = tp2.getBoundCount();
            if (tp2s - tp1s < -1 || tp1s - tp2s > 1) {
                return false;
            }
            if (tp1s != tp2s) {
                return false;
            }
            ArrayList<String> l1 = new ArrayList<String>();
            ArrayList<String> l2 = new ArrayList<String>();
            int i = 0;
            while (i < tp1.getBoundCount()) {
                l1.add(tp1.getBoundName(i));
                ++i;
            }
            i = 0;
            while (i < tp2.getBoundCount()) {
                l2.add(tp2.getBoundName(i));
                ++i;
            }
            if (!l1.contains("java.lang.Object")) {
                l1.add("java.lang.Object");
            }
            if (!l2.contains("java.lang.Object")) {
                l2.add("java.lang.Object");
            }
            if (l1.size() != l2.size()) {
                return false;
            }
            return l1.containsAll(l2);
        }

        public static boolean matchButNotEqual(TypeParameter t1, TypeParameter t2) {
            if (t1 == t2) {
                return true;
            }
            ClassTypeContainer ctc1 = t1.getContainer();
            ClassTypeContainer ctc2 = t2.getContainer();
            if (ctc1 instanceof Method && ctc2 instanceof Method) {
                return EqualsImplementor.checkSameBounds(t1, t2);
            }
            return false;
        }
    }
}

