/*
 * Decompiled with CFR 0.152.
 */
package recoder.abstraction;

import java.util.List;
import recoder.ModelException;
import recoder.abstraction.AnnotationUse;
import recoder.abstraction.ArrayType;
import recoder.abstraction.ClassType;
import recoder.abstraction.ClassTypeContainer;
import recoder.abstraction.Constructor;
import recoder.abstraction.Field;
import recoder.abstraction.Method;
import recoder.abstraction.Package;
import recoder.abstraction.Type;
import recoder.abstraction.TypeParameter;
import recoder.bytecode.TypeArgumentInfo;
import recoder.convenience.Naming;
import recoder.java.declaration.TypeArgumentDeclaration;
import recoder.java.reference.TypeReference;
import recoder.service.DefaultImplicitElementInfo;
import recoder.service.ImplicitElementInfo;
import recoder.service.ProgramModelInfo;

public interface TypeArgument {
    public WildcardMode getWildcardMode();

    public String getTypeName();

    public List<? extends TypeArgument> getTypeArguments();

    public boolean isTypeVariable();

    public TypeParameter getTargetedTypeParameter();

    public boolean semanticalEquality(TypeArgument var1);

    public int semanticalHashCode();

    public String getFullSignature();

    public static class CapturedTypeArgument
    implements ClassType {
        private final TypeArgument parent;
        private final ImplicitElementInfo service;
        private ArrayType array;

        public CapturedTypeArgument(TypeArgument ta, ImplicitElementInfo service) {
            this.parent = ta;
            this.service = service;
        }

        public TypeArgument getTypeArgument() {
            return this.parent;
        }

        @Override
        public List<Field> getAllFields() {
            return this.service.getAllFields(this);
        }

        @Override
        public List<Method> getAllMethods() {
            return this.service.getAllMethods(this);
        }

        @Override
        public List<ClassType> getAllSupertypes() {
            return this.service.getAllSupertypes(this);
        }

        @Override
        public List<ClassType> getAllTypes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<? extends Constructor> getConstructors() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ClassType getErasedType() {
            return this;
        }

        @Override
        public List<? extends Field> getFields() {
            return this.service.getFields(this);
        }

        @Override
        public String getFullSignature() {
            return "capture of " + this.parent.getFullSignature();
        }

        @Override
        public List<Method> getMethods() {
            return this.service.getMethods(this);
        }

        @Override
        public List<ClassType> getSupertypes() {
            return this.service.getSupertypes(this);
        }

        @Override
        public List<? extends TypeParameter> getTypeParameters() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isAbstract() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isAnnotationType() {
            throw new RuntimeException();
        }

        @Override
        public boolean isEnumType() {
            throw new RuntimeException();
        }

        @Override
        public boolean isInner() {
            return false;
        }

        @Override
        public boolean isInterface() {
            throw new RuntimeException();
        }

        @Override
        public boolean isOrdinaryClass() {
            throw new RuntimeException();
        }

        @Override
        public boolean isOrdinaryInterface() {
            throw new RuntimeException();
        }

        @Override
        public ArrayType createArrayType() {
            if (this.array == null) {
                this.array = new ArrayType(this, this.getProgramModelInfo().getServiceConfiguration().getImplicitElementInfo());
            }
            return this.array;
        }

        @Override
        public ArrayType getArrayType() {
            return this.array;
        }

        @Override
        public String getFullName() {
            return this.getFullSignature();
        }

        @Override
        public String getBinaryName() {
            return this.getFullSignature();
        }

        @Override
        public ImplicitElementInfo getProgramModelInfo() {
            return this.service;
        }

        @Override
        public void setProgramModelInfo(ProgramModelInfo pmi) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void validate() throws ModelException {
        }

        @Override
        public List<? extends AnnotationUse> getAnnotations() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ClassType getContainingClassType() {
            throw new RuntimeException();
        }

        @Override
        public boolean isFinal() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isPrivate() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isProtected() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isPublic() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isStatic() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isStrictFp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ClassTypeContainer getContainer() {
            return null;
        }

        @Override
        public Package getPackage() {
            return null;
        }

        @Override
        public List<? extends ClassType> getTypes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ClassType getBaseClassType() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class DescriptionImpl {
        public static String getFullDescription(TypeArgument ta) {
            String res;
            switch (ta.getWildcardMode()) {
                case None: {
                    res = "";
                    break;
                }
                case Any: {
                    return "?";
                }
                case Extends: {
                    res = "? extends ";
                    break;
                }
                case Super: {
                    res = "? super ";
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            res = String.valueOf(res) + ta.getTypeName();
            List<? extends TypeArgument> targs = ta.getTypeArguments();
            if (targs == null || targs.size() == 0) {
                return res;
            }
            res = String.valueOf(res) + "<";
            String delim = "";
            for (TypeArgument typeArgument : ta.getTypeArguments()) {
                res = String.valueOf(res) + delim;
                res = String.valueOf(res) + typeArgument.getFullSignature();
                delim = ",";
            }
            res = String.valueOf(res) + ">";
            return res;
        }

        public static String getFullDescription(TypeArgumentDeclaration ta, boolean alreadyFullyQualified) {
            String res;
            assert (alreadyFullyQualified);
            switch (ta.getWildcardMode()) {
                case None: {
                    res = "";
                    break;
                }
                case Any: {
                    return "?";
                }
                case Extends: {
                    res = "? extends ";
                    break;
                }
                case Super: {
                    res = "? super ";
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            res = String.valueOf(res) + Naming.toPathName(ta.getTypeReference());
            List targs = ta.getTypeArguments();
            if (targs == null || targs.size() == 0) {
                return res;
            }
            res = String.valueOf(res) + "<";
            String delim = "";
            for (TypeArgumentDeclaration ta_sub : ta.getTypeArguments()) {
                res = String.valueOf(res) + delim;
                res = String.valueOf(res) + DescriptionImpl.getFullDescription(ta_sub, true);
                delim = ",";
            }
            res = String.valueOf(res) + ">";
            return res;
        }
    }

    public static final class EqualsImpl {
        private static Type getTypeParameterFromTAInfo(TypeArgument ta, DefaultImplicitElementInfo si) {
            if (ta instanceof TypeArgumentInfo) {
                TypeArgumentInfo tai1 = (TypeArgumentInfo)ta;
                return tai1.getTypeParameter();
            }
            TypeReference typeReference = ((TypeArgumentDeclaration)ta).getTypeReference();
            return si.getServiceConfiguration().getSourceInfo().getType(typeReference);
        }

        public static int semanticalHashCode(TypeArgument ta) {
            int res = 0;
            switch (ta.getWildcardMode()) {
                case None: {
                    res = 12315;
                    break;
                }
                case Super: {
                    res = 135091;
                    break;
                }
                case Extends: {
                    res = 1571251;
                    break;
                }
                case Any: {
                    return 9123561;
                }
            }
            List<? extends TypeArgument> tas = ta.getTypeArguments();
            if (tas != null) {
                res += tas.size() << 16;
                int i = 0;
                while (i < tas.size()) {
                    res += EqualsImpl.semanticalHashCode(tas.get(i));
                    ++i;
                }
            }
            return res += ta.getTypeName().hashCode();
        }

        public static boolean equals(TypeArgument ta1, TypeArgument ta2, DefaultImplicitElementInfo si) {
            int s2;
            if (ta1 == ta2) {
                return true;
            }
            if (ta1.getWildcardMode() != ta2.getWildcardMode()) {
                return false;
            }
            Type tp1 = null;
            Type tp2 = null;
            if (ta1.isTypeVariable() && ta2.isTypeVariable()) {
                if (ta1.getTypeName().equals(ta2.getTypeName())) {
                    tp1 = EqualsImpl.getTypeParameterFromTAInfo(ta1, si);
                    return tp1 == (tp2 = EqualsImpl.getTypeParameterFromTAInfo(ta2, si));
                }
                return false;
            }
            if (ta1.isTypeVariable() || ta2.isTypeVariable()) {
                return false;
            }
            String n1 = ta1.getTypeName();
            String n2 = ta2.getTypeName();
            if (n1 == null && n2 == null) {
                assert (ta1.getWildcardMode() == WildcardMode.Any);
                assert (ta2.getWildcardMode() == WildcardMode.Any);
                return true;
            }
            if (n1 == null || n2 == null) {
                return false;
            }
            if (!n1.equals(n2)) {
                return false;
            }
            List<? extends TypeArgument> ta1args = ta1.getTypeArguments();
            List<? extends TypeArgument> ta2args = ta2.getTypeArguments();
            int s1 = ta1args == null ? 0 : ta1args.size();
            int n = s2 = ta2args == null ? 0 : ta2args.size();
            if (s1 != s2) {
                assert (s1 == 0 || s2 == 0);
                return false;
            }
            if (s1 == 0) {
                return true;
            }
            int i = 0;
            while (i < s1) {
                if (!EqualsImpl.equals(ta1args.get(i), ta2args.get(i), si)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    public static enum WildcardMode {
        None,
        Any,
        Extends,
        Super;

    }
}

