/*
 * Decompiled with CFR 0.152.
 */
package recoder.abstraction;

import java.util.List;
import recoder.ModelException;
import recoder.abstraction.AnnotationUse;
import recoder.abstraction.ClassType;
import recoder.abstraction.ClassTypeContainer;
import recoder.abstraction.Method;
import recoder.abstraction.Package;
import recoder.abstraction.Type;
import recoder.abstraction.TypeParameter;
import recoder.service.ImplicitElementInfo;
import recoder.service.ProgramModelInfo;

public class ResolvedGenericMethod
implements Method {
    private final Method genericMethod;
    private final boolean inferred;
    private final List<ClassType> types;
    private final ImplicitElementInfo service;

    public ResolvedGenericMethod(Method genericMethod, boolean inferred, List<ClassType> types, ImplicitElementInfo service) {
        this.genericMethod = genericMethod;
        this.inferred = inferred;
        this.types = types;
        this.service = service;
        assert (types.size() == genericMethod.getTypeParameters().size());
        assert (!(genericMethod instanceof ResolvedGenericMethod));
    }

    public Method getGenericMethod() {
        return this.genericMethod;
    }

    public List<ClassType> getReplacementType() {
        return this.types;
    }

    public boolean isInferred() {
        return this.inferred;
    }

    @Override
    public List<ClassType> getExceptions() {
        return this.service.getExceptions(this);
    }

    @Override
    public Type getReturnType() {
        return this.service.getReturnType(this);
    }

    @Override
    public List<Type> getSignature() {
        return this.service.getSignature(this);
    }

    @Override
    public List<? extends TypeParameter> getTypeParameters() {
        return null;
    }

    @Override
    public boolean isAbstract() {
        return this.genericMethod.isAbstract();
    }

    @Override
    public boolean isNative() {
        return this.genericMethod.isNative();
    }

    @Override
    public boolean isSynchronized() {
        return this.genericMethod.isSynchronized();
    }

    @Override
    public boolean isVarArgMethod() {
        return this.genericMethod.isVarArgMethod();
    }

    @Override
    public List<? extends AnnotationUse> getAnnotations() {
        return this.genericMethod.getAnnotations();
    }

    @Override
    public ClassType getContainingClassType() {
        return this.genericMethod.getContainingClassType();
    }

    @Override
    public boolean isFinal() {
        return this.genericMethod.isFinal();
    }

    @Override
    public boolean isPrivate() {
        return this.genericMethod.isPrivate();
    }

    @Override
    public boolean isProtected() {
        return this.genericMethod.isProtected();
    }

    @Override
    public boolean isPublic() {
        return this.genericMethod.isPublic();
    }

    @Override
    public boolean isStatic() {
        return this.genericMethod.isStatic();
    }

    @Override
    public boolean isStrictFp() {
        return this.genericMethod.isStrictFp();
    }

    @Override
    public String getFullName() {
        return this.genericMethod.getFullName();
    }

    @Override
    public String getBinaryName() {
        return this.genericMethod.getBinaryName();
    }

    @Override
    public ProgramModelInfo getProgramModelInfo() {
        return this.service;
    }

    @Override
    public void setProgramModelInfo(ProgramModelInfo pmi) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return this.genericMethod.getName();
    }

    @Override
    public void validate() throws ModelException {
    }

    @Override
    public ClassTypeContainer getContainer() {
        return this.genericMethod.getContainer();
    }

    @Override
    public Package getPackage() {
        return this.genericMethod.getPackage();
    }

    @Override
    public List<? extends ClassType> getTypes() {
        return this.service.getTypes(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResolvedGenericMethod)) {
            return false;
        }
        ResolvedGenericMethod rgm = (ResolvedGenericMethod)o;
        if (!rgm.genericMethod.equals(this.genericMethod)) {
            return false;
        }
        int i = 0;
        while (i < this.types.size()) {
            if (this.types.get(i) != rgm.types.get(i) || this.types.get(i) != null && !this.types.get(i).equals(rgm.types.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return this.genericMethod.hashCode();
    }
}

