/*
 * Decompiled with CFR 0.152.
 */
package recoder.abstraction;

import java.util.List;
import recoder.abstraction.ArrayType;
import recoder.abstraction.Type;
import recoder.service.ProgramModelInfo;

public class PrimitiveType
implements Type {
    private ArrayType arrayType;
    private String name;
    private ProgramModelInfo pmi;

    public PrimitiveType(String name) {
        this.name = name.intern();
    }

    @Override
    public ArrayType getArrayType() {
        return this.arrayType;
    }

    @Override
    public ArrayType createArrayType() {
        if (this.arrayType == null) {
            this.arrayType = new ArrayType(this, this.pmi.getServiceConfiguration().getImplicitElementInfo());
        }
        return this.arrayType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFullName() {
        return this.name;
    }

    @Override
    public String getBinaryName() {
        return this.name;
    }

    @Override
    public ProgramModelInfo getProgramModelInfo() {
        return this.pmi;
    }

    @Override
    public void setProgramModelInfo(ProgramModelInfo service) {
        if (this.pmi != null) {
            throw new RuntimeException("Service already set!");
        }
        this.pmi = service;
    }

    @Override
    public void validate() {
    }

    @Override
    public String getFullSignature() {
        return this.getFullName();
    }

    public PrimitiveType deepClone() {
        throw new UnsupportedOperationException("Cannot deep-clone primitive types");
    }

    public List<PrimitiveType> getAllSupertypes() {
        return this.pmi.getAllSupertypes(this);
    }

    public List<PrimitiveType> getSupertypes() {
        return this.pmi.getSupertypes(this);
    }

    public String toString() {
        return "<Primitive Type> " + this.name;
    }
}

