/*
 * Decompiled with CFR 0.152.
 */
package recoder.abstraction;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import recoder.ModelException;
import recoder.abstraction.AnnotationUse;
import recoder.abstraction.ArrayType;
import recoder.abstraction.ClassType;
import recoder.abstraction.ClassTypeContainer;
import recoder.abstraction.Constructor;
import recoder.abstraction.ErasedType;
import recoder.abstraction.Field;
import recoder.abstraction.Method;
import recoder.abstraction.Package;
import recoder.abstraction.TypeArgument;
import recoder.abstraction.TypeParameter;
import recoder.service.ImplicitElementInfo;
import recoder.service.ProgramModelInfo;

public class ParameterizedType
implements ClassType {
    private final ClassType genericType;
    private final List<? extends TypeArgument> typeArgs;
    private final ParameterizedType enclosingType;
    private final int hashCode;
    private ArrayType arrayType;
    private final ImplicitElementInfo pmi;
    private List<TypeArgument> allTypeArgs = null;

    public ParameterizedType(ClassType genericType, List<? extends TypeArgument> typeArgs, ImplicitElementInfo service) {
        this(genericType, typeArgs, null, service);
    }

    public ParameterizedType(ClassType innerGenericType, List<? extends TypeArgument> typeArgs, ParameterizedType enclosingType, ImplicitElementInfo service) {
        if (innerGenericType == null) {
            throw new NullPointerException();
        }
        if (typeArgs == null) {
            typeArgs = Collections.emptyList();
        }
        this.genericType = innerGenericType;
        this.typeArgs = typeArgs;
        this.pmi = service;
        this.enclosingType = enclosingType;
        assert (typeArgs.size() != 0 || enclosingType != null);
        int hash = this.genericType.hashCode();
        if (enclosingType != null) {
            hash += enclosingType.hashCode;
        }
        hash += typeArgs.size();
        int i = 0;
        while (i < typeArgs.size()) {
            TypeArgument ta = typeArgs.get(i);
            hash += ta.semanticalHashCode();
            ++i;
        }
        this.hashCode = hash;
    }

    public List<TypeParameter> getDefinedTypeParameters() {
        if (this.genericType.getTypeParameters() == null) {
            return this.enclosingType.getDefinedTypeParameters();
        }
        List outerTPs = this.enclosingType == null ? Collections.emptyList() : this.enclosingType.getDefinedTypeParameters();
        int sz = this.genericType.getTypeParameters().size() + outerTPs.size();
        ArrayList<TypeParameter> res = new ArrayList<TypeParameter>(sz);
        res.addAll(this.genericType.getTypeParameters());
        res.addAll(outerTPs);
        return res;
    }

    @Override
    public ArrayType getArrayType() {
        return this.arrayType;
    }

    @Override
    public ArrayType createArrayType() {
        if (this.arrayType == null) {
            this.arrayType = new ArrayType(this, this.pmi.getServiceConfiguration().getImplicitElementInfo());
        }
        return this.arrayType;
    }

    public ClassType getGenericType() {
        return this.genericType;
    }

    public ParameterizedType getEnclosingType() {
        return this.enclosingType;
    }

    public List<TypeArgument> getAllTypeArgs() {
        if (this.allTypeArgs != null) {
            return this.allTypeArgs;
        }
        List outerArgs = this.enclosingType == null ? Collections.emptyList() : this.enclosingType.getAllTypeArgs();
        int sz = this.typeArgs.size() + outerArgs.size();
        ArrayList<TypeArgument> res = new ArrayList<TypeArgument>(sz);
        res.addAll(this.typeArgs);
        res.addAll(outerArgs);
        this.allTypeArgs = res;
        return res;
    }

    public List<? extends TypeArgument> getTypeArgs() {
        return this.typeArgs;
    }

    @Override
    public String getFullName() {
        return this.genericType.getFullName();
    }

    @Override
    public String getBinaryName() {
        return this.genericType.getBinaryName();
    }

    @Override
    public ImplicitElementInfo getProgramModelInfo() {
        return this.pmi;
    }

    @Override
    public void setProgramModelInfo(ProgramModelInfo pmi) {
        throw new RuntimeException("ParameterizedType.setProgramModelInfo must not be called!");
    }

    @Override
    public String getName() {
        return this.genericType.getName();
    }

    @Override
    public void validate() throws ModelException {
    }

    public List<TypeParameter> getTypeParameters() {
        return Collections.emptyList();
    }

    @Override
    public boolean isInterface() {
        return this.genericType.isInterface();
    }

    @Override
    public boolean isOrdinaryInterface() {
        return this.genericType.isOrdinaryInterface();
    }

    @Override
    public boolean isAnnotationType() {
        return this.genericType.isAnnotationType();
    }

    @Override
    public boolean isEnumType() {
        return this.genericType.isEnumType();
    }

    @Override
    public boolean isOrdinaryClass() {
        return this.genericType.isOrdinaryClass();
    }

    @Override
    public boolean isAbstract() {
        return this.genericType.isAbstract();
    }

    @Override
    public List<ClassType> getSupertypes() {
        return this.pmi.getSupertypes(this);
    }

    @Override
    public List<ClassType> getAllSupertypes() {
        return this.pmi.getAllSupertypes(this);
    }

    @Override
    public List<? extends Field> getFields() {
        return this.pmi.getFields(this);
    }

    @Override
    public List<Field> getAllFields() {
        return this.pmi.getAllFields(this);
    }

    @Override
    public List<Method> getMethods() {
        return this.pmi.getMethods(this);
    }

    @Override
    public List<Method> getAllMethods() {
        return this.pmi.getAllMethods(this);
    }

    @Override
    public List<? extends Constructor> getConstructors() {
        return this.pmi.getConstructors(this);
    }

    @Override
    public List<ClassType> getAllTypes() {
        return this.pmi.getAllTypes(this);
    }

    @Override
    public boolean isFinal() {
        return this.genericType.isFinal();
    }

    @Override
    public boolean isStatic() {
        return this.genericType.isStatic();
    }

    @Override
    public boolean isPrivate() {
        return this.genericType.isPrivate();
    }

    @Override
    public boolean isProtected() {
        return this.genericType.isProtected();
    }

    @Override
    public boolean isPublic() {
        return this.genericType.isPublic();
    }

    @Override
    public boolean isStrictFp() {
        return this.genericType.isStrictFp();
    }

    @Override
    public ClassType getContainingClassType() {
        return this.genericType.getContainingClassType();
    }

    @Override
    public List<? extends AnnotationUse> getAnnotations() {
        return this.genericType.getAnnotations();
    }

    @Override
    public List<? extends ClassType> getTypes() {
        return this.pmi.getTypes(this);
    }

    @Override
    public Package getPackage() {
        return this.genericType.getPackage();
    }

    @Override
    public ClassTypeContainer getContainer() {
        return this.genericType.getContainer();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType pt = (ParameterizedType)o;
        if (pt == this) {
            return true;
        }
        if (pt.pmi != this.pmi) {
            return false;
        }
        if (pt.getGenericType() != this.getGenericType()) {
            return false;
        }
        List<TypeArgument> ta1 = this.getAllTypeArgs();
        List<TypeArgument> ta2 = pt.getAllTypeArgs();
        if (ta1.size() != ta2.size()) {
            return false;
        }
        int i = 0;
        while (i < ta1.size()) {
            if (!ta1.get(i).semanticalEquality(ta2.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public String getFullSignature() {
        String res = this.enclosingType != null ? String.valueOf(this.enclosingType.getFullSignature()) + "." + this.getName() : this.getFullName();
        if (this.typeArgs.size() == 0) {
            return res;
        }
        res = String.valueOf(res) + "<";
        String del = "";
        for (TypeArgument typeArgument : this.getTypeArgs()) {
            res = String.valueOf(res) + del + typeArgument.getFullSignature();
            del = ",";
        }
        res = String.valueOf(res) + ">";
        return res;
    }

    public String toString() {
        return this.getFullSignature();
    }

    @Override
    public ErasedType getErasedType() {
        return (ErasedType)this.getGenericType().getErasedType();
    }

    @Override
    public boolean isInner() {
        return this.genericType.isInner();
    }

    @Override
    public ClassType getBaseClassType() {
        return this.genericType;
    }
}

