/*
 * Decompiled with CFR 0.152.
 */
package recoder.abstraction;

import java.util.List;
import recoder.ModelException;
import recoder.abstraction.AnnotationUse;
import recoder.abstraction.ClassType;
import recoder.abstraction.ClassTypeContainer;
import recoder.bytecode.ClassFile;
import recoder.java.CompilationUnit;
import recoder.service.ImplicitElementInfo;
import recoder.service.ProgramModelInfo;
import recoder.util.Debug;

public class Package
implements ClassTypeContainer {
    private String name;
    private ImplicitElementInfo pmi;

    public Package(String name, ImplicitElementInfo pmi) {
        Debug.assertNonnull(name);
        this.name = name;
        this.pmi = pmi;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFullName() {
        return this.getName();
    }

    @Override
    public String getBinaryName() {
        return this.getName();
    }

    @Override
    public ProgramModelInfo getProgramModelInfo() {
        return this.pmi;
    }

    @Override
    public void setProgramModelInfo(ProgramModelInfo service) {
        this.pmi = (ImplicitElementInfo)service;
    }

    @Override
    public List<? extends ClassType> getTypes() {
        return this.pmi.getTypes(this);
    }

    public List<? extends AnnotationUse> getPackageAnnotations() {
        CompilationUnit cl = this.pmi.getServiceConfiguration().getSourceFileRepository().getCompilationUnit(String.valueOf(this.getFullName()) + ".package-info");
        if (cl != null) {
            return cl.getPackageSpecification().getAnnotations();
        }
        ClassFile cf = this.pmi.getServiceConfiguration().getClassFileRepository().getClassFile(String.valueOf(this.getFullName()) + ".package-info");
        if (cf != null) {
            return cf.getAnnotations();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public ClassTypeContainer getContainer() {
        return null;
    }

    @Override
    public Package getPackage() {
        return this;
    }

    @Override
    public void validate() throws ModelException {
    }
}

