/*
 * Decompiled with CFR 0.152.
 */
package recoder.abstraction;

import java.util.ArrayList;
import java.util.List;
import recoder.ModelException;
import recoder.abstraction.AnnotationUse;
import recoder.abstraction.ArrayType;
import recoder.abstraction.ClassType;
import recoder.abstraction.ClassTypeContainer;
import recoder.abstraction.Constructor;
import recoder.abstraction.ErasedType;
import recoder.abstraction.Field;
import recoder.abstraction.Method;
import recoder.abstraction.Package;
import recoder.abstraction.Type;
import recoder.abstraction.TypeParameter;
import recoder.service.ImplicitElementInfo;
import recoder.service.ProgramModelInfo;

public class IntersectionType
implements ClassType {
    private final List<ClassType> types;
    private ImplicitElementInfo pmi;
    private ClassType accessibility;

    public IntersectionType(List<ClassType> types, ImplicitElementInfo pmi) {
        this.types = types;
        this.pmi = pmi;
    }

    @Override
    public String getFullName() {
        StringBuilder res = new StringBuilder();
        int i = 0;
        while (i < this.types.size()) {
            if (i != 0) {
                res.append(" & ");
            }
            res.append(this.types.get(i).getFullName());
            ++i;
        }
        return res.toString();
    }

    @Override
    public String getBinaryName() {
        StringBuilder res = new StringBuilder();
        int i = 0;
        while (i < this.types.size()) {
            if (i != 0) {
                res.append(" & ");
            }
            res.append(this.types.get(i).getBinaryName());
            ++i;
        }
        return res.toString();
    }

    @Override
    public ArrayType getArrayType() {
        return null;
    }

    @Override
    public ArrayType createArrayType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ImplicitElementInfo getProgramModelInfo() {
        return this.pmi;
    }

    @Override
    public void setProgramModelInfo(ProgramModelInfo pmi) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        StringBuilder res = new StringBuilder();
        int i = 0;
        while (i < this.types.size()) {
            if (i != 0) {
                res.append(" & ");
            }
            res.append(this.types.get(i).getName());
            ++i;
        }
        return res.toString().intern();
    }

    @Override
    public void validate() throws ModelException {
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isOrdinaryInterface() {
        return false;
    }

    @Override
    public boolean isAnnotationType() {
        return false;
    }

    @Override
    public boolean isEnumType() {
        return false;
    }

    @Override
    public boolean isOrdinaryClass() {
        return false;
    }

    @Override
    public boolean isAbstract() {
        return true;
    }

    @Override
    public List<ClassType> getSupertypes() {
        ArrayList<ClassType> res = new ArrayList<ClassType>(this.types.size());
        int i = 0;
        while (i < this.types.size()) {
            Type t = this.types.get(i);
            res.add((ClassType)t);
            ++i;
        }
        return res;
    }

    @Override
    public List<ClassType> getAllSupertypes() {
        return this.pmi.getAllSubtypes(this);
    }

    @Override
    public List<? extends Field> getFields() {
        return null;
    }

    @Override
    public List<Field> getAllFields() {
        return this.pmi.getAllFields(this);
    }

    @Override
    public List<Method> getMethods() {
        return this.pmi.getMethods(this);
    }

    @Override
    public List<Method> getAllMethods() {
        return this.pmi.getAllMethods(this);
    }

    public List<Constructor> getConstructors() {
        return null;
    }

    @Override
    public List<ClassType> getAllTypes() {
        return null;
    }

    @Override
    public List<? extends TypeParameter> getTypeParameters() {
        return null;
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public boolean isPrivate() {
        return false;
    }

    @Override
    public boolean isProtected() {
        return false;
    }

    @Override
    public boolean isPublic() {
        return false;
    }

    @Override
    public boolean isStrictFp() {
        return false;
    }

    @Override
    public ClassType getContainingClassType() {
        return null;
    }

    @Override
    public List<? extends AnnotationUse> getAnnotations() {
        return null;
    }

    @Override
    public List<? extends ClassType> getTypes() {
        return null;
    }

    @Override
    public Package getPackage() {
        return null;
    }

    @Override
    public ClassTypeContainer getContainer() {
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IntersectionType) {
            IntersectionType it = (IntersectionType)o;
            return it.pmi == this.pmi && it.types.size() == this.types.size() && it.types.containsAll(this.types);
        }
        return false;
    }

    @Override
    public String getFullSignature() {
        StringBuilder res = new StringBuilder(150);
        int i = 0;
        while (i < this.types.size()) {
            if (i != 0) {
                res.append(" & ");
            }
            res.append(this.types.get(i).getFullSignature());
            ++i;
        }
        return res.toString();
    }

    @Override
    public ErasedType getErasedType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isInner() {
        return false;
    }

    @Override
    public ClassType getBaseClassType() {
        throw new UnsupportedOperationException();
    }

    public ClassType getAccessibility() {
        return this.accessibility;
    }

    public void setAccesibility(ClassType accessibility) {
        this.accessibility = accessibility;
    }
}

