/*
 * Decompiled with CFR 0.152.
 */
package recoder.abstraction;

import java.util.List;
import recoder.ModelException;
import recoder.abstraction.AnnotationUse;
import recoder.abstraction.ArrayType;
import recoder.abstraction.ClassType;
import recoder.abstraction.ClassTypeContainer;
import recoder.abstraction.Constructor;
import recoder.abstraction.Field;
import recoder.abstraction.Method;
import recoder.abstraction.Package;
import recoder.abstraction.ParameterizedType;
import recoder.abstraction.TypeParameter;
import recoder.service.ImplicitElementInfo;
import recoder.service.ProgramModelInfo;

public class ErasedType
implements ClassType {
    private final ClassType genericType;
    private final ImplicitElementInfo service;
    private ArrayType arrayType;

    public ErasedType(ClassType genericType, ImplicitElementInfo service) {
        this.genericType = genericType;
        this.service = service;
        assert (!(genericType instanceof ErasedType) && !(genericType instanceof ParameterizedType));
        assert (!(genericType instanceof ArrayType));
        assert (genericType != null);
    }

    @Override
    public ArrayType getArrayType() {
        return this.arrayType;
    }

    @Override
    public ArrayType createArrayType() {
        if (this.arrayType == null) {
            this.arrayType = new ArrayType(this, this.service.getServiceConfiguration().getImplicitElementInfo());
        }
        return this.arrayType;
    }

    public ClassType getGenericType() {
        return this.genericType;
    }

    @Override
    public List<Field> getAllFields() {
        return this.service.getAllFields(this);
    }

    @Override
    public List<Method> getAllMethods() {
        return this.service.getAllMethods(this);
    }

    @Override
    public List<ClassType> getAllSupertypes() {
        return this.service.getAllSupertypes(this);
    }

    @Override
    public List<ClassType> getAllTypes() {
        return this.service.getAllTypes(this);
    }

    @Override
    public List<? extends Constructor> getConstructors() {
        return this.service.getConstructors(this);
    }

    @Override
    public List<? extends Field> getFields() {
        return this.service.getFields(this);
    }

    @Override
    public String getFullSignature() {
        return String.valueOf(this.getFullName()) + "%RAW%";
    }

    @Override
    public List<Method> getMethods() {
        return this.service.getMethods(this);
    }

    @Override
    public List<ClassType> getSupertypes() {
        return this.service.getSupertypes(this);
    }

    @Override
    public List<? extends TypeParameter> getTypeParameters() {
        return null;
    }

    @Override
    public boolean isAbstract() {
        return this.genericType.isAbstract();
    }

    @Override
    public boolean isAnnotationType() {
        return this.genericType.isAnnotationType();
    }

    @Override
    public boolean isEnumType() {
        return this.genericType.isEnumType();
    }

    @Override
    public boolean isInterface() {
        return this.genericType.isInterface();
    }

    @Override
    public boolean isOrdinaryClass() {
        return this.genericType.isOrdinaryClass();
    }

    @Override
    public boolean isOrdinaryInterface() {
        return this.genericType.isOrdinaryInterface();
    }

    @Override
    public String getFullName() {
        return this.genericType.getFullName();
    }

    @Override
    public String getBinaryName() {
        return this.genericType.getBinaryName();
    }

    @Override
    public ImplicitElementInfo getProgramModelInfo() {
        return this.service;
    }

    @Override
    public void setProgramModelInfo(ProgramModelInfo pmi) {
        throw new RuntimeException();
    }

    @Override
    public String getName() {
        return this.genericType.getName();
    }

    @Override
    public void validate() throws ModelException {
    }

    @Override
    public List<? extends AnnotationUse> getAnnotations() {
        return this.genericType.getAnnotations();
    }

    @Override
    public ClassType getContainingClassType() {
        return this.genericType.getContainingClassType();
    }

    @Override
    public boolean isFinal() {
        return this.genericType.isFinal();
    }

    @Override
    public boolean isPrivate() {
        return this.genericType.isPrivate();
    }

    @Override
    public boolean isProtected() {
        return this.genericType.isProtected();
    }

    @Override
    public boolean isPublic() {
        return this.genericType.isPublic();
    }

    @Override
    public boolean isStatic() {
        return this.genericType.isStatic();
    }

    @Override
    public boolean isStrictFp() {
        return this.genericType.isStrictFp();
    }

    @Override
    public ClassTypeContainer getContainer() {
        return this.genericType.getContainer();
    }

    @Override
    public Package getPackage() {
        return this.genericType.getPackage();
    }

    @Override
    public List<? extends ClassType> getTypes() {
        return this.service.getTypes(this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ErasedType)) {
            return false;
        }
        return this.genericType.equals(((ErasedType)o).genericType);
    }

    public int hashCode() {
        return this.genericType.hashCode();
    }

    @Override
    public ErasedType getErasedType() {
        return this;
    }

    @Override
    public boolean isInner() {
        return this.genericType.isInner();
    }

    public String toString() {
        return "%RAW%" + this.getFullName();
    }

    @Override
    public ClassType getBaseClassType() {
        return this.genericType;
    }
}

