/*
 * Decompiled with CFR 0.152.
 */
package recoder.abstraction;

import java.util.List;
import recoder.ModelException;
import recoder.abstraction.AnnotationUse;
import recoder.abstraction.ClassType;
import recoder.abstraction.ClassTypeContainer;
import recoder.abstraction.Constructor;
import recoder.abstraction.Package;
import recoder.abstraction.Type;
import recoder.abstraction.TypeParameter;
import recoder.convenience.Naming;
import recoder.service.ProgramModelInfo;
import recoder.util.Debug;

public class DefaultConstructor
implements Constructor {
    protected ProgramModelInfo service;
    protected ClassType ownerClass;

    public DefaultConstructor(ClassType ownerClass) {
        Debug.assertNonnull(ownerClass);
        this.ownerClass = ownerClass;
    }

    @Override
    public ProgramModelInfo getProgramModelInfo() {
        return this.service;
    }

    @Override
    public void setProgramModelInfo(ProgramModelInfo service) {
        this.service = service;
    }

    @Override
    public void validate() throws ModelException {
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public boolean isStatic() {
        return true;
    }

    @Override
    public boolean isPrivate() {
        return this.getContainingClassType().isEnumType();
    }

    @Override
    public boolean isProtected() {
        return false;
    }

    @Override
    public boolean isPublic() {
        return this.getContainingClassType().isPublic() && !this.getContainingClassType().isEnumType();
    }

    @Override
    public boolean isStrictFp() {
        return false;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public boolean isNative() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public ClassType getContainingClassType() {
        return this.ownerClass;
    }

    @Override
    public Type getReturnType() {
        return this.service.getReturnType(this);
    }

    @Override
    public List<Type> getSignature() {
        return this.service.getSignature(this);
    }

    @Override
    public List<ClassType> getExceptions() {
        return this.service.getExceptions(this);
    }

    @Override
    public ClassTypeContainer getContainer() {
        return this.getContainingClassType();
    }

    @Override
    public Package getPackage() {
        return this.service.getPackage(this);
    }

    @Override
    public List<? extends ClassType> getTypes() {
        return this.service.getTypes(this);
    }

    @Override
    public String getName() {
        return this.getContainingClassType().getName();
    }

    @Override
    public String getFullName() {
        return Naming.getFullName(this);
    }

    @Override
    public String getBinaryName() {
        return this.ownerClass.getBinaryName();
    }

    @Override
    public boolean isVarArgMethod() {
        return false;
    }

    @Override
    public List<? extends AnnotationUse> getAnnotations() {
        return null;
    }

    public DefaultConstructor deepClone() {
        throw new UnsupportedOperationException("Cannot deep-clone default constructor");
    }

    @Override
    public List<? extends TypeParameter> getTypeParameters() {
        return null;
    }
}

