/*
 * Decompiled with CFR 0.152.
 */
package recoder.abstraction;

import java.util.Collections;
import java.util.List;
import recoder.ModelException;
import recoder.abstraction.AnnotationUse;
import recoder.abstraction.ClassType;
import recoder.abstraction.ClassTypeContainer;
import recoder.abstraction.Constructor;
import recoder.abstraction.ErasedType;
import recoder.abstraction.Field;
import recoder.abstraction.Method;
import recoder.abstraction.Package;
import recoder.abstraction.PrimitiveType;
import recoder.abstraction.Type;
import recoder.abstraction.TypeArgument;
import recoder.abstraction.TypeParameter;
import recoder.service.ImplicitElementInfo;
import recoder.service.ProgramModelInfo;

public final class ArrayType
implements ClassType {
    private static final String CLONE_NAME = "clone".intern();
    private Type basetype;
    private ImplicitElementInfo pmi;
    private final ArrayLengthField lengthField;
    private final ArrayCloneMethod cloneMethod;
    private ArrayType arrayType;

    public ArrayType(Type basetype, ImplicitElementInfo pmi) {
        this.basetype = basetype;
        this.pmi = pmi;
        this.lengthField = new ArrayLengthField();
        this.cloneMethod = new ArrayCloneMethod();
    }

    @Override
    public ArrayType getArrayType() {
        return this.arrayType;
    }

    @Override
    public ArrayType createArrayType() {
        if (this.arrayType == null) {
            this.arrayType = new ArrayType(this, this.pmi.getServiceConfiguration().getImplicitElementInfo());
        }
        return this.arrayType;
    }

    public ArrayLengthField getArrayLengthField() {
        return this.lengthField;
    }

    public ArrayCloneMethod getArrayCloneMethod() {
        return this.cloneMethod;
    }

    public Type getBaseType() {
        return this.basetype;
    }

    @Override
    public String getName() {
        return (String.valueOf(this.basetype.getName()) + "[]").intern();
    }

    @Override
    public String getFullName() {
        return String.valueOf(this.basetype.getFullName()) + "[]";
    }

    @Override
    public String getBinaryName() {
        return String.valueOf(this.basetype.getBinaryName()) + "[]";
    }

    @Override
    public ImplicitElementInfo getProgramModelInfo() {
        return this.pmi;
    }

    @Override
    public void setProgramModelInfo(ProgramModelInfo service) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void validate() {
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof ArrayType)) {
            return false;
        }
        Type other = (ArrayType)o2;
        Type me = this;
        while (me instanceof ArrayType && other instanceof ArrayType) {
            me = ((ArrayType)me).basetype;
            other = other.basetype;
        }
        if (me instanceof ArrayType || other instanceof ArrayType) {
            return false;
        }
        return me.equals(other);
    }

    @Override
    public List<Field> getAllFields() {
        return this.pmi.getAllFields(this);
    }

    @Override
    public List<Method> getAllMethods() {
        return this.pmi.getAllMethods(this);
    }

    @Override
    public List<ClassType> getAllSupertypes() {
        return this.pmi.getAllSupertypes(this);
    }

    @Override
    public List<ClassType> getAllTypes() {
        return this.pmi.getAllTypes(this);
    }

    @Override
    public List<? extends Constructor> getConstructors() {
        return this.pmi.getConstructors(this);
    }

    @Override
    public List<? extends Field> getFields() {
        return this.pmi.getFields(this);
    }

    @Override
    public List<Method> getMethods() {
        return this.pmi.getMethods(this);
    }

    @Override
    public List<ClassType> getSupertypes() {
        return this.pmi.getSupertypes(this);
    }

    @Override
    public List<? extends TypeParameter> getTypeParameters() {
        return Collections.emptyList();
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public boolean isAnnotationType() {
        return false;
    }

    @Override
    public boolean isEnumType() {
        return false;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isOrdinaryClass() {
        return false;
    }

    @Override
    public boolean isOrdinaryInterface() {
        return false;
    }

    @Override
    public List<? extends AnnotationUse> getAnnotations() {
        throw new RuntimeException("Not implemented yet!");
    }

    @Override
    public ClassType getContainingClassType() {
        return null;
    }

    @Override
    public boolean isFinal() {
        return true;
    }

    @Override
    public boolean isPrivate() {
        return this.basetype instanceof PrimitiveType ? false : ((ClassType)this.basetype).isPrivate();
    }

    @Override
    public boolean isProtected() {
        return this.basetype instanceof PrimitiveType ? false : ((ClassType)this.basetype).isProtected();
    }

    @Override
    public boolean isPublic() {
        return this.basetype instanceof PrimitiveType ? true : ((ClassType)this.basetype).isProtected();
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public boolean isStrictFp() {
        return false;
    }

    @Override
    public ClassTypeContainer getContainer() {
        return null;
    }

    @Override
    public Package getPackage() {
        return null;
    }

    @Override
    public List<? extends ClassType> getTypes() {
        return null;
    }

    public String toString() {
        return "ArrayType " + this.getFullName();
    }

    public int hashCode() {
        Type t = this;
        int dim = 0;
        while (t instanceof ArrayType) {
            t = t.getBaseType();
            ++dim;
        }
        return ((Object)t).hashCode() + dim;
    }

    @Override
    public String getFullSignature() {
        if (this.basetype instanceof PrimitiveType) {
            return this.getFullName();
        }
        return String.valueOf(((ClassType)this.basetype).getFullSignature()) + "[]";
    }

    @Override
    public ErasedType getErasedType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isInner() {
        return false;
    }

    @Override
    public ClassType getBaseClassType() {
        return this;
    }

    public final class ArrayCloneMethod
    implements Method {
        private ArrayCloneMethod() {
        }

        @Override
        public List<ClassType> getExceptions() {
            return Collections.emptyList();
        }

        @Override
        public Type getReturnType() {
            return ArrayType.this.pmi.getReturnType(this);
        }

        @Override
        public List<Type> getSignature() {
            return ArrayType.this.pmi.getSignature(this);
        }

        @Override
        public List<? extends TypeParameter> getTypeParameters() {
            return null;
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public boolean isNative() {
            return true;
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public boolean isVarArgMethod() {
            return false;
        }

        @Override
        public List<? extends AnnotationUse> getAnnotations() {
            return null;
        }

        @Override
        public ArrayType getContainingClassType() {
            return ArrayType.this;
        }

        @Override
        public boolean isFinal() {
            return false;
        }

        @Override
        public boolean isPrivate() {
            return false;
        }

        @Override
        public boolean isProtected() {
            return false;
        }

        @Override
        public boolean isPublic() {
            return true;
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public boolean isStrictFp() {
            return false;
        }

        @Override
        public String getFullName() {
            return String.valueOf(ArrayType.this.getFullName()) + ".clone";
        }

        @Override
        public ImplicitElementInfo getProgramModelInfo() {
            return ArrayType.this.pmi;
        }

        @Override
        public void setProgramModelInfo(ProgramModelInfo pmi) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            return CLONE_NAME;
        }

        @Override
        public void validate() throws ModelException {
        }

        @Override
        public ClassTypeContainer getContainer() {
            return ArrayType.this;
        }

        @Override
        public Package getPackage() {
            return null;
        }

        @Override
        public List<? extends ClassType> getTypes() {
            return null;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ArrayCloneMethod)) {
                return false;
            }
            return ((ArrayCloneMethod)o).getContainingClassType().equals(this);
        }

        public int hashCode() {
            return ArrayType.this.hashCode();
        }

        @Override
        public String getBinaryName() {
            return String.valueOf(ArrayType.this.getBinaryName()) + ".clone";
        }
    }

    public final class ArrayLengthField
    implements Field {
        private ArrayLengthField() {
        }

        @Override
        public List<? extends TypeArgument> getTypeArguments() {
            return null;
        }

        @Override
        public Type getType() {
            return ArrayType.this.pmi.getServiceConfiguration().getNameInfo().getIntType();
        }

        @Override
        public boolean isFinal() {
            return true;
        }

        @Override
        public String getFullName() {
            return String.valueOf(ArrayType.this.getFullName()) + ".length";
        }

        @Override
        public ImplicitElementInfo getProgramModelInfo() {
            return ArrayType.this.pmi;
        }

        @Override
        public void setProgramModelInfo(ProgramModelInfo pmi) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            return "length";
        }

        @Override
        public void validate() throws ModelException {
        }

        @Override
        public List<? extends AnnotationUse> getAnnotations() {
            return null;
        }

        @Override
        public ArrayType getContainingClassType() {
            return ArrayType.this;
        }

        @Override
        public boolean isPrivate() {
            return false;
        }

        @Override
        public boolean isProtected() {
            return false;
        }

        @Override
        public boolean isPublic() {
            return true;
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public boolean isStrictFp() {
            return false;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ArrayLengthField)) {
                return false;
            }
            return ((ArrayLengthField)o).getContainingClassType().equals(this);
        }

        public int hashCode() {
            return ArrayType.this.hashCode();
        }

        @Override
        public String getBinaryName() {
            return String.valueOf(ArrayType.this.getBinaryName()) + ".length";
        }
    }
}

