/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.spawner;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.cdt.core.CCorePlugin;

class SpawnerInputStream
extends InputStream {
    private int fd;

    static {
        System.loadLibrary("spawner");
    }

    public SpawnerInputStream(int fd) {
        this.fd = fd;
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        if (1 != this.read(b, 0, 1)) {
            return -1;
        }
        return b[0];
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        if (buf == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > buf.length || len < 0 || off + len > buf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        byte[] tmpBuf = new byte[len];
        if ((len = this.read0(this.fd, tmpBuf, len)) <= 0) {
            return -1;
        }
        System.arraycopy(tmpBuf, 0, buf, off, len);
        return len;
    }

    public void close() throws IOException {
        if (this.fd == -1) {
            return;
        }
        int status = this.close0(this.fd);
        if (status == -1) {
            throw new IOException(CCorePlugin.getResourceString("Util.exception.closeError"));
        }
        this.fd = -1;
    }

    public int available() throws IOException {
        try {
            return this.available0(this.fd);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return super.available();
        }
    }

    private native int read0(int var1, byte[] var2, int var3) throws IOException;

    private native int close0(int var1) throws IOException;

    private native int available0(int var1) throws IOException;
}

