/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model.xml2;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionStorageManager;
import org.eclipse.cdt.internal.core.settings.model.ICProjectDescriptionStorageType;
import org.eclipse.cdt.internal.core.settings.model.xml.InternalXmlStorageElement;
import org.eclipse.cdt.internal.core.settings.model.xml.XmlProjectDescriptionStorage;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.osgi.framework.Version;
import org.w3c.dom.Element;

public class XmlProjectDescriptionStorage2
extends XmlProjectDescriptionStorage {
    static final String STORAGE_FOLDER_NAME = ".csettings";
    public static final String EXTERNAL_CELEMENT_KEY = "externalCElementFile";
    private static final String ID = "id";
    public static final Version STORAGE_DESCRIPTION_VERSION = new Version("5.0");
    public static final String STORAGE_TYPE_ID = "org.eclipse.cdt.core.XmlProjectDescriptionStorage2";
    Map<String, Long> modificationMap = Collections.synchronizedMap(new HashMap());

    public XmlProjectDescriptionStorage2(ICProjectDescriptionStorageType.CProjectDescriptionStorageTypeProxy type, IProject project, Version version) {
        super(type, project, version);
    }

    protected synchronized boolean checkExternalModification() {
        boolean[] needReload;
        block4: {
            if (super.checkExternalModification()) {
                return true;
            }
            if (this.getLoadedDescription() == null) {
                return false;
            }
            needReload = new boolean[1];
            try {
                this.project.getFolder(STORAGE_FOLDER_NAME).accept(new IResourceProxyVisitor(){

                    public boolean visit(IResourceProxy proxy) throws CoreException {
                        if (XmlProjectDescriptionStorage2.this.modificationMap.containsKey(proxy.getName()) && XmlProjectDescriptionStorage2.this.modificationMap.get(proxy.getName()) < proxy.getModificationStamp()) {
                            XmlProjectDescriptionStorage2.this.modificationMap.put(proxy.getName(), proxy.getModificationStamp());
                            XmlProjectDescriptionStorage2.this.setCurrentDescription(null, true);
                            needReload[0] = true;
                        }
                        return true;
                    }
                }, 0);
            }
            catch (CoreException e) {
                if (!this.project.getFolder(STORAGE_FOLDER_NAME).exists()) break block4;
                CCorePlugin.log("XmlProjectDescriptionStorage2: Problem checking for external modification: " + e.getMessage());
            }
        }
        return needReload[0];
    }

    protected final InternalXmlStorageElement createStorage(IContainer container, String fileName, boolean reCreate, boolean createEmptyIfNotFound, boolean readOnly) throws CoreException {
        InternalXmlStorageElement el = super.createStorage(container, fileName, reCreate, createEmptyIfNotFound, readOnly);
        LinkedList<ICStorageElement> nodesToCheck = new LinkedList<ICStorageElement>();
        nodesToCheck.addAll(Arrays.asList(el.getChildren()));
        while (!nodesToCheck.isEmpty()) {
            ICStorageElement currEl = (ICStorageElement)nodesToCheck.remove();
            if (!"storageModule".equals(currEl.getName()) || currEl.getAttribute(EXTERNAL_CELEMENT_KEY) == null) {
                nodesToCheck.addAll(Arrays.asList(currEl.getChildren()));
                continue;
            }
            try {
                InternalXmlStorageElement el2 = this.createStorage((IContainer)this.project.getFolder(STORAGE_FOLDER_NAME), currEl.getAttribute(EXTERNAL_CELEMENT_KEY), reCreate, createEmptyIfNotFound, readOnly);
                this.modificationMap.put(currEl.getAttribute(EXTERNAL_CELEMENT_KEY), this.project.getFolder(STORAGE_FOLDER_NAME).getFile(currEl.getAttribute(EXTERNAL_CELEMENT_KEY)).getModificationStamp());
                ICStorageElement currParent = currEl.getParent();
                ICStorageElement[] childStorages = el2.getChildrenByName("storageModule");
                Assert.isTrue((childStorages.length == 1 ? 1 : 0) != 0, (String)"More than one storageModule in external Document!");
                currParent.importChild(childStorages[0]);
                currParent.removeChild(currEl);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
                throw e;
            }
        }
        return el;
    }

    protected long serialize(IContainer container, String file, ICStorageElement element) throws CoreException {
        IFolder csettings;
        long cproject_mod_time;
        HashMap<String, InternalXmlStorageElement> externalStorageElements;
        block9: {
            if (this.version.compareTo((Object)this.type.version) < 0) {
                return super.serialize(container, file, element);
            }
            InternalXmlStorageElement copy = this.copyElement(element, false);
            externalStorageElements = new HashMap<String, InternalXmlStorageElement>();
            ICStorageElement[] iCStorageElementArray = copy.getChildren();
            int n = iCStorageElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICStorageElement el = iCStorageElementArray[n2];
                if ("org.eclipse.cdt.core.settings".equals(el.getAttribute("moduleId"))) {
                    LinkedList<ICStorageElement> configStorages = new LinkedList<ICStorageElement>();
                    configStorages.addAll(Arrays.asList(el.getChildren()));
                    while (!configStorages.isEmpty()) {
                        InternalXmlStorageElement iEl = (InternalXmlStorageElement)configStorages.remove();
                        if (iEl.getAttribute("moduleId") == null) {
                            configStorages.addAll(Arrays.asList(iEl.getChildren()));
                            continue;
                        }
                        String storageId = String.valueOf(((Element)iEl.fElement.getParentNode()).getAttribute(ID)) + "_" + iEl.getAttribute("moduleId");
                        InternalXmlStorageElement newEl = this.createStorage((IContainer)this.project.getFolder(STORAGE_FOLDER_NAME), storageId, false, true, false);
                        newEl.importChild(this.copyElement(iEl, false));
                        externalStorageElements.put(storageId, newEl);
                        iEl.clear();
                        iEl.fElement.setAttribute(EXTERNAL_CELEMENT_KEY, storageId);
                    }
                }
                ++n2;
            }
            cproject_mod_time = super.serialize((IContainer)this.project, ".cproject", copy);
            csettings = this.project.getFolder(STORAGE_FOLDER_NAME);
            try {
                CProjectDescriptionStorageManager.ensureWritable((IResource)csettings);
                if (!csettings.exists()) {
                    csettings.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (CoreException e) {
                if (csettings.exists()) break block9;
                throw e;
            }
        }
        for (Map.Entry e : externalStorageElements.entrySet()) {
            this.modificationMap.put((String)e.getKey(), super.serialize((IContainer)csettings, (String)e.getKey(), (ICStorageElement)e.getValue()));
        }
        return cproject_mod_time;
    }

    protected Version getVersion() {
        return STORAGE_DESCRIPTION_VERSION;
    }

    protected String getStorageTypeId() {
        return STORAGE_TYPE_ID;
    }
}

