/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICFileDescription;
import org.eclipse.cdt.core.settings.model.ICFolderDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSetting;
import org.eclipse.cdt.core.settings.model.ICSettingContainer;
import org.eclipse.cdt.core.settings.model.ICSettingObject;
import org.eclipse.cdt.core.settings.model.WriteAccessException;
import org.eclipse.cdt.core.settings.model.extension.CFileData;
import org.eclipse.cdt.core.settings.model.extension.CLanguageData;
import org.eclipse.cdt.core.settings.model.extension.impl.CDefaultFileData;
import org.eclipse.cdt.internal.core.settings.model.CConfigurationDescriptionCache;
import org.eclipse.cdt.internal.core.settings.model.CLanguageSettingCache;
import org.eclipse.cdt.internal.core.settings.model.ExceptionFactory;
import org.eclipse.cdt.internal.core.settings.model.ICachedData;
import org.eclipse.cdt.internal.core.settings.model.ResourceDescriptionHolder;
import org.eclipse.core.runtime.IPath;

public class CFileDescriptionCache
extends CDefaultFileData
implements ICFileDescription,
ICachedData {
    private CConfigurationDescriptionCache fCfg;
    private ResourceDescriptionHolder fRcDesHolder;

    public CFileDescriptionCache(CFileData base, CConfigurationDescriptionCache cfg) {
        super(base.getId(), base.getPath(), cfg, null);
        this.fCfg = cfg;
        this.fCfg.addResourceDescription(this);
        this.copyDataFrom(base, true);
    }

    protected CLanguageData copyLanguageData(CLanguageData data, boolean clone) {
        return new CLanguageSettingCache(data, this);
    }

    public void setExcluded(boolean excluded) throws WriteAccessException {
        throw ExceptionFactory.createIsReadOnlyException();
    }

    public boolean canExclude(boolean exclude) {
        return exclude == this.isExcluded();
    }

    public void setName(String name) throws WriteAccessException {
        throw ExceptionFactory.createIsReadOnlyException();
    }

    public void setPath(IPath path) throws WriteAccessException {
        throw ExceptionFactory.createIsReadOnlyException();
    }

    public ICConfigurationDescription getConfiguration() {
        return this.fCfg;
    }

    public ICSettingContainer getParent() {
        return this.fCfg;
    }

    public ICLanguageSetting getLanguageSetting() {
        return (ICLanguageSetting)((Object)this.fLanguageData);
    }

    public ICSettingObject[] getChildSettings() {
        return new ICSettingObject[]{(ICSettingObject)((Object)this.fLanguageData)};
    }

    public boolean isReadOnly() {
        return true;
    }

    private ResourceDescriptionHolder getRcDesHolder() {
        if (this.fRcDesHolder == null) {
            this.fRcDesHolder = this.fCfg.createHolderForRc(this.getPath());
        }
        return this.fRcDesHolder;
    }

    public ICFolderDescription getParentFolderDescription() {
        return this.getRcDesHolder().getParentFolderDescription();
    }

    public IPath getPath() {
        return ResourceDescriptionHolder.normalizePath(super.getPath());
    }

    public boolean hasCustomSettings() {
        return true;
    }

    public boolean isExcluded() {
        return this.fCfg.isExcluded(this.getPath());
    }
}

