/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPTypeList {
    protected static final int NODE_SIZE = 4;

    PDOMCPPTypeList() {
    }

    public static long putTypes(PDOMNode parent, IType[] types) throws CoreException {
        long block;
        if (types == null) {
            return 0L;
        }
        PDOMLinkage linkage = parent.getLinkage();
        Database db = linkage.getDB();
        int len = Math.min(types.length, 1023);
        long p = block = db.malloc(2 + 4 * len);
        db.putShort(p, (short)len);
        p += 2L;
        int i = 0;
        while (i < len) {
            PDOMNode pdomType;
            IType type = types[i];
            long rec = 0L;
            if (type != null && (pdomType = linkage.addType(parent, type)) != null) {
                rec = pdomType.getRecord();
            }
            db.putRecPtr(p, rec);
            ++i;
            p += 4L;
        }
        return block;
    }

    public static IType[] getTypes(PDOMNode parent, long rec) throws CoreException {
        if (rec == 0L) {
            return null;
        }
        PDOMLinkage linkage = parent.getLinkage();
        Database db = linkage.getDB();
        int len = db.getShort(rec);
        if (len == 0) {
            return IType.EMPTY_TYPE_ARRAY;
        }
        Assert.isTrue((len >= 0 && len <= 1023 ? 1 : 0) != 0);
        rec += 2L;
        IType[] result = new IType[len];
        int i = 0;
        while (i < len) {
            long typeRec = db.getRecPtr(rec);
            if (typeRec != 0L) {
                result[i] = (IType)((Object)linkage.getNode(typeRec));
            }
            ++i;
            rec += 4L;
        }
        return result;
    }

    public static void clearTypes(PDOMNode parent, long record) throws CoreException {
        if (record == 0L) {
            return;
        }
        PDOMLinkage linkage = parent.getLinkage();
        Database db = linkage.getDB();
        int len = db.getShort(record);
        Assert.isTrue((len >= 0 && len <= 1023 ? 1 : 0) != 0);
        long p = record + 2L;
        int i = 0;
        while (i < len) {
            long typeRec = db.getRecPtr(p);
            IType t = (IType)((Object)linkage.getNode(typeRec));
            linkage.deleteType(t, parent.getRecord());
            ++i;
            p += 4L;
        }
        db.free(record);
    }
}

