/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.db;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.cdt.internal.core.pdom.db.DBStatus;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;

final class Chunk {
    private final byte[] fBuffer = new byte[4096];
    final Database fDatabase;
    final int fSequenceNumber;
    boolean fCacheHitFlag = false;
    boolean fDirty = false;
    boolean fLocked = false;
    int fCacheIndex = -1;

    Chunk(Database db, int sequenceNumber) {
        this.fDatabase = db;
        this.fSequenceNumber = sequenceNumber;
    }

    void read() throws CoreException {
        try {
            ByteBuffer buf = ByteBuffer.wrap(this.fBuffer);
            this.fDatabase.read(buf, (long)this.fSequenceNumber * 4096L);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new DBStatus(e));
        }
    }

    void flush() throws CoreException {
        try {
            ByteBuffer buf = ByteBuffer.wrap(this.fBuffer);
            this.fDatabase.write(buf, (long)this.fSequenceNumber * 4096L);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new DBStatus(e));
        }
        this.fDirty = false;
    }

    private static int recPtrToIndex(long offset) {
        return (int)(offset & 0xFFFL);
    }

    public void putByte(long offset, byte value) {
        assert (this.fLocked);
        this.fDirty = true;
        this.fBuffer[Chunk.recPtrToIndex((long)offset)] = value;
    }

    public byte getByte(long offset) {
        return this.fBuffer[Chunk.recPtrToIndex(offset)];
    }

    public byte[] getBytes(long offset, int length) {
        byte[] bytes = new byte[length];
        System.arraycopy(this.fBuffer, Chunk.recPtrToIndex(offset), bytes, 0, length);
        return bytes;
    }

    public void putBytes(long offset, byte[] bytes) {
        assert (this.fLocked);
        this.fDirty = true;
        System.arraycopy(bytes, 0, this.fBuffer, Chunk.recPtrToIndex(offset), bytes.length);
    }

    public void putInt(long offset, int value) {
        assert (this.fLocked);
        this.fDirty = true;
        int idx = Chunk.recPtrToIndex(offset);
        this.fBuffer[idx] = (byte)(value >> 24);
        this.fBuffer[++idx] = (byte)(value >> 16);
        this.fBuffer[++idx] = (byte)(value >> 8);
        this.fBuffer[++idx] = (byte)value;
    }

    public int getInt(long offset) {
        int idx = Chunk.recPtrToIndex(offset);
        return (this.fBuffer[idx] & 0xFF) << 24 | (this.fBuffer[++idx] & 0xFF) << 16 | (this.fBuffer[++idx] & 0xFF) << 8 | (this.fBuffer[++idx] & 0xFF) << 0;
    }

    public void putRecPtr(long offset, long value) {
        if (!this.fDatabase.usesDensePointers()) {
            this.putFreeRecPtr(offset, value);
        } else {
            this.putFreeRecPtr(offset, value == 0L ? value : value - 2L);
        }
    }

    public void putFreeRecPtr(long offset, long value) {
        if (!this.fDatabase.usesDensePointers()) {
            this.putInt(offset, (int)value);
            return;
        }
        assert ((value & 7L) == 0L);
        this.putInt(offset, (int)(value >> 3));
    }

    public long getRecPtr(long offset) {
        if (!this.fDatabase.usesDensePointers()) {
            return this.getInt(offset);
        }
        long address = this.getFreeRecPtr(offset);
        return address != 0L ? address + 2L : address;
    }

    public long getFreeRecPtr(long offset) {
        int value = this.getInt(offset);
        if (!this.fDatabase.usesDensePointers()) {
            return value;
        }
        long address = (long)value & 0xFFFFFFFFL;
        return address << 3;
    }

    public void put3ByteUnsignedInt(long offset, int value) {
        assert (this.fLocked);
        this.fDirty = true;
        int idx = Chunk.recPtrToIndex(offset);
        this.fBuffer[idx] = (byte)(value >> 16);
        this.fBuffer[++idx] = (byte)(value >> 8);
        this.fBuffer[++idx] = (byte)value;
    }

    public int get3ByteUnsignedInt(long offset) {
        int idx = Chunk.recPtrToIndex(offset);
        return (this.fBuffer[idx] & 0xFF) << 16 | (this.fBuffer[++idx] & 0xFF) << 8 | (this.fBuffer[++idx] & 0xFF) << 0;
    }

    public void putShort(long offset, short value) {
        assert (this.fLocked);
        this.fDirty = true;
        int idx = Chunk.recPtrToIndex(offset);
        this.fBuffer[idx] = (byte)(value >> 8);
        this.fBuffer[++idx] = (byte)value;
    }

    public short getShort(long offset) {
        int idx = Chunk.recPtrToIndex(offset);
        return (short)(this.fBuffer[idx] << 8 | this.fBuffer[++idx] & 0xFF);
    }

    public long getLong(long offset) {
        int idx = Chunk.recPtrToIndex(offset);
        return ((long)this.fBuffer[idx] & 0xFFL) << 56 | ((long)this.fBuffer[++idx] & 0xFFL) << 48 | ((long)this.fBuffer[++idx] & 0xFFL) << 40 | ((long)this.fBuffer[++idx] & 0xFFL) << 32 | ((long)this.fBuffer[++idx] & 0xFFL) << 24 | ((long)this.fBuffer[++idx] & 0xFFL) << 16 | ((long)this.fBuffer[++idx] & 0xFFL) << 8 | ((long)this.fBuffer[++idx] & 0xFFL) << 0;
    }

    public void putLong(long offset, long value) {
        assert (this.fLocked);
        this.fDirty = true;
        int idx = Chunk.recPtrToIndex(offset);
        this.fBuffer[idx] = (byte)(value >> 56);
        this.fBuffer[++idx] = (byte)(value >> 48);
        this.fBuffer[++idx] = (byte)(value >> 40);
        this.fBuffer[++idx] = (byte)(value >> 32);
        this.fBuffer[++idx] = (byte)(value >> 24);
        this.fBuffer[++idx] = (byte)(value >> 16);
        this.fBuffer[++idx] = (byte)(value >> 8);
        this.fBuffer[++idx] = (byte)value;
    }

    public void putChar(long offset, char value) {
        assert (this.fLocked);
        this.fDirty = true;
        int idx = Chunk.recPtrToIndex(offset);
        this.fBuffer[idx] = (byte)(value >> 8);
        this.fBuffer[++idx] = (byte)value;
    }

    public char getChar(long offset) {
        int idx = Chunk.recPtrToIndex(offset);
        return (char)(this.fBuffer[idx] << 8 | this.fBuffer[++idx] & 0xFF);
    }

    public void getCharArray(long offset, char[] result) {
        ByteBuffer buf = ByteBuffer.wrap(this.fBuffer);
        buf.position(Chunk.recPtrToIndex(offset));
        buf.asCharBuffer().get(result);
    }

    void clear(long offset, int length) {
        assert (this.fLocked);
        this.fDirty = true;
        int idx = Chunk.recPtrToIndex(offset);
        int end = idx + length;
        while (idx < end) {
            this.fBuffer[idx] = 0;
            ++idx;
        }
    }
}

