/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.internal.core.index.IIndexFragmentBinding;
import org.eclipse.core.runtime.CoreException;

public class DeclaredBindingsFilter
extends IndexFilter {
    private final int fLinkageID;
    private final boolean fAcceptImplicit;
    private final boolean fAllowInstances;

    public DeclaredBindingsFilter() {
        this(-1, false, true);
    }

    public DeclaredBindingsFilter(int linkageID, boolean acceptImplicit, boolean allowInstances) {
        this.fLinkageID = linkageID;
        this.fAcceptImplicit = acceptImplicit;
        this.fAllowInstances = allowInstances;
    }

    public boolean acceptLinkage(ILinkage linkage) {
        return this.fLinkageID == -1 || this.fLinkageID == linkage.getLinkageID();
    }

    public boolean acceptBinding(IBinding binding) throws CoreException {
        if (!this.fAllowInstances && binding instanceof ICPPTemplateInstance) {
            return false;
        }
        if (binding instanceof IIndexFragmentBinding) {
            return ((IIndexFragmentBinding)binding).hasDeclaration() || this.fAcceptImplicit && this.isImplicit(binding);
        }
        return this.fAcceptImplicit || !this.isImplicit(binding);
    }

    private boolean isImplicit(IBinding binding) {
        if (binding instanceof ICPPSpecialization) {
            return true;
        }
        if (binding instanceof ICPPMethod) {
            return ((ICPPMethod)binding).isImplicit();
        }
        return false;
    }
}

