/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConversionName;
import org.eclipse.cdt.core.parser.Keywords;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTNameBase;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;

public class CPPASTConversionName
extends CPPASTNameBase
implements ICPPASTConversionName {
    private IASTTypeId typeId = null;
    private char[] fName;

    public CPPASTConversionName() {
    }

    public CPPASTConversionName(IASTTypeId typeId) {
        this.setTypeId(typeId);
    }

    public CPPASTConversionName copy() {
        CPPASTConversionName copy = new CPPASTConversionName();
        copy.setTypeId(this.typeId == null ? null : this.typeId.copy());
        copy.setOffsetAndLength(this);
        return copy;
    }

    public IASTTypeId getTypeId() {
        return this.typeId;
    }

    public void setTypeId(IASTTypeId typeId) {
        this.assertNotFrozen();
        this.typeId = typeId;
        if (typeId != null) {
            typeId.setParent(this);
            typeId.setPropertyInParent(TYPE_ID);
        }
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitNames) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.typeId != null && !this.typeId.accept(action)) {
            return false;
        }
        if (action.shouldVisitNames) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    protected IBinding createIntermediateBinding() {
        return CPPVisitor.createBinding(this);
    }

    public char[] toCharArray() {
        if (this.fName == null) {
            StringBuilder buf = new StringBuilder();
            buf.append(Keywords.cOPERATOR);
            buf.append(' ');
            if (this.typeId != null) {
                IType t = CPPVisitor.createType(this.typeId);
                if (t != null) {
                    buf.append(ASTTypeUtil.getType(t, true));
                } else {
                    buf.append(this.typeId.getRawSignature());
                    WHITESPACE_SEQ.matcher(buf).replaceAll(" ");
                }
            }
            int len = buf.length();
            this.fName = new char[len];
            buf.getChars(0, len, this.fName, 0);
        }
        return this.fName;
    }

    public char[] getSimpleID() {
        return this.toCharArray();
    }

    public char[] getLookupKey() {
        return Keywords.cOPERATOR;
    }
}

