/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVisibilityLabel;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTBaseDeclSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassScope;

public class CPPASTCompositeTypeSpecifier
extends CPPASTBaseDeclSpecifier
implements ICPPASTCompositeTypeSpecifier,
IASTAmbiguityParent {
    private int fKey;
    private IASTName fName;
    private ICPPClassScope fScope;
    private IASTDeclaration[] fAllDeclarations;
    private IASTDeclaration[] fActiveDeclarations;
    private int fDeclarationsPos = -1;
    private ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier[] baseSpecs = null;
    private int baseSpecsPos = -1;

    public CPPASTCompositeTypeSpecifier() {
    }

    public CPPASTCompositeTypeSpecifier(int k, IASTName n) {
        this.fKey = k;
        this.setName(n);
    }

    public CPPASTCompositeTypeSpecifier copy() {
        CPPASTCompositeTypeSpecifier copy = new CPPASTCompositeTypeSpecifier(this.fKey, this.fName == null ? null : this.fName.copy());
        this.copyBaseDeclSpec(copy);
        IASTNode[] iASTNodeArray = this.getMembers();
        int n = iASTNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration member = iASTNodeArray[n2];
            copy.addMemberDeclaration(member == null ? null : member.copy());
            ++n2;
        }
        iASTNodeArray = this.getBaseSpecifiers();
        n = iASTNodeArray.length;
        n2 = 0;
        while (n2 < n) {
            IASTNode baseSpecifier = iASTNodeArray[n2];
            copy.addBaseSpecifier(baseSpecifier == null ? null : baseSpecifier.copy());
            ++n2;
        }
        return copy;
    }

    public ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier[] getBaseSpecifiers() {
        if (this.baseSpecs == null) {
            return ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier.EMPTY_BASESPECIFIER_ARRAY;
        }
        this.baseSpecs = (ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier[])ArrayUtil.removeNullsAfter(ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier.class, this.baseSpecs, this.baseSpecsPos);
        return this.baseSpecs;
    }

    public void addBaseSpecifier(ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier baseSpec) {
        this.assertNotFrozen();
        if (baseSpec != null) {
            baseSpec.setParent(this);
            baseSpec.setPropertyInParent(BASE_SPECIFIER);
            this.baseSpecs = (ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier[])ArrayUtil.append(ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier.class, this.baseSpecs, ++this.baseSpecsPos, baseSpec);
        }
    }

    public int getKey() {
        return this.fKey;
    }

    public void setKey(int key) {
        this.assertNotFrozen();
        this.fKey = key;
    }

    public IASTName getName() {
        return this.fName;
    }

    public void setName(IASTName name) {
        this.assertNotFrozen();
        this.fName = name;
        if (name != null) {
            name.setParent(this);
            name.setPropertyInParent(TYPE_NAME);
        }
    }

    public IASTDeclaration[] getMembers() {
        IASTDeclaration[] active = this.fActiveDeclarations;
        if (active == null) {
            active = ASTQueries.extractActiveDeclarations(this.fAllDeclarations, this.fDeclarationsPos + 1);
            this.fActiveDeclarations = active;
        }
        return active;
    }

    public final IASTDeclaration[] getDeclarations(boolean includeInactive) {
        if (includeInactive) {
            this.fAllDeclarations = (IASTDeclaration[])ArrayUtil.removeNullsAfter(IASTDeclaration.class, this.fAllDeclarations, this.fDeclarationsPos);
            return this.fAllDeclarations;
        }
        return this.getMembers();
    }

    public void addMemberDeclaration(IASTDeclaration decl) {
        if (decl == null) {
            return;
        }
        if (decl instanceof ICPPASTVisibilityLabel && !decl.isActive()) {
            return;
        }
        this.assertNotFrozen();
        decl.setParent(this);
        decl.setPropertyInParent(decl instanceof ICPPASTVisibilityLabel ? VISIBILITY_LABEL : MEMBER_DECLARATION);
        this.fAllDeclarations = (IASTDeclaration[])ArrayUtil.append(IASTDeclaration.class, this.fAllDeclarations, ++this.fDeclarationsPos, decl);
        this.fActiveDeclarations = null;
    }

    public final void addDeclaration(IASTDeclaration decl) {
        this.addMemberDeclaration(decl);
    }

    public ICPPClassScope getScope() {
        if (this.fScope == null) {
            this.fScope = new CPPClassScope(this);
        }
        return this.fScope;
    }

    public void setScope(ICPPClassScope scope) {
        this.fScope = scope;
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitDeclSpecifiers) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.fName != null && !this.fName.accept(action)) {
            return false;
        }
        ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier[] bases = this.getBaseSpecifiers();
        int i = 0;
        while (i < bases.length) {
            if (!bases[i].accept(action)) {
                return false;
            }
            ++i;
        }
        IASTDeclaration[] decls = this.getDeclarations(action.includeInactiveNodes);
        int i2 = 0;
        while (i2 < decls.length) {
            if (!decls[i2].accept(action)) {
                return false;
            }
            ++i2;
        }
        return !action.shouldVisitDeclSpecifiers || action.leave(this) != 2;
    }

    public int getRoleForName(IASTName name) {
        if (name == this.fName) {
            return 2;
        }
        return 3;
    }

    public void replace(IASTNode child, IASTNode other) {
        assert (child.isActive() == other.isActive());
        int i = 0;
        while (i <= this.fDeclarationsPos) {
            if (this.fAllDeclarations[i] == child) {
                other.setParent(child.getParent());
                other.setPropertyInParent(child.getPropertyInParent());
                this.fAllDeclarations[i] = (IASTDeclaration)other;
                this.fActiveDeclarations = null;
            }
            ++i;
        }
    }
}

