/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCastExpression;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;

public class CPPASTCastExpression
extends ASTNode
implements ICPPASTCastExpression,
IASTAmbiguityParent {
    private int op;
    private IASTExpression operand;
    private IASTTypeId typeId;

    public CPPASTCastExpression() {
    }

    public CPPASTCastExpression(int operator, IASTTypeId typeId, IASTExpression operand) {
        this.op = operator;
        this.setOperand(operand);
        this.setTypeId(typeId);
    }

    public CPPASTCastExpression copy() {
        CPPASTCastExpression copy = new CPPASTCastExpression();
        copy.setOperator(this.getOperator());
        copy.setTypeId(this.typeId == null ? null : this.typeId.copy());
        IASTExpression operand = this.getOperand();
        copy.setOperand(operand == null ? null : operand.copy());
        copy.setOffsetAndLength(this);
        return copy;
    }

    public void setTypeId(IASTTypeId typeId) {
        this.assertNotFrozen();
        this.typeId = typeId;
        if (typeId != null) {
            typeId.setParent(this);
            typeId.setPropertyInParent(TYPE_ID);
        }
    }

    public IASTTypeId getTypeId() {
        return this.typeId;
    }

    public int getOperator() {
        return this.op;
    }

    public void setOperator(int operator) {
        this.assertNotFrozen();
        this.op = operator;
    }

    public IASTExpression getOperand() {
        return this.operand;
    }

    public void setOperand(IASTExpression expression) {
        this.assertNotFrozen();
        this.operand = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(OPERAND);
        }
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.typeId != null && !this.typeId.accept(action)) {
            return false;
        }
        IASTExpression op = this.getOperand();
        if (op != null && !op.accept(action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (child == this.operand) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.operand = (IASTExpression)other;
        }
    }

    public IType getExpressionType() {
        return CPPVisitor.createType(this.typeId.getAbstractDeclarator());
    }
}

