/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;

public class CPPASTArrayModifier
extends ASTNode
implements IASTArrayModifier,
IASTAmbiguityParent {
    private IASTExpression exp;

    public CPPASTArrayModifier() {
    }

    public CPPASTArrayModifier(IASTExpression exp) {
        this.setConstantExpression(exp);
    }

    public IASTExpression getConstantExpression() {
        return this.exp;
    }

    public CPPASTArrayModifier copy() {
        CPPASTArrayModifier copy = new CPPASTArrayModifier(this.exp == null ? null : this.exp.copy());
        copy.setOffsetAndLength(this);
        return copy;
    }

    public void setConstantExpression(IASTExpression expression) {
        this.assertNotFrozen();
        this.exp = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(CONSTANT_EXPRESSION);
        }
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitArrayModifiers) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.exp != null && !this.exp.accept(action)) {
            return false;
        }
        return !action.shouldVisitArrayModifiers || action.leave(this) != 2;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (child == this.exp) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.exp = (IASTExpression)other;
        }
    }
}

