/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTLabelStatement;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;

public class CASTLabelStatement
extends ASTNode
implements IASTLabelStatement,
IASTAmbiguityParent {
    private IASTName name;
    private IASTStatement nestedStatement;

    public CASTLabelStatement() {
    }

    public CASTLabelStatement(IASTName name, IASTStatement nestedStatement) {
        this.setName(name);
        this.setNestedStatement(nestedStatement);
    }

    public CASTLabelStatement copy() {
        CASTLabelStatement copy = new CASTLabelStatement();
        copy.setName(this.name == null ? null : this.name.copy());
        copy.setNestedStatement(this.nestedStatement == null ? null : this.nestedStatement.copy());
        copy.setOffsetAndLength(this);
        return copy;
    }

    public IASTName getName() {
        return this.name;
    }

    public void setName(IASTName name) {
        this.assertNotFrozen();
        this.name = name;
        if (name != null) {
            name.setParent(this);
            name.setPropertyInParent(NAME);
        }
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitStatements) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.name != null && !this.name.accept(action)) {
            return false;
        }
        if (this.nestedStatement != null && !this.nestedStatement.accept(action)) {
            return false;
        }
        if (action.shouldVisitStatements) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public int getRoleForName(IASTName n) {
        if (n == this.name) {
            return 0;
        }
        return 3;
    }

    public IASTStatement getNestedStatement() {
        return this.nestedStatement;
    }

    public void setNestedStatement(IASTStatement s) {
        this.assertNotFrozen();
        this.nestedStatement = s;
        if (s != null) {
            s.setParent(this);
            s.setPropertyInParent(NESTED_STATEMENT);
        }
    }

    public void replace(IASTNode child, IASTNode other) {
        if (child == this.nestedStatement) {
            other.setParent(this);
            other.setPropertyInParent(child.getPropertyInParent());
            this.setNestedStatement((IASTStatement)other);
        }
    }
}

