/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.samm.staticstructure.util;

import eu.qimpress.identifier.Identifier;
import eu.qimpress.identifier.util.IdentifierValidator;
import eu.qimpress.samm.staticstructure.ComponentEndpoint;
import eu.qimpress.samm.staticstructure.ComponentType;
import eu.qimpress.samm.staticstructure.CompositeComponent;
import eu.qimpress.samm.staticstructure.CompositeStructure;
import eu.qimpress.samm.staticstructure.Connector;
import eu.qimpress.samm.staticstructure.EndPoint;
import eu.qimpress.samm.staticstructure.EventPort;
import eu.qimpress.samm.staticstructure.Interface;
import eu.qimpress.samm.staticstructure.InterfacePort;
import eu.qimpress.samm.staticstructure.MessageType;
import eu.qimpress.samm.staticstructure.Operation;
import eu.qimpress.samm.staticstructure.OperationException;
import eu.qimpress.samm.staticstructure.Parameter;
import eu.qimpress.samm.staticstructure.PassiveResource;
import eu.qimpress.samm.staticstructure.Port;
import eu.qimpress.samm.staticstructure.PortEnabledEntity;
import eu.qimpress.samm.staticstructure.PrimitiveComponent;
import eu.qimpress.samm.staticstructure.Repository;
import eu.qimpress.samm.staticstructure.ServiceArchitectureModel;
import eu.qimpress.samm.staticstructure.StaticstructurePackage;
import eu.qimpress.samm.staticstructure.SubcomponentEndpoint;
import eu.qimpress.samm.staticstructure.SubcomponentInstance;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

public class StaticstructureValidator
extends EObjectValidator {
    public static final StaticstructureValidator INSTANCE = new StaticstructureValidator();
    public static final String DIAGNOSTIC_SOURCE = "eu.qimpress.samm.staticstructure";
    public static final int SERVICE_ARCHITECTURE_MODEL__ALL_SUB_COMPONENT_INSTANCES_ARE_DEPLOYED = 1;
    public static final int COMPOSITE_STRUCTURE__ALL_ASSEMBLY_CONNECTORS_ARE_ON_THE_SAME_LEVEL = 2;
    public static final int COMPOSITE_STRUCTURE__ALL_DELEGATION_CONNECTORS_REFERENCE_ONLY_ONE_LEVEL_NESTED_SUBCOMPONENTS = 3;
    public static final int COMPONENT_TYPE__HAS_TO_PROVIDE_OR_REQUIRE_SERVICES = 4;
    public static final int COMPONENT_TYPE__NO_INTERFACE_PORT_ASSOCIATED_TWICE = 5;
    public static final int INTERFACE_PORT__PORT_MUST_BE_EITHER_AREQUIRED_OR_APROVIDED_PORT = 6;
    public static final int CONNECTOR__ONE_LEVEL_CONNECTORS = 7;
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 7;
    protected static final int DIAGNOSTIC_CODE_COUNT = 7;
    protected IdentifierValidator identifierValidator = IdentifierValidator.INSTANCE;

    protected EPackage getEPackage() {
        return StaticstructurePackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validatePassiveResource((PassiveResource)value, diagnostics, context);
            }
            case 1: {
                return this.validateServiceArchitectureModel((ServiceArchitectureModel)value, diagnostics, context);
            }
            case 2: {
                return this.validateCompositeStructure((CompositeStructure)value, diagnostics, context);
            }
            case 3: {
                return this.validateSubcomponentInstance((SubcomponentInstance)value, diagnostics, context);
            }
            case 4: {
                return this.validateComponentType((ComponentType)value, diagnostics, context);
            }
            case 5: {
                return this.validatePortEnabledEntity((PortEnabledEntity)value, diagnostics, context);
            }
            case 6: {
                return this.validateInterfacePort((InterfacePort)value, diagnostics, context);
            }
            case 7: {
                return this.validatePort((Port)value, diagnostics, context);
            }
            case 8: {
                return this.validateInterface((Interface)value, diagnostics, context);
            }
            case 9: {
                return this.validateOperation((Operation)value, diagnostics, context);
            }
            case 10: {
                return this.validateMessageType((MessageType)value, diagnostics, context);
            }
            case 11: {
                return this.validateParameter((Parameter)value, diagnostics, context);
            }
            case 12: {
                return this.validateOperationException((OperationException)value, diagnostics, context);
            }
            case 13: {
                return this.validateEventPort((EventPort)value, diagnostics, context);
            }
            case 14: {
                return this.validateConnector((Connector)value, diagnostics, context);
            }
            case 15: {
                return this.validateEndPoint((EndPoint)value, diagnostics, context);
            }
            case 16: {
                return this.validateSubcomponentEndpoint((SubcomponentEndpoint)value, diagnostics, context);
            }
            case 17: {
                return this.validateRepository((Repository)value, diagnostics, context);
            }
            case 18: {
                return this.validateComponentEndpoint((ComponentEndpoint)value, diagnostics, context);
            }
            case 19: {
                return this.validateCompositeComponent((CompositeComponent)value, diagnostics, context);
            }
            case 20: {
                return this.validatePrimitiveComponent((PrimitiveComponent)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validatePassiveResource(PassiveResource passiveResource, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms((EObject)passiveResource, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)passiveResource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)passiveResource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)passiveResource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)passiveResource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)passiveResource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)passiveResource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_idHasToBeUnique((Identifier)passiveResource, diagnostics, context);
        }
        return result;
    }

    public boolean validateServiceArchitectureModel(ServiceArchitectureModel serviceArchitectureModel, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms((EObject)serviceArchitectureModel, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)serviceArchitectureModel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)serviceArchitectureModel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)serviceArchitectureModel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)serviceArchitectureModel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)serviceArchitectureModel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)serviceArchitectureModel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_idHasToBeUnique((Identifier)serviceArchitectureModel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCompositeStructure_AllAssemblyConnectorsAreOnTheSameLevel(serviceArchitectureModel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCompositeStructure_AllDelegationConnectorsReferenceOnlyOneLevelNestedSubcomponents(serviceArchitectureModel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateServiceArchitectureModel_AllSubComponentInstancesAreDeployed(serviceArchitectureModel, diagnostics, context);
        }
        return result;
    }

    public boolean validateServiceArchitectureModel_AllSubComponentInstancesAreDeployed(ServiceArchitectureModel serviceArchitectureModel, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return serviceArchitectureModel.AllSubComponentInstancesAreDeployed(diagnostics, context);
    }

    public boolean validateCompositeStructure(CompositeStructure compositeStructure, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms((EObject)compositeStructure, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)compositeStructure, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)compositeStructure, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)compositeStructure, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)compositeStructure, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)compositeStructure, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)compositeStructure, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_idHasToBeUnique((Identifier)compositeStructure, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCompositeStructure_AllAssemblyConnectorsAreOnTheSameLevel(compositeStructure, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCompositeStructure_AllDelegationConnectorsReferenceOnlyOneLevelNestedSubcomponents(compositeStructure, diagnostics, context);
        }
        return result;
    }

    public boolean validateCompositeStructure_AllAssemblyConnectorsAreOnTheSameLevel(CompositeStructure compositeStructure, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return compositeStructure.AllAssemblyConnectorsAreOnTheSameLevel(diagnostics, context);
    }

    public boolean validateCompositeStructure_AllDelegationConnectorsReferenceOnlyOneLevelNestedSubcomponents(CompositeStructure compositeStructure, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return compositeStructure.AllDelegationConnectorsReferenceOnlyOneLevelNestedSubcomponents(diagnostics, context);
    }

    public boolean validateSubcomponentInstance(SubcomponentInstance subcomponentInstance, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms((EObject)subcomponentInstance, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)subcomponentInstance, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)subcomponentInstance, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)subcomponentInstance, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)subcomponentInstance, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)subcomponentInstance, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)subcomponentInstance, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_idHasToBeUnique((Identifier)subcomponentInstance, diagnostics, context);
        }
        return result;
    }

    public boolean validateComponentType(ComponentType componentType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms((EObject)componentType, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)componentType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)componentType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)componentType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)componentType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)componentType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)componentType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_idHasToBeUnique((Identifier)componentType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateComponentType_HasToProvideOrRequireServices(componentType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateComponentType_NoInterfacePortAssociatedTwice(componentType, diagnostics, context);
        }
        return result;
    }

    public boolean validateComponentType_HasToProvideOrRequireServices(ComponentType componentType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return componentType.HasToProvideOrRequireServices(diagnostics, context);
    }

    public boolean validateComponentType_NoInterfacePortAssociatedTwice(ComponentType componentType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return componentType.NoInterfacePortAssociatedTwice(diagnostics, context);
    }

    public boolean validatePortEnabledEntity(PortEnabledEntity portEnabledEntity, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms((EObject)portEnabledEntity, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)portEnabledEntity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)portEnabledEntity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)portEnabledEntity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)portEnabledEntity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)portEnabledEntity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)portEnabledEntity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_idHasToBeUnique((Identifier)portEnabledEntity, diagnostics, context);
        }
        return result;
    }

    public boolean validateInterfacePort(InterfacePort interfacePort, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms((EObject)interfacePort, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)interfacePort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)interfacePort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)interfacePort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)interfacePort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)interfacePort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)interfacePort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_idHasToBeUnique((Identifier)interfacePort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateInterfacePort_PortMustBeEitherARequiredOrAProvidedPort(interfacePort, diagnostics, context);
        }
        return result;
    }

    public boolean validateInterfacePort_PortMustBeEitherARequiredOrAProvidedPort(InterfacePort interfacePort, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return interfacePort.PortMustBeEitherARequiredOrAProvidedPort(diagnostics, context);
    }

    public boolean validatePort(Port port, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms((EObject)port, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)port, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)port, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)port, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)port, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)port, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)port, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_idHasToBeUnique((Identifier)port, diagnostics, context);
        }
        return result;
    }

    public boolean validateInterface(Interface interface_, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms((EObject)interface_, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)interface_, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)interface_, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)interface_, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)interface_, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)interface_, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)interface_, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_idHasToBeUnique((Identifier)interface_, diagnostics, context);
        }
        return result;
    }

    public boolean validateOperation(Operation operation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms((EObject)operation, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)operation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)operation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)operation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)operation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)operation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)operation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_idHasToBeUnique((Identifier)operation, diagnostics, context);
        }
        return result;
    }

    public boolean validateMessageType(MessageType messageType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms((EObject)messageType, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)messageType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)messageType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)messageType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)messageType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)messageType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)messageType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_idHasToBeUnique((Identifier)messageType, diagnostics, context);
        }
        return result;
    }

    public boolean validateParameter(Parameter parameter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms((EObject)parameter, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)parameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)parameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)parameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)parameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)parameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)parameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_idHasToBeUnique((Identifier)parameter, diagnostics, context);
        }
        return result;
    }

    public boolean validateOperationException(OperationException operationException, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms((EObject)operationException, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)operationException, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)operationException, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)operationException, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)operationException, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)operationException, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)operationException, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_idHasToBeUnique((Identifier)operationException, diagnostics, context);
        }
        return result;
    }

    public boolean validateEventPort(EventPort eventPort, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms((EObject)eventPort, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)eventPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)eventPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)eventPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)eventPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)eventPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)eventPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_idHasToBeUnique((Identifier)eventPort, diagnostics, context);
        }
        return result;
    }

    public boolean validateConnector(Connector connector, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms((EObject)connector, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)connector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)connector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)connector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)connector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)connector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)connector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_idHasToBeUnique((Identifier)connector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateConnector_oneLevelConnectors(connector, diagnostics, context);
        }
        return result;
    }

    public boolean validateConnector_oneLevelConnectors(Connector connector, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return connector.oneLevelConnectors(diagnostics, context);
    }

    public boolean validateEndPoint(EndPoint endPoint, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms((EObject)endPoint, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)endPoint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)endPoint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)endPoint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)endPoint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)endPoint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)endPoint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_idHasToBeUnique((Identifier)endPoint, diagnostics, context);
        }
        return result;
    }

    public boolean validateSubcomponentEndpoint(SubcomponentEndpoint subcomponentEndpoint, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms((EObject)subcomponentEndpoint, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)subcomponentEndpoint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)subcomponentEndpoint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)subcomponentEndpoint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)subcomponentEndpoint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)subcomponentEndpoint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)subcomponentEndpoint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_idHasToBeUnique((Identifier)subcomponentEndpoint, diagnostics, context);
        }
        return result;
    }

    public boolean validateRepository(Repository repository, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms((EObject)repository, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)repository, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)repository, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)repository, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)repository, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)repository, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)repository, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_idHasToBeUnique((Identifier)repository, diagnostics, context);
        }
        return result;
    }

    public boolean validateComponentEndpoint(ComponentEndpoint componentEndpoint, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms((EObject)componentEndpoint, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)componentEndpoint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)componentEndpoint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)componentEndpoint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)componentEndpoint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)componentEndpoint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)componentEndpoint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_idHasToBeUnique((Identifier)componentEndpoint, diagnostics, context);
        }
        return result;
    }

    public boolean validateCompositeComponent(CompositeComponent compositeComponent, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms((EObject)compositeComponent, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)compositeComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)compositeComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)compositeComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)compositeComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)compositeComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)compositeComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_idHasToBeUnique((Identifier)compositeComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateComponentType_HasToProvideOrRequireServices(compositeComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateComponentType_NoInterfacePortAssociatedTwice(compositeComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCompositeStructure_AllAssemblyConnectorsAreOnTheSameLevel(compositeComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCompositeStructure_AllDelegationConnectorsReferenceOnlyOneLevelNestedSubcomponents(compositeComponent, diagnostics, context);
        }
        return result;
    }

    public boolean validatePrimitiveComponent(PrimitiveComponent primitiveComponent, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms((EObject)primitiveComponent, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)primitiveComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)primitiveComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)primitiveComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)primitiveComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)primitiveComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)primitiveComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_idHasToBeUnique((Identifier)primitiveComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateComponentType_HasToProvideOrRequireServices(primitiveComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateComponentType_NoInterfacePortAssociatedTwice(primitiveComponent, diagnostics, context);
        }
        return result;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

