/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.samm.deployment.hardware;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CacheKind implements Enumerator
{
    INSTRUCTION(0, "Instruction", "Instruction"),
    DATA(1, "Data", "Data"),
    UNIFIED(2, "Unified", "Unified");

    public static final int INSTRUCTION_VALUE = 0;
    public static final int DATA_VALUE = 1;
    public static final int UNIFIED_VALUE = 2;
    private static final CacheKind[] VALUES_ARRAY;
    public static final List<CacheKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CacheKind[]{INSTRUCTION, DATA, UNIFIED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CacheKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CacheKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CacheKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CacheKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CacheKind get(int value) {
        switch (value) {
            case 0: {
                return INSTRUCTION;
            }
            case 1: {
                return DATA;
            }
            case 2: {
                return UNIFIED;
            }
        }
        return null;
    }

    private CacheKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

