/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.samm.datatypes.impl;

import eu.qimpress.samm.datatypes.CollectionDataType;
import eu.qimpress.samm.datatypes.ComplexDataType;
import eu.qimpress.samm.datatypes.DatatypesFactory;
import eu.qimpress.samm.datatypes.DatatypesPackage;
import eu.qimpress.samm.datatypes.InnerElement;
import eu.qimpress.samm.datatypes.PrimitiveDataType;
import eu.qimpress.samm.datatypes.XSDPrimitiveDataTypes;
import eu.qimpress.samm.datatypes.impl.CollectionDataTypeImpl;
import eu.qimpress.samm.datatypes.impl.ComplexDataTypeImpl;
import eu.qimpress.samm.datatypes.impl.InnerElementImpl;
import eu.qimpress.samm.datatypes.impl.PrimitiveDataTypeImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class DatatypesFactoryImpl
extends EFactoryImpl
implements DatatypesFactory {
    public static DatatypesFactory init() {
        try {
            DatatypesFactory theDatatypesFactory = (DatatypesFactory)EPackage.Registry.INSTANCE.getEFactory("http://q-impress.eu/samm/datatype");
            if (theDatatypesFactory != null) {
                return theDatatypesFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new DatatypesFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createCollectionDataType();
            }
            case 1: {
                return this.createComplexDataType();
            }
            case 2: {
                return this.createInnerElement();
            }
            case 3: {
                return this.createPrimitiveDataType();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 5: {
                return this.createXSDPrimitiveDataTypesFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 5: {
                return this.convertXSDPrimitiveDataTypesToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public CollectionDataType createCollectionDataType() {
        CollectionDataTypeImpl collectionDataType = new CollectionDataTypeImpl();
        return collectionDataType;
    }

    @Override
    public ComplexDataType createComplexDataType() {
        ComplexDataTypeImpl complexDataType = new ComplexDataTypeImpl();
        return complexDataType;
    }

    @Override
    public InnerElement createInnerElement() {
        InnerElementImpl innerElement = new InnerElementImpl();
        return innerElement;
    }

    @Override
    public PrimitiveDataType createPrimitiveDataType() {
        PrimitiveDataTypeImpl primitiveDataType = new PrimitiveDataTypeImpl();
        return primitiveDataType;
    }

    public XSDPrimitiveDataTypes createXSDPrimitiveDataTypesFromString(EDataType eDataType, String initialValue) {
        XSDPrimitiveDataTypes result = XSDPrimitiveDataTypes.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertXSDPrimitiveDataTypesToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public DatatypesPackage getDatatypesPackage() {
        return (DatatypesPackage)this.getEPackage();
    }

    @Deprecated
    public static DatatypesPackage getPackage() {
        return DatatypesPackage.eINSTANCE;
    }
}

