/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.samm.datatypes;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum XSDPrimitiveDataTypes implements Enumerator
{
    STRING(0, "string", "string"),
    INT(1, "int", "int"),
    FLOAT(2, "float", "float"),
    DATE(3, "date", "date"),
    TIME(4, "time", "time"),
    BOOLEAN(5, "boolean", "boolean");

    public static final int STRING_VALUE = 0;
    public static final int INT_VALUE = 1;
    public static final int FLOAT_VALUE = 2;
    public static final int DATE_VALUE = 3;
    public static final int TIME_VALUE = 4;
    public static final int BOOLEAN_VALUE = 5;
    private static final XSDPrimitiveDataTypes[] VALUES_ARRAY;
    public static final List<XSDPrimitiveDataTypes> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new XSDPrimitiveDataTypes[]{STRING, INT, FLOAT, DATE, TIME, BOOLEAN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static XSDPrimitiveDataTypes get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            XSDPrimitiveDataTypes result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static XSDPrimitiveDataTypes getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            XSDPrimitiveDataTypes result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static XSDPrimitiveDataTypes get(int value) {
        switch (value) {
            case 0: {
                return STRING;
            }
            case 1: {
                return INT;
            }
            case 2: {
                return FLOAT;
            }
            case 3: {
                return DATE;
            }
            case 4: {
                return TIME;
            }
            case 5: {
                return BOOLEAN;
            }
        }
        return null;
    }

    private XSDPrimitiveDataTypes(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

