/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow;

import de.uka.ipd.sdq.workflow.Blackboard;
import de.uka.ipd.sdq.workflow.ExecutionTimeLoggingProgressMonitor;
import de.uka.ipd.sdq.workflow.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.OrderPreservingBlackboardCompositeJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import org.eclipse.core.runtime.IProgressMonitor;

public class LowMemoryFootprintCompositeJob<BlackboardType extends Blackboard<?>>
extends OrderPreservingBlackboardCompositeJob<BlackboardType> {
    @Override
    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        ExecutionTimeLoggingProgressMonitor subProgressMonitor = new ExecutionTimeLoggingProgressMonitor(monitor, 1);
        subProgressMonitor.beginTask("Composite Job Execution", this.myJobs.size());
        int totalNumberOfJobs = this.myJobs.size();
        int i = 0;
        while (i < totalNumberOfJobs) {
            if (monitor.isCanceled()) {
                throw new UserCanceledException();
            }
            IJob job = (IJob)this.myJobs.getFirst();
            if (job instanceof IBlackboardInteractingJob) {
                ((IBlackboardInteractingJob)job).setBlackboard(this.myBlackboard);
            }
            this.logger.debug((Object)("SDQ Workflow-Engine: Running job " + job.getName()));
            subProgressMonitor.subTask(job.getName());
            job.execute((IProgressMonitor)subProgressMonitor);
            subProgressMonitor.worked(1);
            subProgressMonitor.subTask("Cleaning up job " + job.getName());
            try {
                job.rollback((IProgressMonitor)subProgressMonitor);
            }
            catch (RollbackFailedException rollbackFailedException) {
                this.logger.warn((Object)("Failed to cleanup job " + job.getName()));
            }
            subProgressMonitor.worked(1);
            this.myJobs.removeFirst();
            job = null;
            ++i;
        }
        subProgressMonitor.done();
    }

    @Override
    public void rollback(IProgressMonitor monitor) throws RollbackFailedException {
    }
}

