/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow;

import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class ExecutionTimeLoggingProgressMonitor
extends SubProgressMonitor {
    double startTime = 0.0;
    private String taskName;
    Logger logger = Logger.getLogger(ExecutionTimeLoggingProgressMonitor.class);
    private int totalWork;
    private int completedWork;

    public ExecutionTimeLoggingProgressMonitor(IProgressMonitor monitor, int ticks) {
        super(monitor, ticks);
    }

    public void beginTask(String name, int totalWork) {
        this.startTime = System.nanoTime();
        this.taskName = name;
        this.totalWork = totalWork;
        this.completedWork = 0;
        super.beginTask(name, totalWork);
    }

    public void done() {
        double endTime = System.nanoTime();
        super.done();
        this.logger.info((Object)("Task " + this.taskName + " completed in " + (endTime - this.startTime) / Math.pow(10.0, 9.0) + " seconds"));
    }

    public void internalWorked(double work) {
        super.internalWorked(work);
    }

    public boolean isCanceled() {
        return super.isCanceled();
    }

    public void setCanceled(boolean value) {
        super.setCanceled(value);
    }

    public void setTaskName(String name) {
        this.taskName = name;
        super.setTaskName(name);
    }

    public void subTask(String name) {
        super.subTask(name);
    }

    public void worked(int work) {
        super.worked(work);
    }
}

