/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.sourcelookup;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.ui.sourcelookup.AbstractSourceContainerBrowser;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ProjectSelectionDialog;
import org.eclipse.jdt.internal.debug.ui.sourcelookup.SourceLookupMessages;
import org.eclipse.jdt.launching.sourcelookup.containers.ClasspathContainerSourceContainer;
import org.eclipse.jdt.launching.sourcelookup.containers.ClasspathVariableSourceContainer;
import org.eclipse.jdt.launching.sourcelookup.containers.JavaProjectSourceContainer;
import org.eclipse.jdt.launching.sourcelookup.containers.PackageFragmentRootSourceContainer;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;

public class JavaProjectSourceContainerBrowser
extends AbstractSourceContainerBrowser {
    public ISourceContainer[] addSourceContainers(Shell shell, ISourceLookupDirector director) {
        List projects = this.getPossibleAdditions(director);
        ProjectSelectionDialog dialog = new ProjectSelectionDialog(shell, projects);
        dialog.setTitle(SourceLookupMessages.JavaProjectSourceContainerBrowser_1);
        MultiStatus status = new MultiStatus(JDIDebugUIPlugin.getUniqueIdentifier(), 150, "Failed to add project(s)", null);
        ArrayList<JavaProjectSourceContainer> sourceContainers = new ArrayList<JavaProjectSourceContainer>();
        if (dialog.open() == 0) {
            IJavaProject jp;
            Object[] selections = dialog.getResult();
            ArrayList<IJavaProject> additions = new ArrayList<IJavaProject>(selections.length);
            try {
                int i = 0;
                while (i < selections.length) {
                    jp = (IJavaProject)selections[i];
                    if (dialog.isAddRequiredProjects()) {
                        this.collectRequiredProjects(jp, additions);
                    } else {
                        additions.add(jp);
                    }
                    ++i;
                }
            }
            catch (JavaModelException e) {
                status.add(e.getStatus());
            }
            Iterator iter = additions.iterator();
            while (iter.hasNext()) {
                jp = (IJavaProject)iter.next();
                sourceContainers.add(new JavaProjectSourceContainer(jp));
                if (!dialog.isAddExportedEntries()) continue;
                try {
                    this.collectExportedEntries(jp, sourceContainers);
                }
                catch (CoreException e) {
                    status.add(e.getStatus());
                }
            }
        }
        if (!status.isOK()) {
            JDIDebugUIPlugin.statusDialog((IStatus)status);
        }
        return sourceContainers.toArray(new ISourceContainer[sourceContainers.size()]);
    }

    protected List getPossibleAdditions(ISourceLookupDirector director) {
        IJavaProject[] projects;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        try {
            projects = JavaCore.create((IWorkspaceRoot)root).getJavaProjects();
        }
        catch (JavaModelException e) {
            JDIDebugUIPlugin.log(e);
            projects = new IJavaProject[]{};
        }
        ArrayList<IJavaProject> remaining = new ArrayList<IJavaProject>();
        int i = 0;
        while (i < projects.length) {
            remaining.add(projects[i]);
            ++i;
        }
        ArrayList<IJavaProject> alreadySelected = new ArrayList<IJavaProject>();
        ISourceContainer[] containers = director.getSourceContainers();
        int i2 = 0;
        while (i2 < containers.length) {
            ISourceContainer container = containers[i2];
            if (container.getType().getId().equals(JavaProjectSourceContainer.TYPE_ID)) {
                alreadySelected.add(((JavaProjectSourceContainer)container).getJavaProject());
            }
            ++i2;
        }
        remaining.removeAll(alreadySelected);
        return remaining;
    }

    protected void collectRequiredProjects(IJavaProject proj, List res) throws JavaModelException {
        if (!res.contains(proj)) {
            res.add(proj);
            IJavaModel model = proj.getJavaModel();
            IClasspathEntry[] entries = proj.getRawClasspath();
            int i = 0;
            while (i < entries.length) {
                IJavaProject ref;
                IClasspathEntry curr = entries[i];
                if (curr.getEntryKind() == 2 && (ref = model.getJavaProject(curr.getPath().segment(0))).exists()) {
                    this.collectRequiredProjects(ref, res);
                }
                ++i;
            }
        }
    }

    protected void collectExportedEntries(IJavaProject proj, List list) throws CoreException {
        IClasspathEntry[] entries = proj.getRawClasspath();
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            ClasspathVariableSourceContainer sourceContainer = null;
            if (entry.isExported()) {
                switch (entry.getEntryKind()) {
                    case 5: {
                        IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)proj);
                        sourceContainer = new ClasspathContainerSourceContainer(container.getPath());
                        break;
                    }
                    case 1: {
                        IPackageFragmentRoot[] roots = proj.findPackageFragmentRoots(entry);
                        if (roots == null || roots.length <= 0) break;
                        sourceContainer = new PackageFragmentRootSourceContainer(roots[0]);
                        break;
                    }
                    case 2: {
                        IJavaProject jp;
                        String name = entry.getPath().segment(0);
                        IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                        if (!p.exists() || !(jp = JavaCore.create((IProject)p)).exists()) break;
                        sourceContainer = new JavaProjectSourceContainer(jp);
                        break;
                    }
                    case 4: {
                        sourceContainer = new ClasspathVariableSourceContainer(entry.getPath());
                        break;
                    }
                }
                if (sourceContainer != null && !list.contains(sourceContainer)) {
                    list.add(sourceContainer);
                }
            }
            ++i;
        }
    }

    class ContentProvider
    implements IStructuredContentProvider {
        private List fProjects;

        public ContentProvider(List projects) {
            this.fProjects = projects;
        }

        public Object[] getElements(Object inputElement) {
            return this.fProjects.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

