/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.monitors;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.ui.JavaDebugUtils;
import org.eclipse.jdt.internal.debug.core.model.JDIThread;
import org.eclipse.jdt.internal.debug.ui.monitors.JavaElementContentProvider;
import org.eclipse.jdt.internal.debug.ui.monitors.NoMonitorInformationElement;

public class JavaThreadContentProvider
extends JavaElementContentProvider {
    protected int getChildCount(Object element, IPresentationContext context, IViewerUpdate monitor) throws CoreException {
        IJavaThread thread = (IJavaThread)element;
        if (!thread.isSuspended()) {
            return 0;
        }
        int childCount = thread.getFrameCount();
        if (JavaThreadContentProvider.isDisplayMonitors()) {
            if (((IJavaDebugTarget)thread.getDebugTarget()).supportsMonitorInformation()) {
                childCount += thread.getOwnedMonitors().length;
                if (thread.getContendedMonitor() != null) {
                    ++childCount;
                }
            } else {
                ++childCount;
            }
        }
        return childCount;
    }

    protected Object[] getChildren(Object parent, int index, int length, IPresentationContext context, IViewerUpdate monitor) throws CoreException {
        IJavaThread thread = (IJavaThread)parent;
        if (!thread.isSuspended()) {
            return this.EMPTY;
        }
        return this.getElements(this.getChildren(thread), index, length);
    }

    protected Object[] getChildren(IJavaThread thread) {
        try {
            Object[] children;
            JDIThread jThread;
            if (thread instanceof JDIThread && !(jThread = (JDIThread)thread).getDebugTarget().isSuspended() && jThread.isSuspendVoteInProgress()) {
                return this.EMPTY;
            }
            Object[] frames = thread.getStackFrames();
            if (!JavaThreadContentProvider.isDisplayMonitors()) {
                return frames;
            }
            int length = frames.length;
            if (((IJavaDebugTarget)thread.getDebugTarget()).supportsMonitorInformation()) {
                IDebugElement[] ownedMonitors = JavaDebugUtils.getOwnedMonitors((IThread)thread);
                IDebugElement contendedMonitor = JavaDebugUtils.getContendedMonitor((IThread)thread);
                if (ownedMonitors != null) {
                    length += ownedMonitors.length;
                }
                if (contendedMonitor != null) {
                    ++length;
                }
                children = new Object[length];
                if (ownedMonitors != null && ownedMonitors.length > 0) {
                    System.arraycopy(ownedMonitors, 0, children, 0, ownedMonitors.length);
                }
                if (contendedMonitor != null) {
                    children[ownedMonitors.length] = contendedMonitor;
                }
            } else {
                children = new Object[length + 1];
                children[0] = new NoMonitorInformationElement(thread.getDebugTarget());
            }
            int offset = children.length - frames.length;
            System.arraycopy(frames, 0, children, offset, frames.length);
            return children;
        }
        catch (DebugException debugException) {
            return this.EMPTY;
        }
    }

    protected boolean hasChildren(Object element, IPresentationContext context, IViewerUpdate monitor) throws CoreException {
        JDIThread jThread;
        if (element instanceof JDIThread && !(jThread = (JDIThread)element).getDebugTarget().isSuspended() && jThread.isSuspendVoteInProgress()) {
            return false;
        }
        return ((IJavaThread)element).hasStackFrames() || JavaThreadContentProvider.isDisplayMonitors() && ((IJavaThread)element).hasOwnedMonitors();
    }

    protected ISchedulingRule getRule(IChildrenCountUpdate[] updates) {
        return this.getThreadRule((IViewerUpdate[])updates);
    }

    protected ISchedulingRule getRule(IChildrenUpdate[] updates) {
        return this.getThreadRule((IViewerUpdate[])updates);
    }

    protected ISchedulingRule getRule(IHasChildrenUpdate[] updates) {
        return this.getThreadRule((IViewerUpdate[])updates);
    }

    private ISchedulingRule getThreadRule(IViewerUpdate[] updates) {
        Object element;
        if (updates.length > 0 && (element = updates[0].getElement()) instanceof JDIThread) {
            return ((JDIThread)element).getThreadRule();
        }
        return null;
    }
}

