/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.pcmbench.wizards;

import de.uka.ipd.sdq.pcmbench.PCMBenchActivator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class RepositoryProjectWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    private IStructuredSelection selection;
    private WizardNewProjectCreationPage page;
    private IWorkspace workspace = ResourcesPlugin.getWorkspace();

    public boolean performFinish() {
        IProject newProject = this.workspace.getRoot().getProject(this.page.getProjectName());
        try {
            if (!newProject.exists()) {
                newProject.create(null);
            }
            newProject.open(null);
            IProjectDescription description = newProject.getDescription();
            String[] natures = description.getNatureIds();
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 0, natures.length);
            newNatures[natures.length] = "de.uka.ipd.sdq.pcmbench.nature";
            IStatus status = this.workspace.validateNatureSet(natures);
            if (status.getCode() == 0) {
                description.setNatureIds(newNatures);
                newProject.setDescription(description, null);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
    }

    public void addPages() {
        this.page = new WizardNewProjectCreationPage("Create New Palladio Component Repository Project");
        this.page.setDescription("Create a new Palladio Component Repository Modelling Project. This type of project is used to specify component repositories.");
        this.page.setMessage(this.page.getDescription(), 1);
        this.page.setImageDescriptor(PCMBenchActivator.imageDescriptorFromPlugin((String)"de.uka.ipd.sdq.pcmbench", (String)"icons/palladio-logo.gif"));
        this.page.setTitle("Create a PCM Component Repository Modelling Project");
        this.addPage((IWizardPage)this.page);
    }
}

