/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.pcmbench.navigator;

import de.uka.ipd.sdq.pcm.repository.RepositoryPackage;
import de.uka.ipd.sdq.pcm.repository.provider.RepositoryItemProviderAdapterFactory;
import de.uka.ipd.sdq.pcm.seff.provider.SeffItemProviderAdapterFactory;
import de.uka.ipd.sdq.pcmbench.navigator.LinkedRepositoriesNode;
import de.uka.ipd.sdq.pcmbench.navigator.MySaveablesProvider;
import de.uka.ipd.sdq.pcmbench.ui.provider.categoryaware.CategoryAwareItemProviderAdapterFactory;
import de.uka.ipd.sdq.pcmbench.ui.provider.categoryaware.GenericCategoryItemProvider;
import de.uka.ipd.sdq.pcmbench.ui.provider.categoryaware.ICategoryDescriptions;
import de.uka.ipd.sdq.pcmbench.ui.provider.categoryaware.PalladioCategoryDescriptions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;

public class PCMNavigatorContentProvider
implements ITreeContentProvider,
IAdaptable {
    private Object input;
    protected final TransactionalEditingDomain editingDomain = null;
    private StructuredViewer viewer;
    private ComposedAdapterFactory adapterFactory;
    private AdapterFactoryContentProvider contentProvider;
    private MySaveablesProvider saveProvider = null;
    private Hashtable<IProject, LinkedRepositoriesNode> myLinkedRepositoriesNodes = new Hashtable();

    public PCMNavigatorContentProvider() {
        EContentAdapter repositoryResourceListeners = new EContentAdapter(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void notifyChanged(Notification notification) {
                if (notification.getNotifier() instanceof ResourceSet) {
                    switch (notification.getFeatureID(ResourceSet.class)) {
                        case 0: {
                            if (notification.getEventType() != 3) return;
                            System.out.println("New Resource loaded...");
                            PCMNavigatorContentProvider.this.viewer.refresh();
                        }
                        default: {
                            return;
                        }
                    }
                } else if (notification.getNotifier() instanceof Resource) {
                    switch (notification.getFeatureID(Resource.class)) {
                        case 4: {
                            if (notification.getEventType() != 1) return;
                            System.out.println("New Resource loaded...");
                            PCMNavigatorContentProvider.this.viewer.refresh();
                        }
                        default: {
                            return;
                        }
                    }
                } else {
                    super.notifyChanged(notification);
                }
            }
        };
        repositoryResourceListeners.setTarget((Notifier)this.editingDomain.getResourceSet());
        this.editingDomain.getResourceSet().eAdapters().add((Object)repositoryResourceListeners);
        this.adapterFactory = new ComposedAdapterFactory();
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new RepositoryItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new SeffItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        CategoryAwareItemProviderAdapterFactory decoratorFactory = new CategoryAwareItemProviderAdapterFactory((AdapterFactory)this.adapterFactory, (ICategoryDescriptions)new PalladioCategoryDescriptions());
        this.contentProvider = new AdapterFactoryContentProvider((AdapterFactory)decoratorFactory);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IProject) {
            ArrayList<LinkedRepositoriesNode> children = new ArrayList<LinkedRepositoriesNode>();
            children.add(this.myLinkedRepositoriesNodes.get(parentElement));
            return children.toArray();
        }
        if (parentElement instanceof LinkedRepositoriesNode) {
            ArrayList resourceList = new ArrayList();
            for (Resource r : this.editingDomain.getResourceSet().getResources()) {
                if (!r.isLoaded()) {
                    try {
                        r.load(new HashMap());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (!r.isLoaded()) continue;
                Collection repositories = EcoreUtil.getObjectsByType((Collection)r.getContents(), (EClassifier)RepositoryPackage.eINSTANCE.getRepository());
                resourceList.addAll(repositories);
            }
            return resourceList.toArray();
        }
        if (parentElement instanceof EObject || parentElement instanceof GenericCategoryItemProvider) {
            return this.contentProvider.getChildren(parentElement);
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof LinkedRepositoriesNode) {
            return ((LinkedRepositoriesNode)element).getParent();
        }
        if (element instanceof EObject) {
            Object originalParent = this.contentProvider.getParent(element);
            if (originalParent instanceof Resource) {
                return this.myLinkedRepositoriesNodes.get(ResourcesPlugin.getWorkspace().getRoot().getProjects()[0]);
            }
            return originalParent;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (this.getChildren(element) == null) {
            return false;
        }
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.input = newInput;
        this.viewer = (StructuredViewer)viewer;
        this.contentProvider.inputChanged(viewer, oldInput, newInput);
        this.populateHashtable();
    }

    private void populateHashtable() {
        this.myLinkedRepositoriesNodes.clear();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            this.myLinkedRepositoriesNodes.put(p, new LinkedRepositoriesNode(p));
            ++n2;
        }
    }

    public Object getAdapter(Class adapter) {
        return null;
    }
}

