/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.pcmbench.navigator;

import de.uka.ipd.sdq.pcm.seff.ResourceDemandingSEFF;
import de.uka.ipd.sdq.pcmbench.ui.provider.categoryaware.GenericCategoryItemProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.CommandActionDelegate;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.emf.edit.ui.action.CreateSiblingAction;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public class ChildAddMenuProvider
extends CommonActionProvider {
    private Collection createChildActions;
    private Collection createSiblingActions;
    private IWorkbenchWindow workbenchWindow;

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        ICommonViewerSite viewSite = aSite.getViewSite();
        if (viewSite instanceof ICommonViewerWorkbenchSite) {
            ICommonViewerWorkbenchSite workbench = (ICommonViewerWorkbenchSite)viewSite;
            this.workbenchWindow = workbench.getWorkbenchWindow();
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        MenuManager siblingSubmenu;
        super.fillContextMenu(menu);
        final TransactionalEditingDomain domain = null;
        Collection newChildDescriptors = null;
        Collection newSiblingDescriptors = null;
        ISelection selection = this.getContext().getSelection();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            Object object = ((IStructuredSelection)selection).getFirstElement();
            newChildDescriptors = domain.getNewChildDescriptors(object, null);
            newSiblingDescriptors = domain.getNewChildDescriptors(null, object);
            boolean cfr_ignored_0 = object instanceof ResourceDemandingSEFF;
        }
        this.createChildActions = new ArrayList();
        if (newChildDescriptors != null) {
            Iterator i = newChildDescriptors.iterator();
            while (i.hasNext()) {
                this.createChildActions.add(new CreateChildAction(this.workbenchWindow.getActivePage().getActivePart(), selection, i.next()){

                    public void configureAction(ISelection selection) {
                        this.editingDomain = domain;
                        IStructuredSelection sselection = (IStructuredSelection)selection;
                        ArrayList collection = new ArrayList(sselection.size());
                        for (Object selectedObject : sselection) {
                            if (selectedObject instanceof GenericCategoryItemProvider) {
                                selectedObject = ((GenericCategoryItemProvider)selectedObject).getParent(selectedObject);
                            }
                            collection.add(selectedObject);
                        }
                        if (this.editingDomain != null) {
                            this.command = this.createActionCommand(this.editingDomain, collection);
                            this.setEnabled(this.command.canExecute());
                        }
                        if (this.command == null || this.command == UnexecutableCommand.INSTANCE) {
                            this.disable();
                        } else if (!(this.command instanceof CommandActionDelegate)) {
                            if (this.getDefaultImageDescriptor() != null) {
                                this.setImageDescriptor(this.getDefaultImageDescriptor());
                            }
                        } else {
                            CommandActionDelegate commandActionDelegate = (CommandActionDelegate)this.command;
                            ImageDescriptor imageDescriptor = this.objectToImageDescriptor(commandActionDelegate.getImage());
                            if (imageDescriptor != null) {
                                this.setImageDescriptor(imageDescriptor);
                            } else if (this.getDefaultImageDescriptor() != null) {
                                this.setImageDescriptor(this.getDefaultImageDescriptor());
                            }
                            if (commandActionDelegate.getText() != null) {
                                this.setText(commandActionDelegate.getText());
                            }
                            if (commandActionDelegate.getDescription() != null) {
                                this.setDescription(commandActionDelegate.getDescription());
                            }
                            if (commandActionDelegate.getToolTipText() != null) {
                                this.setToolTipText(commandActionDelegate.getToolTipText());
                            }
                        }
                    }
                });
            }
        }
        this.createSiblingActions = newSiblingDescriptors != null && ((IStructuredSelection)selection).getFirstElement() instanceof EObject ? this.generateCreateSiblingActions(newSiblingDescriptors, selection) : Collections.EMPTY_SET;
        MenuManager childSubmenu = new MenuManager("Child");
        if (childSubmenu != null) {
            this.populateManager((IContributionManager)childSubmenu, this.createChildActions, null);
            childSubmenu.update(true);
        }
        if ((siblingSubmenu = new MenuManager("Sibling")) != null) {
            this.populateManager((IContributionManager)siblingSubmenu, this.createSiblingActions, null);
            siblingSubmenu.update(true);
        }
    }

    protected Collection generateCreateChildActions(Collection descriptors, ISelection selection) {
        ArrayList<CreateChildAction> actions = new ArrayList<CreateChildAction>();
        if (descriptors != null) {
            Iterator i = descriptors.iterator();
            while (i.hasNext()) {
                actions.add(new CreateChildAction(this.workbenchWindow.getActivePage().getActivePart(), selection, i.next()));
            }
        }
        return actions;
    }

    protected Collection generateCreateSiblingActions(Collection descriptors, ISelection selection) {
        ArrayList<CreateSiblingAction> actions = new ArrayList<CreateSiblingAction>();
        if (descriptors != null) {
            Iterator i = descriptors.iterator();
            while (i.hasNext()) {
                actions.add(new CreateSiblingAction(this.workbenchWindow.getActivePage().getActivePart(), selection, i.next()));
            }
        }
        return actions;
    }

    protected void populateManager(IContributionManager manager, Collection actions, String contributionID) {
        if (actions != null) {
            for (IAction action : actions) {
                if (contributionID != null) {
                    manager.insertBefore(contributionID, action);
                    continue;
                }
                manager.add(action);
            }
        }
    }

    public void fillActionBars(IActionBars actionBars) {
    }
}

