/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.analysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.antlr.analysis.AnalysisTimeoutException;
import org.antlr.analysis.DFAState;
import org.antlr.analysis.DecisionProbe;
import org.antlr.analysis.Label;
import org.antlr.analysis.NFA;
import org.antlr.analysis.NFAState;
import org.antlr.analysis.NFAToDFAConverter;
import org.antlr.analysis.NonLLStarDecisionException;
import org.antlr.analysis.SemanticContext;
import org.antlr.analysis.Transition;
import org.antlr.codegen.CodeGenerator;
import org.antlr.misc.IntSet;
import org.antlr.misc.IntervalSet;
import org.antlr.misc.Utils;
import org.antlr.runtime.IntStream;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.FASerializer;
import org.antlr.tool.GrammarAST;
import org.antlr.tool.Interpreter;
import org.antlr.tool.Rule;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DFA {
    public static final int REACHABLE_UNKNOWN = -2;
    public static final int REACHABLE_BUSY = -1;
    public static final int REACHABLE_NO = 0;
    public static final int REACHABLE_YES = 1;
    public static int MAX_TIME_PER_DFA_CREATION = 1000;
    public static int MAX_STATE_TRANSITIONS_FOR_TABLE = 65534;
    public DFAState startState;
    public int decisionNumber;
    public NFAState decisionNFAStartState;
    public String description;
    protected Map<DFAState, DFAState> uniqueStates;
    protected Vector<DFAState> states;
    protected int stateCounter;
    protected int numberOfStates;
    protected int user_k;
    protected int max_k;
    protected boolean reduced;
    protected boolean cyclic;
    public boolean predicateVisible;
    public boolean hasPredicateBlockedByAction;
    protected List<Integer> unreachableAlts;
    protected int nAlts;
    protected DFAState[] altToAcceptState;
    public IntSet recursiveAltSet;
    public NFA nfa;
    protected NFAToDFAConverter nfaConverter;
    public DecisionProbe probe;
    protected long conversionStartTime;
    public Map edgeTransitionClassMap;
    protected int edgeTransitionClass;
    public List specialStates;
    public List specialStateSTs;
    public Vector accept;
    public Vector eot;
    public Vector eof;
    public Vector min;
    public Vector max;
    public Vector special;
    public Vector transition;
    public Vector transitionEdgeTables;
    protected int uniqueCompressedSpecialStateNum;
    protected CodeGenerator generator;

    protected DFA() {
        this.decisionNumber = 0;
        this.uniqueStates = new HashMap<DFAState, DFAState>();
        this.states = new Vector();
        this.stateCounter = 0;
        this.numberOfStates = 0;
        this.user_k = -1;
        this.max_k = -1;
        this.reduced = true;
        this.cyclic = false;
        this.predicateVisible = false;
        this.hasPredicateBlockedByAction = false;
        this.nAlts = 0;
        this.recursiveAltSet = new IntervalSet();
        this.probe = new DecisionProbe(this);
        this.edgeTransitionClassMap = new LinkedHashMap();
        this.edgeTransitionClass = 0;
        this.uniqueCompressedSpecialStateNum = 0;
        this.generator = null;
    }

    public DFA(int n, NFAState nFAState) {
        block5: {
            this.decisionNumber = 0;
            this.uniqueStates = new HashMap<DFAState, DFAState>();
            this.states = new Vector();
            this.stateCounter = 0;
            this.numberOfStates = 0;
            this.user_k = -1;
            this.max_k = -1;
            this.reduced = true;
            this.cyclic = false;
            this.predicateVisible = false;
            this.hasPredicateBlockedByAction = false;
            this.nAlts = 0;
            this.recursiveAltSet = new IntervalSet();
            this.probe = new DecisionProbe(this);
            this.edgeTransitionClassMap = new LinkedHashMap();
            this.edgeTransitionClass = 0;
            this.uniqueCompressedSpecialStateNum = 0;
            this.generator = null;
            this.decisionNumber = n;
            this.decisionNFAStartState = nFAState;
            this.nfa = nFAState.nfa;
            this.nAlts = this.nfa.grammar.getNumberOfAltsForDecisionNFA(nFAState);
            this.initAltRelatedInfo();
            this.nfaConverter = new NFAToDFAConverter(this);
            try {
                this.nfaConverter.convert();
                this.verify();
                if (!this.probe.isDeterministic() || this.probe.analysisOverflowed()) {
                    this.probe.issueWarnings();
                }
                this.resetStateNumbersToBeContiguous();
            }
            catch (AnalysisTimeoutException analysisTimeoutException) {
                this.probe.reportAnalysisTimeout();
                if (!this.okToRetryDFAWithK1()) {
                    this.probe.issueWarnings();
                }
            }
            catch (NonLLStarDecisionException nonLLStarDecisionException) {
                this.probe.reportNonLLStarDecision(this);
                if (this.okToRetryDFAWithK1()) break block5;
                this.probe.issueWarnings();
            }
        }
    }

    public void resetStateNumbersToBeContiguous() {
        if (this.getUserMaxLookahead() > 0) {
            return;
        }
        int n = 0;
        for (int i = 0; i <= this.getMaxStateNumber(); ++i) {
            boolean bl;
            DFAState dFAState = this.getState(i);
            if (dFAState == null) continue;
            boolean bl2 = bl = dFAState.stateNumber < i;
            if (bl) continue;
            dFAState.stateNumber = n++;
        }
        if (n != this.getNumberOfStates()) {
            ErrorManager.internalError(new StringBuffer().append("DFA ").append(this.decisionNumber).append(": ").append(this.decisionNFAStartState.getDescription()).append(" num unique states ").append(this.getNumberOfStates()).append("!= num renumbered states ").append(n).toString());
        }
    }

    public List getJavaCompressedAccept() {
        return this.getRunLengthEncoding(this.accept);
    }

    public List getJavaCompressedEOT() {
        return this.getRunLengthEncoding(this.eot);
    }

    public List getJavaCompressedEOF() {
        return this.getRunLengthEncoding(this.eof);
    }

    public List getJavaCompressedMin() {
        return this.getRunLengthEncoding(this.min);
    }

    public List getJavaCompressedMax() {
        return this.getRunLengthEncoding(this.max);
    }

    public List getJavaCompressedSpecial() {
        return this.getRunLengthEncoding(this.special);
    }

    public List getJavaCompressedTransition() {
        if (this.transition == null || this.transition.size() == 0) {
            return null;
        }
        ArrayList<List> arrayList = new ArrayList<List>(this.transition.size());
        for (int i = 0; i < this.transition.size(); ++i) {
            Vector vector = (Vector)this.transition.elementAt(i);
            arrayList.add(this.getRunLengthEncoding(vector));
        }
        return arrayList;
    }

    public List getRunLengthEncoding(List list) {
        int n;
        if (list == null || list.size() == 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("");
            return arrayList;
        }
        int n2 = Math.max(2, list.size() / 2);
        ArrayList<String> arrayList = new ArrayList<String>(n2);
        Integer n3 = Utils.integer(-1);
        for (int i = 0; i < list.size(); i += n) {
            Integer n4 = (Integer)list.get(i);
            if (n4 == null) {
                n4 = n3;
            }
            n = 0;
            for (int j = i; j < list.size(); ++j) {
                Integer n5 = (Integer)list.get(j);
                if (n5 == null) {
                    n5 = n3;
                }
                if (!n4.equals(n5)) break;
                ++n;
            }
            arrayList.add(this.generator.target.encodeIntAsCharEscape((char)n));
            arrayList.add(this.generator.target.encodeIntAsCharEscape((char)n4.intValue()));
        }
        return arrayList;
    }

    public void createStateTables(CodeGenerator codeGenerator) {
        this.generator = codeGenerator;
        this.description = this.getNFADecisionStartState().getDescription();
        this.description = codeGenerator.target.getTargetStringLiteralFromString(this.description);
        this.special = new Vector(this.getNumberOfStates());
        this.special.setSize(this.getNumberOfStates());
        this.specialStates = new ArrayList();
        this.specialStateSTs = new ArrayList();
        this.accept = new Vector(this.getNumberOfStates());
        this.accept.setSize(this.getNumberOfStates());
        this.eot = new Vector(this.getNumberOfStates());
        this.eot.setSize(this.getNumberOfStates());
        this.eof = new Vector(this.getNumberOfStates());
        this.eof.setSize(this.getNumberOfStates());
        this.min = new Vector(this.getNumberOfStates());
        this.min.setSize(this.getNumberOfStates());
        this.max = new Vector(this.getNumberOfStates());
        this.max.setSize(this.getNumberOfStates());
        this.transition = new Vector(this.getNumberOfStates());
        this.transition.setSize(this.getNumberOfStates());
        this.transitionEdgeTables = new Vector(this.getNumberOfStates());
        this.transitionEdgeTables.setSize(this.getNumberOfStates());
        Iterator<DFAState> iterator = null;
        iterator = this.getUserMaxLookahead() > 0 ? this.states.iterator() : this.getUniqueStates().values().iterator();
        while (iterator.hasNext()) {
            DFAState dFAState = iterator.next();
            if (dFAState == null) continue;
            if (dFAState.isAcceptState()) {
                this.accept.set(dFAState.stateNumber, Utils.integer(dFAState.getUniquelyPredictedAlt()));
                continue;
            }
            this.createMinMaxTables(dFAState);
            this.createTransitionTableEntryForState(dFAState);
            this.createSpecialTable(dFAState);
            this.createEOTAndEOFTables(dFAState);
        }
        for (int i = 0; i < this.specialStates.size(); ++i) {
            DFAState dFAState = (DFAState)this.specialStates.get(i);
            StringTemplate stringTemplate = codeGenerator.generateSpecialState(dFAState);
            this.specialStateSTs.add(stringTemplate);
        }
    }

    protected void createMinMaxTables(DFAState dFAState) {
        int n = 65535;
        int n2 = -3;
        for (int i = 0; i < dFAState.getNumberOfTransitions(); ++i) {
            Transition transition = dFAState.transition(i);
            Label label = transition.label;
            if (label.isAtom()) {
                if (label.getAtom() < 0) continue;
                if (label.getAtom() < n) {
                    n = label.getAtom();
                }
                if (label.getAtom() <= n2) continue;
                n2 = label.getAtom();
                continue;
            }
            if (!label.isSet()) continue;
            IntervalSet intervalSet = (IntervalSet)label.getSet();
            int n3 = intervalSet.getMinElement();
            if (n3 < n && n3 >= 0) {
                n = intervalSet.getMinElement();
            }
            if (intervalSet.getMaxElement() <= n2) continue;
            n2 = intervalSet.getMaxElement();
        }
        if (n2 < 0) {
            n = 0;
            n2 = 0;
        }
        this.min.set(dFAState.stateNumber, Utils.integer((char)n));
        this.max.set(dFAState.stateNumber, Utils.integer((char)n2));
        if (n2 < 0 || n > 65534 || n < 0) {
            ErrorManager.internalError(new StringBuffer().append("messed up: min=").append(this.min).append(", max=").append(this.max).toString());
        }
    }

    protected void createTransitionTableEntryForState(DFAState dFAState) {
        int n = (Integer)this.max.get(dFAState.stateNumber);
        int n2 = (Integer)this.min.get(dFAState.stateNumber);
        Vector<Integer> vector = new Vector<Integer>(n - n2 + 1);
        vector.setSize(n - n2 + 1);
        this.transition.set(dFAState.stateNumber, vector);
        for (int i = 0; i < dFAState.getNumberOfTransitions(); ++i) {
            Transition transition = dFAState.transition(i);
            Label label = transition.label;
            if (label.isAtom() && label.getAtom() >= 0) {
                int n3 = label.getAtom() - n2;
                vector.set(n3, Utils.integer(transition.target.stateNumber));
                continue;
            }
            if (!label.isSet()) continue;
            IntervalSet intervalSet = (IntervalSet)label.getSet();
            int[] nArray = intervalSet.toArray();
            for (int j = 0; j < nArray.length; ++j) {
                if (nArray[j] < 0) continue;
                int n4 = nArray[j] - n2;
                vector.set(n4, Utils.integer(transition.target.stateNumber));
            }
        }
        Integer n5 = (Integer)this.edgeTransitionClassMap.get(vector);
        if (n5 != null) {
            this.transitionEdgeTables.set(dFAState.stateNumber, n5);
        } else {
            n5 = Utils.integer(this.edgeTransitionClass);
            this.transitionEdgeTables.set(dFAState.stateNumber, n5);
            this.edgeTransitionClassMap.put(vector, n5);
            ++this.edgeTransitionClass;
        }
    }

    protected void createEOTAndEOFTables(DFAState dFAState) {
        for (int i = 0; i < dFAState.getNumberOfTransitions(); ++i) {
            Transition transition = dFAState.transition(i);
            Label label = transition.label;
            if (label.isAtom()) {
                if (label.getAtom() == -2) {
                    this.eot.set(dFAState.stateNumber, Utils.integer(transition.target.stateNumber));
                    continue;
                }
                if (label.getAtom() != -1) continue;
                this.eof.set(dFAState.stateNumber, Utils.integer(transition.target.stateNumber));
                continue;
            }
            if (!label.isSet()) continue;
            IntervalSet intervalSet = (IntervalSet)label.getSet();
            int[] nArray = intervalSet.toArray();
            for (int j = 0; j < nArray.length; ++j) {
                if (nArray[j] == -2) {
                    this.eot.set(dFAState.stateNumber, Utils.integer(transition.target.stateNumber));
                    continue;
                }
                if (nArray[j] != -1) continue;
                this.eof.set(dFAState.stateNumber, Utils.integer(transition.target.stateNumber));
            }
        }
    }

    protected void createSpecialTable(DFAState dFAState) {
        int n;
        boolean bl = false;
        for (n = 0; n < dFAState.getNumberOfTransitions(); ++n) {
            Transition transition = dFAState.transition(n);
            Label label = transition.label;
            if (!label.isSemanticPredicate() && ((DFAState)transition.target).getGatedPredicatesInNFAConfigurations() == null) continue;
            bl = true;
            break;
        }
        n = (Integer)this.max.get(dFAState.stateNumber);
        int n2 = (Integer)this.min.get(dFAState.stateNumber);
        if (bl || n - n2 > MAX_STATE_TRANSITIONS_FOR_TABLE) {
            this.special.set(dFAState.stateNumber, Utils.integer(this.uniqueCompressedSpecialStateNum));
            ++this.uniqueCompressedSpecialStateNum;
            this.specialStates.add(dFAState);
        } else {
            this.special.set(dFAState.stateNumber, Utils.integer(-1));
        }
    }

    public int predict(IntStream intStream) {
        Interpreter interpreter = new Interpreter(this.nfa.grammar, intStream);
        return interpreter.predict(this);
    }

    protected DFAState addState(DFAState dFAState) {
        if (this.getUserMaxLookahead() > 0) {
            return dFAState;
        }
        DFAState dFAState2 = this.uniqueStates.get(dFAState);
        if (dFAState2 != null) {
            return dFAState2;
        }
        this.uniqueStates.put(dFAState, dFAState);
        ++this.numberOfStates;
        return dFAState;
    }

    public void removeState(DFAState dFAState) {
        DFAState dFAState2 = this.uniqueStates.remove(dFAState);
        if (dFAState2 != null) {
            --this.numberOfStates;
        }
    }

    public Map<DFAState, DFAState> getUniqueStates() {
        return this.uniqueStates;
    }

    public int getMaxStateNumber() {
        return this.states.size() - 1;
    }

    public DFAState getState(int n) {
        return this.states.get(n);
    }

    public void setState(int n, DFAState dFAState) {
        this.states.set(n, dFAState);
    }

    public boolean isReduced() {
        return this.reduced;
    }

    public boolean isCyclic() {
        return this.cyclic && this.getUserMaxLookahead() == 0;
    }

    public boolean canInlineDecision() {
        return !this.isCyclic() && !this.probe.isNonLLStarDecision() && this.getNumberOfStates() < CodeGenerator.MAX_ACYCLIC_DFA_STATES_INLINE;
    }

    public boolean isTokensRuleDecision() {
        if (this.nfa.grammar.type != 1) {
            return false;
        }
        NFAState nFAState = this.getNFADecisionStartState();
        Rule rule = this.nfa.grammar.getLocallyDefinedRule("Tokens");
        NFAState nFAState2 = rule.startState;
        NFAState nFAState3 = (NFAState)nFAState2.transition[0].target;
        return nFAState == nFAState3;
    }

    public int getUserMaxLookahead() {
        if (this.user_k >= 0) {
            return this.user_k;
        }
        this.user_k = this.nfa.grammar.getUserMaxLookahead(this.decisionNumber);
        return this.user_k;
    }

    public boolean getAutoBacktrackMode() {
        return this.nfa.grammar.getAutoBacktrackMode(this.decisionNumber);
    }

    public void setUserMaxLookahead(int n) {
        this.user_k = n;
    }

    public int getMaxLookaheadDepth() {
        if (this.isCyclic()) {
            return Integer.MAX_VALUE;
        }
        return this.max_k;
    }

    public List<Integer> getUnreachableAlts() {
        return this.unreachableAlts;
    }

    public void verify() {
        this.doesStateReachAcceptState(this.startState);
    }

    protected boolean doesStateReachAcceptState(DFAState dFAState) {
        if (dFAState.isAcceptState()) {
            dFAState.setAcceptStateReachable(1);
            int n = dFAState.getUniquelyPredictedAlt();
            this.unreachableAlts.remove(Utils.integer(n));
            return true;
        }
        dFAState.setAcceptStateReachable(-1);
        boolean bl = false;
        for (int i = 0; i < dFAState.getNumberOfTransitions(); ++i) {
            Transition transition = dFAState.transition(i);
            DFAState dFAState2 = (DFAState)transition.target;
            int n = dFAState2.getAcceptStateReachable();
            if (n == -1) {
                this.cyclic = true;
                continue;
            }
            if (n == 1) {
                bl = true;
                continue;
            }
            if (n == 0 || !this.doesStateReachAcceptState(dFAState2)) continue;
            bl = true;
        }
        if (bl) {
            dFAState.setAcceptStateReachable(1);
        } else {
            dFAState.setAcceptStateReachable(0);
            this.reduced = false;
        }
        return bl;
    }

    public void findAllGatedSynPredsUsedInDFAAcceptStates() {
        int n = this.getNumberOfAlts();
        for (int i = 1; i <= n; ++i) {
            Set set;
            DFAState dFAState = this.getAcceptState(i);
            if (dFAState == null || (set = dFAState.getGatedSyntacticPredicatesInNFAConfigurations()) == null) continue;
            for (SemanticContext semanticContext : set) {
                this.nfa.grammar.synPredUsedInDFA(this, semanticContext);
            }
        }
    }

    public NFAState getNFADecisionStartState() {
        return this.decisionNFAStartState;
    }

    public DFAState getAcceptState(int n) {
        return this.altToAcceptState[n];
    }

    public void setAcceptState(int n, DFAState dFAState) {
        this.altToAcceptState[n] = dFAState;
    }

    public String getDescription() {
        return this.description;
    }

    public int getDecisionNumber() {
        return this.decisionNFAStartState.getDecisionNumber();
    }

    public boolean okToRetryDFAWithK1() {
        boolean bl = (this.probe.isNonLLStarDecision() || this.probe.analysisOverflowed()) && this.predicateVisible;
        return this.getUserMaxLookahead() != 1 && (this.analysisTimedOut() || bl);
    }

    public String getReasonForFailure() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.probe.isNonLLStarDecision()) {
            stringBuffer.append("non-LL(*)");
            if (this.predicateVisible) {
                stringBuffer.append(" && predicate visible");
            }
        }
        if (this.probe.analysisOverflowed()) {
            stringBuffer.append("recursion overflow");
            if (this.predicateVisible) {
                stringBuffer.append(" && predicate visible");
            }
        }
        if (this.analysisTimedOut()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" && ");
            }
            stringBuffer.append("timed out (>");
            stringBuffer.append(MAX_TIME_PER_DFA_CREATION);
            stringBuffer.append("ms)");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public GrammarAST getDecisionASTNode() {
        return this.decisionNFAStartState.associatedASTNode;
    }

    public boolean isGreedy() {
        GrammarAST grammarAST = this.nfa.grammar.getDecisionBlockAST(this.decisionNumber);
        String string = (String)grammarAST.getBlockOption("greedy");
        return string == null || !string.equals("false");
    }

    public DFAState newState() {
        DFAState dFAState = new DFAState(this);
        dFAState.stateNumber = this.stateCounter++;
        this.states.setSize(dFAState.stateNumber + 1);
        this.states.set(dFAState.stateNumber, dFAState);
        return dFAState;
    }

    public int getNumberOfStates() {
        if (this.getUserMaxLookahead() > 0) {
            return this.states.size();
        }
        return this.numberOfStates;
    }

    public int getNumberOfAlts() {
        return this.nAlts;
    }

    public boolean analysisTimedOut() {
        return this.probe.analysisTimedOut();
    }

    protected void initAltRelatedInfo() {
        this.unreachableAlts = new LinkedList<Integer>();
        for (int i = 1; i <= this.nAlts; ++i) {
            this.unreachableAlts.add(Utils.integer(i));
        }
        this.altToAcceptState = new DFAState[this.nAlts + 1];
    }

    public String toString() {
        FASerializer fASerializer = new FASerializer(this.nfa.grammar);
        if (this.startState == null) {
            return "";
        }
        return fASerializer.serialize(this.startState, false);
    }
}

