/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.transformations.rpg2sam.sam;

import eu.qimpress.samm.behaviour.BehaviourFactory;
import eu.qimpress.samm.behaviour.SeffBehaviourStub;
import eu.qimpress.samm.deployment.hardware.MemoryDescriptor;
import eu.qimpress.samm.deployment.hardware.ProcessorDescriptor;
import eu.qimpress.samm.deployment.targetenvironment.Container;
import eu.qimpress.samm.deployment.targetenvironment.ExecutionResource;
import eu.qimpress.samm.staticstructure.ComponentType;
import eu.qimpress.samm.staticstructure.InterfacePort;
import eu.qimpress.samm.staticstructure.Operation;
import eu.qimpress.samm.staticstructure.PrimitiveComponent;
import eu.qimpress.seff.AcquireAction;
import eu.qimpress.seff.InternalAction;
import eu.qimpress.seff.LoopAction;
import eu.qimpress.seff.ProbabilisticBranchTransition;
import eu.qimpress.seff.ReleaseAction;
import eu.qimpress.seff.ResourceDemandingSEFF;
import eu.qimpress.transformations.rpg2sam.ide.Configuration;
import eu.qimpress.transformations.rpg2sam.rpg.Architecture;
import eu.qimpress.transformations.rpg2sam.rpg.Measurements;
import eu.qimpress.transformations.rpg2sam.sam.AnnotationsModel;
import eu.qimpress.transformations.rpg2sam.sam.ArchitectureModel;
import eu.qimpress.transformations.rpg2sam.sam.BehaviorModel;
import eu.qimpress.transformations.rpg2sam.sam.DeploymentModel;
import eu.qimpress.transformations.rpg2sam.sam.DomainModel;
import eu.qimpress.transformations.rpg2sam.sam.HardwareModel;
import eu.qimpress.transformations.rpg2sam.sam.WorkloadModel;
import java.util.List;
import org.dom4j.Element;

public class Importer {
    protected final Configuration configuration;
    protected final Architecture architecture;
    protected final Measurements measurements;
    public final AnnotationsModel annotationsModel;
    public final ArchitectureModel architectureModel;
    public final BehaviorModel behaviorModel;
    public final DeploymentModel deploymentModel;
    public final DomainModel domainModel;
    public final HardwareModel hardwareModel;
    public final WorkloadModel usageModel;

    public Importer(String architectureName, String measurementName, Configuration configurationContext) throws Exception {
        this.configuration = configurationContext;
        this.architecture = new Architecture(architectureName, this.configuration);
        this.measurements = new Measurements(measurementName, this.configuration);
        this.annotationsModel = new AnnotationsModel(this);
        this.architectureModel = new ArchitectureModel(this);
        this.behaviorModel = new BehaviorModel(this);
        this.deploymentModel = new DeploymentModel(this);
        this.domainModel = new DomainModel(this);
        this.hardwareModel = new HardwareModel(this);
        this.usageModel = new WorkloadModel(this);
        int userCount = (int)Math.round(this.measurements.getGlobalAverage("client-count"));
        int threadCount = (int)Math.round(this.measurements.getGlobalAverage("thread-count"));
        double thinkTime = this.measurements.getGlobalAverage("client-wait-time-usec-ex") / 1000000.0;
        List<Element> moduleInstances = this.architecture.getAllModules();
        ComponentType rootComponentType = this.architectureModel.createComponentTypes(moduleInstances);
        ComponentType poolComponentType = this.architectureModel.createThreadPoolType(threadCount);
        this.deploymentModel.createServices(rootComponentType, poolComponentType);
        InterfacePort systemProvidedPort = (InterfacePort)this.deploymentModel.model.getProvided().get(0);
        this.usageModel.createUsageScenario(systemProvidedPort, userCount, thinkTime);
    }

    protected void callbackProcessingActionCreated(Element context, InternalAction action) throws Exception {
        this.annotationsModel.annotateActionTime(context, action);
        this.annotationsModel.annotateActionReliability(context, action);
    }

    protected void callbackAcquireReleaseActionsCreated(Element context, PrimitiveComponent component, AcquireAction acquire, ReleaseAction release) {
        this.annotationsModel.annotateActionMonitorResource(context, component, acquire, release);
    }

    protected void callbackThreadPoolActionsCreated(PrimitiveComponent component, AcquireAction acquire, ReleaseAction release) {
        this.annotationsModel.annotateActionThreadPoolResource(component, acquire, release);
    }

    protected void callbackLoopingActionCreated(Element context, LoopAction action) throws Exception {
        this.annotationsModel.annotateLoopCount(context, action);
    }

    protected void callbackBranchingTransitionCreated(Element context, ProbabilisticBranchTransition branchTransition, int branchCount) throws Exception {
        this.annotationsModel.annotateBranchTransitionProbability(context, branchTransition, branchCount);
    }

    protected void callbackPrimitiveComponentTypeCreated(Element context, PrimitiveComponent component) throws Exception {
        ResourceDemandingSEFF behavior;
        if (component.getRequired().isEmpty()) {
            behavior = this.behaviorModel.getProcessingBehavior(context, component);
        } else {
            String type = this.architecture.getModuleType(context);
            if (type.equals("loop")) {
                behavior = this.behaviorModel.getLoopingBehavior(context, component);
            } else if (type.equals("branch")) {
                behavior = this.behaviorModel.getBranchingBehavior(context, component);
            } else if (type.equals("sequential")) {
                behavior = this.behaviorModel.getSequentialBehavior(context, component);
            } else {
                throw new Exception("Unknown architectural module.");
            }
        }
        SeffBehaviourStub stub = BehaviourFactory.eINSTANCE.createSeffBehaviourStub();
        stub.setOperation(this.architectureModel.getModuleOperationType());
        behavior.setSeffBehaviourStub(stub);
        component.getOperationBehaviour().add((Object)stub);
    }

    protected void callbackThreadPoolComponentTypeCreated(PrimitiveComponent component) {
        ResourceDemandingSEFF behavior = this.behaviorModel.getThreadPoolBehavior(component);
        SeffBehaviourStub stub = BehaviourFactory.eINSTANCE.createSeffBehaviourStub();
        stub.setOperation(this.architectureModel.getModuleOperationType());
        behavior.setSeffBehaviourStub(stub);
        component.getOperationBehaviour().add((Object)stub);
    }

    protected Operation callbackGetOperationType() {
        return this.architectureModel.getModuleOperationType();
    }

    protected Container callbackGetContainerSingleton() {
        return this.hardwareModel.getContainerInstance();
    }

    protected ExecutionResource callbackGetExecutionResourceSingleton() {
        return this.hardwareModel.getExecutionResourceInstance();
    }

    protected ProcessorDescriptor callbackGetProcessorDescriptorSingleton() {
        return this.domainModel.getProcessorDescriptorInstance();
    }

    protected MemoryDescriptor callbackGetMemoryDescriptorSingleton() {
        return this.domainModel.getMemoryDescriptorInstance();
    }
}

