/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.transformations.rpg2sam.sam;

import eu.qimpress.samm.deployment.targetenvironment.Container;
import eu.qimpress.samm.deployment.targetenvironment.ExecutionResource;
import eu.qimpress.samm.deployment.targetenvironment.Memory;
import eu.qimpress.samm.deployment.targetenvironment.MemoryResource;
import eu.qimpress.samm.deployment.targetenvironment.Node;
import eu.qimpress.samm.deployment.targetenvironment.Processor;
import eu.qimpress.samm.deployment.targetenvironment.SchedulingPolicyKind;
import eu.qimpress.samm.deployment.targetenvironment.TargetEnvironment;
import eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentFactory;
import eu.qimpress.transformations.rpg2sam.sam.Importer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class HardwareModel {
    public final TargetEnvironment model = TargetenvironmentFactory.eINSTANCE.createTargetEnvironment();
    public static final int SAM_HARDWARE_PROCESSOR_FREQUENCY = 1000000000;
    public static final int SAM_HARDWARE_MEMORY_SIZE = 1000000000;
    private Importer importer;
    private final TargetenvironmentFactory factory = (TargetenvironmentFactory)Proxy.newProxyInstance(TargetenvironmentFactory.eINSTANCE.getClass().getClassLoader(), new Class[]{TargetenvironmentFactory.class}, (InvocationHandler)new FactoryProxy());
    private Processor processorInstance;
    private ExecutionResource executionResourceInstance;
    private Memory memoryInstance;
    private MemoryResource memoryResourceInstance;
    private Container containerInstance;

    protected HardwareModel(Importer importContext) {
        this.importer = importContext;
        this.model.setName("Main");
        this.processorInstance = this.factory.createProcessor();
        this.processorInstance.setName("DefaultProcessor");
        this.processorInstance.setClockFrequency(1.0E9);
        this.processorInstance.setDescriptor(this.importer.callbackGetProcessorDescriptorSingleton());
        this.executionResourceInstance = this.factory.createExecutionResource();
        this.executionResourceInstance.setProcessor(this.processorInstance);
        this.memoryInstance = this.factory.createMemory();
        this.memoryInstance.setName("DefaultMemory");
        this.memoryInstance.setSize(1000000000);
        this.memoryInstance.setDescriptor(this.importer.callbackGetMemoryDescriptorSingleton());
        this.memoryResourceInstance = this.factory.createMemoryResource();
        this.memoryResourceInstance.setName("DefaultMemoryResource");
        this.memoryResourceInstance.setMemory(this.memoryInstance);
        this.containerInstance = this.factory.createContainer();
        this.containerInstance.setName("DefaultContainer");
        this.containerInstance.setSchedulingPolicy(SchedulingPolicyKind.PROCESSOR_SHARING);
        this.containerInstance.getExecutionResources().add((Object)this.executionResourceInstance);
        this.containerInstance.getMemoryResources().add((Object)this.memoryResourceInstance);
        this.containerInstance.setDescription("A default container.");
        Node node = this.factory.createNode();
        node.setName("DefaultNode");
        node.getContainers().add((Object)this.containerInstance);
        node.getProcessors().add((Object)this.processorInstance);
        node.getMemories().add((Object)this.memoryInstance);
    }

    protected Processor getProcessorInstance() {
        return this.processorInstance;
    }

    protected ExecutionResource getExecutionResourceInstance() {
        return this.executionResourceInstance;
    }

    protected Memory getMemoryInstance() {
        return this.memoryInstance;
    }

    protected MemoryResource getMemoryResourceInstance() {
        return this.memoryResourceInstance;
    }

    protected Container getContainerInstance() {
        return this.containerInstance;
    }

    class FactoryProxy
    implements InvocationHandler {
        FactoryProxy() {
        }

        @Override
        public Object invoke(Object self, Method method, Object[] arguments) throws Throwable {
            Object element = method.invoke((Object)TargetenvironmentFactory.eINSTANCE, arguments);
            if (element instanceof Node) {
                HardwareModel.this.model.getNodes().add((Object)((Node)element));
            }
            return element;
        }
    }
}

