/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.transformations.rpg2sam.sam;

import eu.qimpress.samm.deployment.hardware.HardwareDescriptor;
import eu.qimpress.samm.deployment.hardware.HardwareDescriptorRepository;
import eu.qimpress.samm.deployment.hardware.HardwareFactory;
import eu.qimpress.samm.deployment.hardware.MemoryDescriptor;
import eu.qimpress.samm.deployment.hardware.ProcessorCore;
import eu.qimpress.samm.deployment.hardware.ProcessorDescriptor;
import eu.qimpress.transformations.rpg2sam.sam.Importer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class DomainModel {
    public final HardwareDescriptorRepository model = HardwareFactory.eINSTANCE.createHardwareDescriptorRepository();
    private Importer importer;
    private final HardwareFactory factory = (HardwareFactory)Proxy.newProxyInstance(HardwareFactory.eINSTANCE.getClass().getClassLoader(), new Class[]{HardwareFactory.class}, (InvocationHandler)new FactoryProxy());
    private ProcessorDescriptor processorDescriptorInstance;
    private MemoryDescriptor memoryDescriptorInstance;

    protected DomainModel(Importer importContext) throws Exception {
        this.importer = importContext;
        this.model.setName("Main");
        this.memoryDescriptorInstance = this.factory.createMemoryDescriptor();
        this.memoryDescriptorInstance.setName("DefaultMemory");
        this.processorDescriptorInstance = this.factory.createProcessorDescriptor();
        this.processorDescriptorInstance.setName("DefaultProcessor");
        int coreCount = (int)Math.round(this.importer.measurements.getGlobalAverage("cores-count"));
        int core = 0;
        while (core < coreCount) {
            ProcessorCore processorCoreInstance = this.factory.createProcessorCore();
            processorCoreInstance.setName("ProcessorCore" + core);
            this.processorDescriptorInstance.getCores().add((Object)processorCoreInstance);
            ++core;
        }
    }

    protected ProcessorDescriptor getProcessorDescriptorInstance() {
        return this.processorDescriptorInstance;
    }

    protected MemoryDescriptor getMemoryDescriptorInstance() {
        return this.memoryDescriptorInstance;
    }

    class FactoryProxy
    implements InvocationHandler {
        FactoryProxy() {
        }

        @Override
        public Object invoke(Object self, Method method, Object[] arguments) throws Throwable {
            Object element = method.invoke((Object)HardwareFactory.eINSTANCE, arguments);
            if (element instanceof HardwareDescriptor) {
                DomainModel.this.model.getDescriptors().add((Object)((HardwareDescriptor)element));
            }
            return element;
        }
    }
}

