/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.transformations.rpg2sam.sam;

import eu.qimpress.samm.staticstructure.InterfacePort;
import eu.qimpress.samm.staticstructure.PrimitiveComponent;
import eu.qimpress.seff.AbstractAction;
import eu.qimpress.seff.AcquireAction;
import eu.qimpress.seff.BranchAction;
import eu.qimpress.seff.ExternalCallAction;
import eu.qimpress.seff.InternalAction;
import eu.qimpress.seff.LoopAction;
import eu.qimpress.seff.ProbabilisticBranchTransition;
import eu.qimpress.seff.ReleaseAction;
import eu.qimpress.seff.ResourceDemandingBehaviour;
import eu.qimpress.seff.ResourceDemandingSEFF;
import eu.qimpress.seff.SeffRepository;
import eu.qimpress.seff.StartAction;
import eu.qimpress.seff.StopAction;
import eu.qimpress.seff.seffFactory;
import eu.qimpress.transformations.rpg2sam.sam.Importer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.dom4j.Element;

public class BehaviorModel {
    public final SeffRepository model = seffFactory.eINSTANCE.createSeffRepository();
    private Importer importer;
    private final seffFactory factory = (seffFactory)Proxy.newProxyInstance(seffFactory.eINSTANCE.getClass().getClassLoader(), new Class[]{seffFactory.class}, (InvocationHandler)new FactoryProxy());

    protected BehaviorModel(Importer importContext) {
        this.importer = importContext;
    }

    private void connectActions(List<AbstractAction> actions) {
        AbstractAction lastAction = null;
        for (AbstractAction thisAction : actions) {
            if (lastAction != null) {
                lastAction.setSuccessor_AbstractAction(thisAction);
                thisAction.setPredecessor_AbstractAction(lastAction);
            }
            lastAction = thisAction;
        }
    }

    private ResourceDemandingSEFF getExternalInvocationSequenceBehavior(List<InterfacePort> ports, BehaviorContainment containment) {
        LinkedList<AbstractAction> allActions = new LinkedList<AbstractAction>();
        StartAction startAction = this.factory.createStartAction();
        startAction.setName("Start");
        allActions.add((AbstractAction)startAction);
        for (InterfacePort port : ports) {
            ExternalCallAction externalAction = this.factory.createExternalCallAction();
            externalAction.setCalledInterfacePort(port);
            externalAction.setCalledService(this.importer.architectureModel.getModuleOperationType());
            externalAction.setName("External");
            allActions.add((AbstractAction)externalAction);
        }
        StopAction stopAction = this.factory.createStopAction();
        stopAction.setName("Stop");
        allActions.add((AbstractAction)stopAction);
        this.connectActions(allActions);
        ResourceDemandingSEFF behavior = null;
        switch (containment) {
            case LOCAL: {
                behavior = seffFactory.eINSTANCE.createResourceDemandingSEFF();
                break;
            }
            case GLOBAL: {
                behavior = this.factory.createResourceDemandingSEFF();
            }
        }
        behavior.getSteps().addAll(allActions);
        return behavior;
    }

    protected ResourceDemandingSEFF getProcessingBehavior(Element context, PrimitiveComponent component) throws Exception {
        boolean monitor = !component.getPassiveResources().isEmpty();
        List<AbstractAction> actions = null;
        StartAction startAction = this.factory.createStartAction();
        startAction.setName("Start");
        InternalAction processingAction = this.factory.createInternalAction();
        processingAction.setName("Processing");
        StopAction stopAction = this.factory.createStopAction();
        stopAction.setName("Stop");
        if (monitor) {
            AcquireAction acquireAction = null;
            ReleaseAction releaseAction = null;
            acquireAction = this.factory.createAcquireAction();
            acquireAction.setName("Acquire");
            releaseAction = this.factory.createReleaseAction();
            releaseAction.setName("Release");
            actions = Arrays.asList(startAction, acquireAction, processingAction, releaseAction, stopAction);
            this.importer.callbackAcquireReleaseActionsCreated(context, component, acquireAction, releaseAction);
        } else {
            actions = Arrays.asList(startAction, processingAction, stopAction);
        }
        ResourceDemandingSEFF behavior = this.factory.createResourceDemandingSEFF();
        this.connectActions(actions);
        behavior.getSteps().addAll(actions);
        this.importer.callbackProcessingActionCreated(context, processingAction);
        return behavior;
    }

    protected ResourceDemandingSEFF getThreadPoolBehavior(PrimitiveComponent component) {
        StartAction startAction = this.factory.createStartAction();
        startAction.setName("Start");
        AcquireAction acquireAction = this.factory.createAcquireAction();
        acquireAction.setName("Acquire");
        ExternalCallAction externalAction = this.factory.createExternalCallAction();
        externalAction.setCalledInterfacePort((InterfacePort)component.getRequired().get(0));
        externalAction.setCalledService(this.importer.architectureModel.getModuleOperationType());
        externalAction.setName("External");
        ReleaseAction releaseAction = this.factory.createReleaseAction();
        releaseAction.setName("Release");
        StopAction stopAction = this.factory.createStopAction();
        stopAction.setName("Stop");
        List<AbstractAction> actions = Arrays.asList(startAction, acquireAction, externalAction, releaseAction, stopAction);
        ResourceDemandingSEFF behavior = this.factory.createResourceDemandingSEFF();
        this.connectActions(actions);
        behavior.getSteps().addAll(actions);
        this.importer.callbackThreadPoolActionsCreated(component, acquireAction, releaseAction);
        return behavior;
    }

    protected ResourceDemandingSEFF getLoopingBehavior(Element context, PrimitiveComponent component) throws Exception {
        StartAction startAction = this.factory.createStartAction();
        startAction.setName("Start");
        LoopAction loopingAction = this.factory.createLoopAction();
        ResourceDemandingSEFF internalBehavior = this.getExternalInvocationSequenceBehavior((List<InterfacePort>)component.getRequired(), BehaviorContainment.LOCAL);
        loopingAction.setBodyBehaviour((ResourceDemandingBehaviour)internalBehavior);
        loopingAction.setName("Looping");
        StopAction stopAction = this.factory.createStopAction();
        stopAction.setName("Stop");
        List<AbstractAction> actions = Arrays.asList(startAction, loopingAction, stopAction);
        this.connectActions(actions);
        ResourceDemandingSEFF externalBehavior = this.factory.createResourceDemandingSEFF();
        externalBehavior.getSteps().addAll(actions);
        this.importer.callbackLoopingActionCreated(context, loopingAction);
        return externalBehavior;
    }

    protected ResourceDemandingSEFF getBranchingBehavior(Element context, PrimitiveComponent component) throws Exception {
        StartAction startAction = this.factory.createStartAction();
        startAction.setName("Start");
        BranchAction branchingAction = this.factory.createBranchAction();
        branchingAction.setName("Branching");
        int branchingCount = component.getRequired().size();
        for (InterfacePort requiredPort : component.getRequired()) {
            ProbabilisticBranchTransition transition = this.factory.createProbabilisticBranchTransition();
            List<InterfacePort> requiredList = Arrays.asList(requiredPort);
            ResourceDemandingSEFF internalBehavior = this.getExternalInvocationSequenceBehavior(requiredList, BehaviorContainment.LOCAL);
            transition.setResourceDemandingBehaviour((ResourceDemandingBehaviour)internalBehavior);
            transition.setName("Branch");
            branchingAction.getAbstractBranchTransition().add((Object)transition);
            this.importer.callbackBranchingTransitionCreated(context, transition, branchingCount);
        }
        StopAction stopAction = this.factory.createStopAction();
        stopAction.setName("Stop");
        List<AbstractAction> actions = Arrays.asList(startAction, branchingAction, stopAction);
        this.connectActions(actions);
        ResourceDemandingSEFF externalBehavior = this.factory.createResourceDemandingSEFF();
        externalBehavior.getSteps().addAll(actions);
        return externalBehavior;
    }

    protected ResourceDemandingSEFF getSequentialBehavior(Element context, PrimitiveComponent component) {
        ResourceDemandingSEFF externalBehavior = this.getExternalInvocationSequenceBehavior((List<InterfacePort>)component.getRequired(), BehaviorContainment.GLOBAL);
        return externalBehavior;
    }

    private static enum BehaviorContainment {
        LOCAL,
        GLOBAL;

    }

    class FactoryProxy
    implements InvocationHandler {
        FactoryProxy() {
        }

        @Override
        public Object invoke(Object self, Method method, Object[] arguments) throws Throwable {
            Object element = method.invoke((Object)seffFactory.eINSTANCE, arguments);
            if (element instanceof ResourceDemandingSEFF) {
                BehaviorModel.this.model.getResourceDemandingSeff().add((Object)((ResourceDemandingSEFF)element));
            }
            return element;
        }
    }
}

