/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.transformations.rpg2sam.sam;

import eu.qimpress.samm.staticstructure.ComponentEndpoint;
import eu.qimpress.samm.staticstructure.ComponentType;
import eu.qimpress.samm.staticstructure.CompositeComponent;
import eu.qimpress.samm.staticstructure.Connector;
import eu.qimpress.samm.staticstructure.Interface;
import eu.qimpress.samm.staticstructure.InterfacePort;
import eu.qimpress.samm.staticstructure.Operation;
import eu.qimpress.samm.staticstructure.PassiveResource;
import eu.qimpress.samm.staticstructure.Port;
import eu.qimpress.samm.staticstructure.PrimitiveComponent;
import eu.qimpress.samm.staticstructure.Repository;
import eu.qimpress.samm.staticstructure.StaticstructureFactory;
import eu.qimpress.samm.staticstructure.SubcomponentEndpoint;
import eu.qimpress.samm.staticstructure.SubcomponentInstance;
import eu.qimpress.transformations.rpg2sam.sam.Importer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.AbstractCollection;
import java.util.AbstractQueue;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import org.dom4j.Element;

public class ArchitectureModel {
    public final Repository model = StaticstructureFactory.eINSTANCE.createRepository();
    private Importer importer;
    private final StaticstructureFactory factory = (StaticstructureFactory)Proxy.newProxyInstance(StaticstructureFactory.eINSTANCE.getClass().getClassLoader(), new Class[]{StaticstructureFactory.class}, (InvocationHandler)new FactoryProxy());
    private Operation moduleOperationType;
    private Interface moduleInterfaceType;

    protected ArchitectureModel(Importer importContext) {
        this.importer = importContext;
        this.model.setName("Main");
        this.moduleOperationType = this.factory.createOperation();
        this.moduleOperationType.setName("Work");
        this.moduleInterfaceType = this.factory.createInterface();
        this.moduleInterfaceType.getSignatures().add((Object)this.moduleOperationType);
        this.moduleInterfaceType.setName("WorkInterface");
    }

    protected Operation getModuleOperationType() {
        return this.moduleOperationType;
    }

    protected Interface getModuleInterfaceType() {
        return this.moduleInterfaceType;
    }

    private PrimitiveComponent createPrimitiveType(Element module, ChildHandling children) throws Exception {
        String name = this.importer.architecture.getModuleName(module);
        PrimitiveComponent component = this.factory.createPrimitiveComponent();
        component.setName(name);
        if (this.importer.measurements.getMeasurementSynchronization(name)) {
            PassiveResource monitorResource = this.factory.createPassiveResource();
            monitorResource.setCapacity(1);
            monitorResource.setName("Monitor");
            component.getPassiveResources().add((Object)monitorResource);
        }
        InterfacePort providedPort = this.factory.createInterfacePort();
        providedPort.setInterfaceType(this.moduleInterfaceType);
        providedPort.setName("WorkProvided");
        component.getProvided().add((Object)providedPort);
        if (children == ChildHandling.INCLUDE_CHILDREN) {
            List<Element> childModules = this.importer.architecture.getChildModules(module);
            int childCount = childModules.size();
            int childIndex = 0;
            while (childIndex < childCount) {
                InterfacePort requiredPort = this.factory.createInterfacePort();
                requiredPort.setInterfaceType(this.moduleInterfaceType);
                requiredPort.setName("WorkRequired" + Integer.toString(childIndex));
                component.getRequired().add((Object)requiredPort);
                ++childIndex;
            }
        }
        this.importer.callbackPrimitiveComponentTypeCreated(module, component);
        return component;
    }

    public ComponentType createComponentTypes(List<Element> moduleInstances) throws Exception {
        HashMap<String, ComponentHolder> componentsByName = new HashMap<String, ComponentHolder>();
        for (Element moduleInstance : moduleInstances) {
            String componentName = this.importer.architecture.getModuleName(moduleInstance);
            ComponentHolder componentHolder = new ComponentHolder();
            componentHolder.module = moduleInstance;
            componentsByName.put(componentName, componentHolder);
        }
        for (ComponentHolder componentHolder : componentsByName.values()) {
            List<Element> componentChildren = this.importer.architecture.getChildModules(componentHolder.module);
            for (Element childModule : componentChildren) {
                String childName = this.importer.architecture.getModuleName(childModule);
                ComponentHolder childHolder = (ComponentHolder)componentsByName.get(childName);
                componentHolder.children.add(childHolder);
                childHolder.parents.add(componentHolder);
            }
        }
        Element rootModule = this.importer.architecture.getRootModule();
        String rootName = this.importer.architecture.getModuleName(rootModule);
        ComponentHolder rootHolder = (ComponentHolder)componentsByName.get(rootName);
        rootHolder.assignDepthRecursively(0);
        PriorityQueue<ComponentHolder> componentsByDepth = new PriorityQueue<ComponentHolder>(componentsByName.size(), new ComponentHolderComparatorByDepth());
        componentsByDepth.addAll(componentsByName.values());
        componentsByName = null;
        while (((AbstractCollection)componentsByDepth).size() > 1) {
            HashSet coalescedHolders = new HashSet();
            HashSet<ComponentHolder> incomingHolders = new HashSet<ComponentHolder>();
            ComponentHolder deepestHolder = (ComponentHolder)componentsByDepth.peek();
            int deepestDepth = deepestHolder.depth;
            incomingHolders.add(deepestHolder);
            do {
                HashSet<ComponentHolder> parentHolders = new HashSet<ComponentHolder>();
                for (ComponentHolder holder : incomingHolders) {
                    parentHolders.addAll(holder.parents);
                }
                incomingHolders.addAll(parentHolders);
                parentHolders = null;
                while (!incomingHolders.isEmpty()) {
                    coalescedHolders.addAll(incomingHolders);
                    HashSet<ComponentHolder> childHolders = new HashSet<ComponentHolder>();
                    for (ComponentHolder componentHolder : incomingHolders) {
                        childHolders.addAll(componentHolder.children);
                    }
                    childHolders.removeAll(coalescedHolders);
                    incomingHolders = childHolders;
                }
                for (ComponentHolder holder : coalescedHolders) {
                    HashSet<ComponentHolder> externalHolders = new HashSet<ComponentHolder>(holder.parents);
                    externalHolders.removeAll(coalescedHolders);
                    if (holder.depth != 0 && externalHolders.isEmpty()) continue;
                    incomingHolders.add(holder);
                }
            } while (incomingHolders.size() > 1);
            if (incomingHolders.size() != 1) {
                throw new AssertionError((Object)"Architecture coalescing algorithm failed.");
            }
            ComponentHolder topHolder = (ComponentHolder)incomingHolders.iterator().next();
            incomingHolders = null;
            ((AbstractCollection)componentsByDepth).removeAll(coalescedHolders);
            ((AbstractQueue)componentsByDepth).add(topHolder);
            int maximumDepth = this.importer.configuration.maximumDepth;
            if (maximumDepth > 0 && deepestDepth > maximumDepth) {
                if (topHolder.component != null) {
                    throw new AssertionError((Object)"Architecture coalescing algorithm failed.");
                }
                topHolder.component = this.createPrimitiveType(topHolder.module, ChildHandling.IGNORE_CHILDREN);
                topHolder.children.clear();
                continue;
            }
            CompositeComponent compositeComponent = this.factory.createCompositeComponent();
            compositeComponent.setName("Composite" + this.importer.architecture.getModuleName(topHolder.module));
            for (ComponentHolder subcomponentHolder : coalescedHolders) {
                if (subcomponentHolder.component == null) {
                    subcomponentHolder.component = this.createPrimitiveType(subcomponentHolder.module, ChildHandling.INCLUDE_CHILDREN);
                }
                subcomponentHolder.instance = this.factory.createSubcomponentInstance();
                subcomponentHolder.instance.setName("Child" + this.importer.architecture.getModuleName(subcomponentHolder.module));
                subcomponentHolder.instance.setRealizedBy(subcomponentHolder.component);
                compositeComponent.getSubcomponents().add((Object)subcomponentHolder.instance);
            }
            for (ComponentHolder subcomponentHolder : coalescedHolders) {
                int childIndex = 0;
                for (ComponentHolder childHolder : subcomponentHolder.children) {
                    Connector connector = this.factory.createConnector();
                    SubcomponentEndpoint startingEndpoint = this.factory.createSubcomponentEndpoint();
                    startingEndpoint.setSubcomponent(childHolder.instance);
                    startingEndpoint.setPort((Port)childHolder.component.getProvided().get(0));
                    connector.getEndpoints().add((Object)startingEndpoint);
                    SubcomponentEndpoint endingEndpoint = this.factory.createSubcomponentEndpoint();
                    endingEndpoint.setSubcomponent(subcomponentHolder.instance);
                    endingEndpoint.setPort((Port)subcomponentHolder.component.getRequired().get(childIndex));
                    connector.getEndpoints().add((Object)endingEndpoint);
                    compositeComponent.getConnector().add((Object)connector);
                    ++childIndex;
                }
            }
            InterfacePort providedPort = this.factory.createInterfacePort();
            providedPort.setInterfaceType(this.moduleInterfaceType);
            providedPort.setName("WorkProvided");
            compositeComponent.getProvided().add((Object)providedPort);
            Connector connector = this.factory.createConnector();
            SubcomponentEndpoint startingEndpoint = this.factory.createSubcomponentEndpoint();
            startingEndpoint.setSubcomponent(topHolder.instance);
            startingEndpoint.setPort((Port)topHolder.component.getProvided().get(0));
            connector.getEndpoints().add((Object)startingEndpoint);
            ComponentEndpoint endingEndpoint = this.factory.createComponentEndpoint();
            endingEndpoint.setPort((Port)providedPort);
            connector.getEndpoints().add((Object)endingEndpoint);
            compositeComponent.getConnector().add((Object)connector);
            topHolder.component = compositeComponent;
            topHolder.children.clear();
        }
        if (((AbstractCollection)componentsByDepth).size() != 1) {
            throw new AssertionError((Object)"Architecture coalescing algorithm failed.");
        }
        return ((ComponentHolder)componentsByDepth.peek()).component;
    }

    public ComponentType createThreadPoolType(int capacity) throws Exception {
        PrimitiveComponent component = this.factory.createPrimitiveComponent();
        component.setName("ThreadPool");
        PassiveResource monitorResource = this.factory.createPassiveResource();
        monitorResource.setCapacity(capacity);
        monitorResource.setName("Semaphore");
        component.getPassiveResources().add((Object)monitorResource);
        InterfacePort providedPort = this.factory.createInterfacePort();
        providedPort.setInterfaceType(this.moduleInterfaceType);
        providedPort.setName("WorkProvided");
        component.getProvided().add((Object)providedPort);
        InterfacePort requiredPort = this.factory.createInterfacePort();
        requiredPort.setInterfaceType(this.moduleInterfaceType);
        requiredPort.setName("WorkRequired");
        component.getRequired().add((Object)requiredPort);
        this.importer.callbackThreadPoolComponentTypeCreated(component);
        return component;
    }

    private static enum ChildHandling {
        IGNORE_CHILDREN,
        INCLUDE_CHILDREN;

    }

    private class ComponentHolder {
        public int depth = 0;
        public List<ComponentHolder> parents = new LinkedList<ComponentHolder>();
        public List<ComponentHolder> children = new LinkedList<ComponentHolder>();
        public Element module;
        public ComponentType component;
        public SubcomponentInstance instance;

        private ComponentHolder() {
        }

        public void assignDepthRecursively(int current_depth) {
            if (this.depth < current_depth) {
                this.depth = current_depth;
            }
            int child_depth = this.depth + 1;
            for (ComponentHolder child : this.children) {
                child.assignDepthRecursively(child_depth);
            }
        }
    }

    private class ComponentHolderComparatorByDepth
    implements Comparator<ComponentHolder> {
        private ComponentHolderComparatorByDepth() {
        }

        @Override
        public int compare(ComponentHolder first, ComponentHolder second) {
            if (first.depth < second.depth) {
                return 1;
            }
            if (first.depth > second.depth) {
                return -1;
            }
            return 0;
        }
    }

    class FactoryProxy
    implements InvocationHandler {
        FactoryProxy() {
        }

        @Override
        public Object invoke(Object self, Method method, Object[] arguments) throws Throwable {
            Object element = method.invoke((Object)StaticstructureFactory.eINSTANCE, arguments);
            if (element instanceof Interface) {
                ArchitectureModel.this.model.getInterface().add((Object)((Interface)element));
            } else if (element instanceof ComponentType) {
                ArchitectureModel.this.model.getComponenttype().add((Object)((ComponentType)element));
            }
            return element;
        }
    }
}

