/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.transformations.rpg2sam.sam;

import eu.qimpress.qualityannotationdecorator.seffdecorator.ActivityFailureProbability;
import eu.qimpress.qualityannotationdecorator.seffdecorator.BranchProbability;
import eu.qimpress.qualityannotationdecorator.seffdecorator.CpuResourceDemand;
import eu.qimpress.qualityannotationdecorator.seffdecorator.LoopCount;
import eu.qimpress.qualityannotationdecorator.seffdecorator.PassiveResourceDemand;
import eu.qimpress.qualityannotationdecorator.seffdecorator.SeffdecoratorFactory;
import eu.qimpress.samm.qosannotation.Annotation;
import eu.qimpress.samm.qosannotation.AnnotationType;
import eu.qimpress.samm.qosannotation.ConstantNumber;
import eu.qimpress.samm.qosannotation.ParametricFormula;
import eu.qimpress.samm.qosannotation.QosAnnotations;
import eu.qimpress.samm.qosannotation.QosannotationFactory;
import eu.qimpress.samm.staticstructure.PassiveResource;
import eu.qimpress.samm.staticstructure.PrimitiveComponent;
import eu.qimpress.seff.AcquireAction;
import eu.qimpress.seff.InternalAction;
import eu.qimpress.seff.LoopAction;
import eu.qimpress.seff.PassiveAction;
import eu.qimpress.seff.ProbabilisticBranchTransition;
import eu.qimpress.seff.ReleaseAction;
import eu.qimpress.transformations.rpg2sam.rpg.Architecture;
import eu.qimpress.transformations.rpg2sam.rpg.Measurements;
import eu.qimpress.transformations.rpg2sam.sam.Importer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import org.dom4j.Element;

public class AnnotationsModel {
    public final QosAnnotations model = QosannotationFactory.eINSTANCE.createQosAnnotations();
    private Importer importer;
    private final SeffdecoratorFactory factory = (SeffdecoratorFactory)Proxy.newProxyInstance(SeffdecoratorFactory.eINSTANCE.getClass().getClassLoader(), new Class[]{SeffdecoratorFactory.class}, (InvocationHandler)new FactoryProxy());

    protected AnnotationsModel(Importer importContext) {
        this.importer = importContext;
        this.model.setName("Main");
    }

    private Object doubleToAnnotation(double value) {
        ConstantNumber constant = QosannotationFactory.eINSTANCE.createConstantNumber();
        constant.setValue(value);
        return constant;
    }

    private Object measurementToAnnotation(Measurements.Measurement measurement, double scale) {
        switch (this.importer.configuration.measurementAnnotationSelection) {
            case USE_MEANS: {
                ConstantNumber constant = QosannotationFactory.eINSTANCE.createConstantNumber();
                double averageOriginal = measurement.sum / (double)measurement.count;
                double averageScaled = averageOriginal * scale;
                constant.setValue(averageScaled);
                return constant;
            }
            case USE_DISTRIBUTIONS: {
                ParametricFormula formula = QosannotationFactory.eINSTANCE.createParametricFormula();
                String specification = "DoublePMF";
                double probability = 1.0 / (double)measurement.count;
                specification = String.valueOf(specification) + "[";
                HashMap<Double, Integer> values = new HashMap<Double, Integer>(measurement.count);
                int i = 0;
                while (i < measurement.count) {
                    Double value = measurement.values[i];
                    Integer count = (Integer)values.get(value);
                    if (count == null) {
                        count = 0;
                    }
                    values.put(value, count + 1);
                    ++i;
                }
                for (Double value : values.keySet()) {
                    int count = (Integer)values.get(value);
                    double scaled = value * scale;
                    specification = String.valueOf(specification) + "(" + scaled + ";" + (double)count * probability + ")";
                }
                specification = String.valueOf(specification) + "]";
                formula.setSpecification(specification);
                return formula;
            }
        }
        throw new AssertionError((Object)"An impossible configuration option value.");
    }

    private Object parameterToAnnotation(Architecture.Parameter parameter) throws Exception {
        if (parameter.type.equals("integer")) {
            double primitive = Double.parseDouble(parameter.arguments.get("value"));
            ConstantNumber value = QosannotationFactory.eINSTANCE.createConstantNumber();
            value.setValue(primitive);
            return value;
        }
        if (parameter.type.equals("random-range")) {
            double primitiveMin = Double.parseDouble(parameter.arguments.get("min"));
            double primitiveMax = Double.parseDouble(parameter.arguments.get("max"));
            ParametricFormula value = QosannotationFactory.eINSTANCE.createParametricFormula();
            value.setSpecification("UniDouble(" + Double.toString(primitiveMin) + "," + Double.toString(primitiveMax) + ")");
            return value;
        }
        if (parameter.type.equals("random-geometric")) {
            double primitiveAverage = Double.parseDouble(parameter.arguments.get("value"));
            double primitiveRate = 1.0 / primitiveAverage;
            ParametricFormula value = QosannotationFactory.eINSTANCE.createParametricFormula();
            value.setSpecification("Exp(" + Double.toString(primitiveRate) + ")");
            return value;
        }
        throw new Exception("Unknown parameter class.");
    }

    protected void setAnnotationValue(Annotation annotation, Object value) throws Exception {
        if (value instanceof ConstantNumber) {
            annotation.setConstantNumber((ConstantNumber)value);
        } else if (value instanceof ParametricFormula) {
            annotation.setParametricFormula((ParametricFormula)value);
        } else {
            throw new Exception("Setting of an annotation type not supported.");
        }
    }

    protected Object roundAnnotationValue(Object value) throws Exception {
        if (value instanceof ConstantNumber) {
            ConstantNumber valueConstantNumber = (ConstantNumber)value;
            valueConstantNumber.setValue((double)Math.round(valueConstantNumber.getValue()));
            return valueConstantNumber;
        }
        if (value instanceof ParametricFormula) {
            ParametricFormula valueParametricFormula = (ParametricFormula)value;
            valueParametricFormula.setSpecification("Round(" + valueParametricFormula.getSpecification() + ")");
            return valueParametricFormula;
        }
        throw new Exception("Rounding of an annotation type not supported.");
    }

    protected void annotateActionTime(Element context, InternalAction action) throws Exception {
        String name = this.importer.architecture.getModuleName(context);
        Measurements.Measurement measurement = this.importer.measurements.getMeasurementTiming(name);
        double scale = 1.0;
        Object annotation = this.measurementToAnnotation(measurement, scale);
        CpuResourceDemand demand = this.factory.createCpuResourceDemand();
        this.setAnnotationValue((Annotation)demand, annotation);
        demand.setAnnotationType(AnnotationType.REQUIREMENT);
        demand.setInternalAction(action);
        demand.setName("Demand" + name);
    }

    protected void annotateActionReliability(Element context, InternalAction action) throws Exception {
        String name = this.importer.architecture.getModuleName(context);
        double failureProbability = this.importer.architecture.getParameterFailureProbability(context);
        Object failureAnnotation = this.doubleToAnnotation(failureProbability);
        ActivityFailureProbability failure = this.factory.createActivityFailureProbability();
        this.setAnnotationValue((Annotation)failure, failureAnnotation);
        failure.setAnnotationType(AnnotationType.REQUIREMENT);
        failure.setInternalAction(action);
        failure.setName("Failure" + name);
    }

    protected void annotateActionMonitorResource(Element context, PrimitiveComponent component, AcquireAction acquire, ReleaseAction release) {
        String name = this.importer.architecture.getModuleName(context);
        PassiveResource monitor = (PassiveResource)component.getPassiveResources().get(0);
        PassiveResourceDemand acquireDemand = this.factory.createPassiveResourceDemand();
        acquireDemand.setAnnotationType(AnnotationType.REQUIREMENT);
        acquireDemand.setPassiveResource(monitor);
        acquireDemand.setPassiveAction((PassiveAction)acquire);
        acquireDemand.setName("Acquire" + name);
        PassiveResourceDemand releaseDemand = this.factory.createPassiveResourceDemand();
        releaseDemand.setAnnotationType(AnnotationType.REQUIREMENT);
        releaseDemand.setPassiveResource(monitor);
        releaseDemand.setPassiveAction((PassiveAction)release);
        releaseDemand.setName("Release" + name);
    }

    protected void annotateActionThreadPoolResource(PrimitiveComponent component, AcquireAction acquire, ReleaseAction release) {
        PassiveResource monitor = (PassiveResource)component.getPassiveResources().get(0);
        PassiveResourceDemand acquireDemand = this.factory.createPassiveResourceDemand();
        acquireDemand.setAnnotationType(AnnotationType.REQUIREMENT);
        acquireDemand.setPassiveResource(monitor);
        acquireDemand.setPassiveAction((PassiveAction)acquire);
        acquireDemand.setName("Acquire");
        PassiveResourceDemand releaseDemand = this.factory.createPassiveResourceDemand();
        releaseDemand.setAnnotationType(AnnotationType.REQUIREMENT);
        releaseDemand.setPassiveResource(monitor);
        releaseDemand.setPassiveAction((PassiveAction)release);
        releaseDemand.setName("Release");
    }

    protected void annotateLoopCount(Element context, LoopAction action) throws Exception {
        String name = this.importer.architecture.getModuleName(context);
        Architecture.Parameter valueParameter = this.importer.architecture.getParameterLoopCount(context);
        Object valueAnnotationReal = this.parameterToAnnotation(valueParameter);
        Object valueAnnotationInteger = this.roundAnnotationValue(valueAnnotationReal);
        LoopCount count = this.factory.createLoopCount();
        this.setAnnotationValue((Annotation)count, valueAnnotationInteger);
        count.setAnnotationType(AnnotationType.REQUIREMENT);
        count.setLoopAction(action);
        count.setName("Count" + name);
    }

    protected void annotateBranchTransitionProbability(Element context, ProbabilisticBranchTransition branchTransition, int branchCount) throws Exception {
        String name = this.importer.architecture.getModuleName(context);
        double branchProbability = 1.0 / (double)branchCount;
        Object branchAnnotation = this.doubleToAnnotation(branchProbability);
        BranchProbability branch = this.factory.createBranchProbability();
        this.setAnnotationValue((Annotation)branch, branchAnnotation);
        branch.setAnnotationType(AnnotationType.REQUIREMENT);
        branch.setProbabilisticBranchTransition(branchTransition);
        branch.setName("Branch" + name);
    }

    class FactoryProxy
    implements InvocationHandler {
        FactoryProxy() {
        }

        @Override
        public Object invoke(Object self, Method method, Object[] arguments) throws Throwable {
            Object element = method.invoke((Object)SeffdecoratorFactory.eINSTANCE, arguments);
            if (element instanceof Annotation) {
                AnnotationsModel.this.model.getAnnotation().add((Object)((Annotation)element));
            }
            return element;
        }
    }
}

