/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.transformations.rpg2sam.rpg;

import eu.qimpress.transformations.rpg2sam.ide.Configuration;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class Measurements {
    private final Configuration configuration;
    private String timingContext;
    private String timingAttribute;
    private Random random;
    private Map<Location, Measurement> values;
    public static final int RPG_MEASUREMENT_FREQUENCY = 1000000000;
    public static final String RPG_MEASUREMENT_ATTRIBUTE_CORES = "cores-count";
    public static final String RPG_MEASUREMENT_ATTRIBUTE_CLIENTS = "client-count";
    public static final String RPG_MEASUREMENT_ATTRIBUTE_THREADS = "thread-count";
    public static final String RPG_MEASUREMENT_ATTRIBUTE_THINKTIME = "client-wait-time-usec-ex";
    private static final int RPG_MEASUREMENT_VALUES = 100;
    private static final int RPG_MEASUREMENT_INCREMENTS = 10;
    private static final String RPG_MEASUREMENT_MODULE_GLOBAL = "app";
    private static final String RPG_MEASUREMENT_CONTEXT_CONFIG = "config";
    private static final String RPG_MEASUREMENT_CONTEXT_SHARED = "shared";
    private static final String RPG_MEASUREMENT_CONTEXT_ISOLATED = "isolated";
    private static final String RPG_MEASUREMENT_ATTRIBUTE_REALTIME = "monotonic";
    private static final String RPG_MEASUREMENT_ATTRIBUTE_THREADTIME = "threadtime";
    private static final String RPG_MEASUREMENT_ATTRIBUTE_SYNCHRONIZED = "synchronized";
    private static final String RPG_MEASUREMENT_ATTRIBUTE_RESULT_OK = "result-ok-count";
    private static final String RPG_MEASUREMENT_ATTRIBUTE_RESULT_ERROR_LATENT = "result-error-latent-count";
    private static final String RPG_MEASUREMENT_ATTRIBUTE_RESULT_ERROR_EFFECTIVE = "result-error-effective-count";

    public Measurements(String file, Configuration configurationContext) throws Exception {
        this.configuration = configurationContext;
        switch (this.configuration.timingSourceSelection) {
            case USE_ISOLATED: {
                this.timingContext = RPG_MEASUREMENT_CONTEXT_ISOLATED;
                this.timingAttribute = RPG_MEASUREMENT_ATTRIBUTE_REALTIME;
                break;
            }
            case USE_SHARED: {
                this.timingContext = RPG_MEASUREMENT_CONTEXT_SHARED;
                this.timingAttribute = RPG_MEASUREMENT_ATTRIBUTE_THREADTIME;
                break;
            }
            default: {
                throw new AssertionError((Object)"Unexpected measurement source selection value.");
            }
        }
        switch (this.configuration.valueSourceSelection) {
            case USE_RANDOM: {
                this.random = new Random();
                break;
            }
            case USE_MEASURED: {
                String line;
                this.values = new HashMap<Location, Measurement>();
                BufferedReader reader = new BufferedReader(new FileReader(file));
                while ((line = reader.readLine()) != null) {
                    String[] fields = line.split(";");
                    if (fields.length != 4) {
                        throw new Exception("Invalid measurement format.");
                    }
                    String moduleName = fields[0];
                    String contextName = fields[1];
                    String attributeName = fields[2];
                    double value = Double.parseDouble(fields[3]);
                    Location location = new Location(moduleName, contextName, attributeName);
                    if (!this.values.containsKey(location)) {
                        this.values.put(location, new Measurement());
                    }
                    Measurement measurement = this.values.get(location);
                    measurement.add(value);
                }
                reader.close();
                break;
            }
            default: {
                throw new AssertionError((Object)"Unexpected timing source selection value.");
            }
        }
    }

    private Measurement getMeasurement(String moduleName, String contextName, String attributeName) throws Exception {
        Measurement measurement;
        if (this.values != null) {
            Location location = new Location(moduleName, contextName, attributeName);
            measurement = this.values.get(location);
        } else {
            measurement = new Measurement();
            int i = 0;
            while (i < 100) {
                measurement.add(Math.abs(this.random.nextDouble()));
                ++i;
            }
        }
        if (measurement == null) {
            throw new Exception("Missing measurement: " + moduleName + ";" + contextName + ";" + attributeName + ".");
        }
        return measurement;
    }

    public Measurement getMeasurementTiming(String moduleName) throws Exception {
        Measurement measurement = this.getMeasurement(moduleName, this.timingContext, this.timingAttribute);
        return measurement;
    }

    public double getMeasurementFailureProbability(String moduleName) throws Exception {
        Measurement resultOk = this.getMeasurement(moduleName, RPG_MEASUREMENT_CONTEXT_SHARED, RPG_MEASUREMENT_ATTRIBUTE_RESULT_OK);
        Measurement resultErrorLantent = this.getMeasurement(moduleName, RPG_MEASUREMENT_CONTEXT_SHARED, RPG_MEASUREMENT_ATTRIBUTE_RESULT_ERROR_LATENT);
        Measurement resultErrorEffective = this.getMeasurement(moduleName, RPG_MEASUREMENT_CONTEXT_SHARED, RPG_MEASUREMENT_ATTRIBUTE_RESULT_ERROR_EFFECTIVE);
        double resultCountNegative = resultErrorEffective.sum;
        double resultCountPositive = resultOk.sum + resultErrorLantent.sum;
        double resultCountTotal = resultCountNegative + resultCountPositive;
        double reliability = resultCountNegative / resultCountTotal;
        return reliability;
    }

    public boolean getMeasurementSynchronization(String moduleName) throws Exception {
        Measurement measurement = this.getMeasurement(moduleName, RPG_MEASUREMENT_CONTEXT_CONFIG, RPG_MEASUREMENT_ATTRIBUTE_SYNCHRONIZED);
        return measurement.sum != 0.0;
    }

    public double getGlobalAverage(String attributeName) throws Exception {
        Measurement measurement = this.getMeasurement(RPG_MEASUREMENT_MODULE_GLOBAL, RPG_MEASUREMENT_CONTEXT_CONFIG, attributeName);
        double average = measurement.sum / (double)measurement.count;
        return average;
    }

    private static class Location {
        public String module;
        public String context;
        public String attribute;

        public int hashCode() {
            return this.module.hashCode() + this.context.hashCode() + this.attribute.hashCode();
        }

        public boolean equals(Object objectRaw) {
            if (objectRaw instanceof Location) {
                Location objectLocation = (Location)objectRaw;
                return this.module.equals(objectLocation.module) && this.context.equals(objectLocation.context) && this.attribute.equals(objectLocation.attribute);
            }
            return false;
        }

        public Location(String module, String context, String attribute) {
            this.module = module;
            this.context = context;
            this.attribute = attribute;
        }
    }

    public static class Measurement {
        public int count = 0;
        public double sum = 0.0;
        public double[] values = new double[10];

        public void add(double value) {
            if (this.values.length == this.count) {
                this.values = Arrays.copyOf(this.values, this.values.length + 10);
            }
            this.values[this.count] = value;
            if (this.count == Integer.MAX_VALUE) {
                throw new AssertionError((Object)"Too many measurements.");
            }
            ++this.count;
            this.sum += value;
        }
    }
}

