/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.transformations.rpg2sam.rpg;

import eu.qimpress.transformations.rpg2sam.ide.Configuration;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class Architecture {
    private final Configuration configuration;
    private Document rootDocument;
    private Element rootElement;
    public static final String RPG_MODULE_CLASS_SEQUENCE = "sequential";
    public static final String RPG_MODULE_CLASS_BRANCH = "branch";
    public static final String RPG_MODULE_CLASS_LOOP = "loop";
    public static final String RPG_PARAMETER_TYPE_COIN_TOSS = "random-coin-toss";
    public static final String RPG_PARAMETER_TYPE_FLOAT = "float";
    public static final String RPG_PARAMETER_TYPE_BOOLEAN = "boolean";
    public static final String RPG_PARAMETER_TYPE_INTEGER = "integer";
    public static final String RPG_PARAMETER_TYPE_UNIFORM = "random-range";
    public static final String RPG_PARAMETER_TYPE_GEOMETRIC = "random-geometric";
    public static final String RPG_ATTRIBUTE_NAME_MIN = "min";
    public static final String RPG_ATTRIBUTE_NAME_MAX = "max";
    public static final String RPG_ATTRIBUTE_NAME_VALUE = "value";
    private static final String RPG_NODE_ITEM = "item";
    private static final String RPG_NODE_SLOT = "slot";
    private static final String RPG_NODE_MODULE = "module";
    private static final String RPG_NODE_ATTRIBUTE = "attribute";
    private static final String RPG_NODE_PARAMETER = "param";
    private static final String RPG_NODE_PARAMETERS = "params";
    private static final String RPG_SLOT_ATTRIBUTE_TARGET = "target-id";
    private static final String RPG_MODULE_ATTRIBUTE_NAME = "id";
    private static final String RPG_MODULE_ATTRIBUTE_CLASS = "classname";
    private static final String RPG_ATTRIBUTE_ATTRIBUTE_NAME = "name";
    private static final String RPG_ATTRIBUTE_NAME_PROBABILITY = "probability";
    private static final String RPG_PARAMETER_ATTRIBUTE_NAME = "name";
    private static final String RPG_PARAMETER_ATTRIBUTE_CLASS = "classname";
    private static final String RPG_PARAMETER_NAME_LOOP_COUNT = "loopcount";
    private static final String RPG_PARAMETER_NAME_FAULT_PROBABILITY = "fault-probability";
    private static final String RPG_PARAMETER_NAME_ERROR_INTERNAL_PROBABILITY = "error-internal-probability";
    private static final String RPG_PARAMETER_NAME_ERROR_INVOCATION_PROBABILITY = "error-invocation-probability";
    private static final String RPG_PARAMETER_NAME_ERROR_TERMINATION_PROBABILITY = "error-termination-probability";
    private static final String RPG_PARAMETER_NAME_FAILURE_INTERNAL_PROBABILITY = "failure-internal-probability";
    private static final String RPG_PARAMETER_NAME_FAILURE_INVOCATION_PROBABILITY = "failure-invocation-probability";
    private static final String RPG_PARAMETER_NAME_FAILURE_TERMINATION_PROBABILITY = "failure-termination-probability";
    private static final String RPG_ARCHITECTURE_ATTRIBUTE_ROOT = "root-module-id";

    public Architecture(String file, Configuration configurationContext) throws Exception {
        this.configuration = configurationContext;
        File architectureFile = new File(file);
        SAXReader architectureReader = new SAXReader();
        this.rootDocument = architectureReader.read(architectureFile);
        this.rootElement = this.rootDocument.getRootElement();
        if (this.rootElement.getName() != "architecture") {
            throw new Exception("Top level architecture node missing.");
        }
    }

    public Element getModuleByName(String name) {
        String moduleQuery = "module[@id='" + name + "']";
        return (Element)this.rootElement.selectSingleNode(moduleQuery);
    }

    public Element getRootModule() {
        String rootName = this.rootElement.attributeValue(RPG_ARCHITECTURE_ATTRIBUTE_ROOT);
        Element rootModule = this.getModuleByName(rootName);
        return rootModule;
    }

    public List<Element> getAllModules() {
        return this.rootElement.elements(RPG_NODE_MODULE);
    }

    public List<Element> getChildModules(Element context) {
        List slots = context.elements(RPG_NODE_SLOT);
        ArrayList<Element> children = new ArrayList<Element>(slots.size());
        for (Element slot : slots) {
            String child = slot.attributeValue(RPG_SLOT_ATTRIBUTE_TARGET);
            children.add(this.getModuleByName(child));
        }
        return children;
    }

    public String getModuleName(Element module) {
        return module.attribute(RPG_MODULE_ATTRIBUTE_NAME).getValue();
    }

    public String getModuleType(Element module) {
        return module.attribute("classname").getValue();
    }

    private Parameter getParameterValue(Element context, String name) throws Exception {
        Parameter parameter = new Parameter();
        String parameterQuery = "params/param[@name='" + name + "']";
        Element parameterElement = (Element)context.selectSingleNode(parameterQuery);
        parameter.type = parameterElement.attributeValue("classname");
        parameter.arguments = new HashMap<String, String>();
        List attributesList = parameterElement.elements(RPG_NODE_ATTRIBUTE);
        for (Element attribute : attributesList) {
            String attributeName = attribute.attributeValue("name");
            String attributeValue = attribute.elementText(RPG_NODE_ITEM);
            parameter.arguments.put(attributeName, attributeValue);
        }
        return parameter;
    }

    private double getParameterValueAsDouble(Element context, String name) throws Exception {
        double value;
        Parameter parameter = this.getParameterValue(context, name);
        String type = parameter.type;
        if (type.equals(RPG_PARAMETER_TYPE_FLOAT)) {
            value = Double.parseDouble(parameter.arguments.get(RPG_ATTRIBUTE_NAME_VALUE));
        } else if (type.equals(RPG_PARAMETER_TYPE_BOOLEAN)) {
            value = Double.parseDouble(parameter.arguments.get(RPG_ATTRIBUTE_NAME_VALUE));
        } else if (type.equals(RPG_PARAMETER_TYPE_INTEGER)) {
            value = Double.parseDouble(parameter.arguments.get(RPG_ATTRIBUTE_NAME_VALUE));
        } else if (type.equals(RPG_PARAMETER_TYPE_COIN_TOSS)) {
            value = Double.parseDouble(parameter.arguments.get(RPG_ATTRIBUTE_NAME_PROBABILITY));
        } else {
            throw new Exception("Unexpected parameter type: " + type + ".");
        }
        return value;
    }

    public Parameter getParameterLoopCount(Element context) throws Exception {
        return this.getParameterValue(context, RPG_PARAMETER_NAME_LOOP_COUNT);
    }

    public double getParameterFailureProbability(Element context) throws Exception {
        double faultProbability = this.getParameterValueAsDouble(context, RPG_PARAMETER_NAME_FAULT_PROBABILITY);
        double errorInternalProbability = this.getParameterValueAsDouble(context, RPG_PARAMETER_NAME_ERROR_INTERNAL_PROBABILITY);
        double errorInvocationProbability = this.getParameterValueAsDouble(context, RPG_PARAMETER_NAME_ERROR_INVOCATION_PROBABILITY);
        double errorTerminationProbability = this.getParameterValueAsDouble(context, RPG_PARAMETER_NAME_ERROR_TERMINATION_PROBABILITY);
        double failureInternalProbability = this.getParameterValueAsDouble(context, RPG_PARAMETER_NAME_FAILURE_INTERNAL_PROBABILITY);
        double failureInvocationProbability = this.getParameterValueAsDouble(context, RPG_PARAMETER_NAME_FAILURE_INVOCATION_PROBABILITY);
        double failureTerminationProbability = this.getParameterValueAsDouble(context, RPG_PARAMETER_NAME_FAILURE_TERMINATION_PROBABILITY);
        double invocationFailureProbability = errorInvocationProbability * (1.0 - (1.0 - failureInvocationProbability) * (1.0 - failureTerminationProbability));
        double terminationFalureProbability = errorTerminationProbability * failureTerminationProbability;
        double internalFailureProbability = errorInternalProbability * failureInternalProbability / (errorInternalProbability + failureInternalProbability);
        double failureProbability = faultProbability * (1.0 - (1.0 - internalFailureProbability) * (1.0 - invocationFailureProbability) * (1.0 - terminationFalureProbability));
        return failureProbability;
    }

    public static class Parameter {
        public String type;
        public Map<String, String> arguments;
    }
}

