/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.transformations.rpg2sam.ide;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.transformations.rpg2sam.ide.Configuration;
import eu.qimpress.transformations.rpg2sam.ide.ImportWizard;
import eu.qimpress.transformations.rpg2sam.ide.ImportWizardPage;
import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.statushandlers.StatusManager;

public class ImportWizardSingle
extends ImportWizard {
    public boolean performFinish() {
        try {
            Configuration configuration = this.configureImport();
            if (this.navigatorSelection.size() != 1 || !(this.navigatorSelection.getFirstElement() instanceof IQAlternative)) {
                throw new Exception("A single alternative to import into must be selected.");
            }
            IQAlternative alternative = (IQAlternative)this.navigatorSelection.getFirstElement();
            String directoryName = this.selectionPage.directoryText.getText();
            String architectureName = String.valueOf(directoryName) + File.separator + "main.xml";
            String measurementsName = String.valueOf(directoryName) + File.separator + "main.out";
            this.performImport(alternative, architectureName, measurementsName, configuration);
        }
        catch (Exception e) {
            Status status = new Status(4, "RPG2SAM", "Import of the architecture has failed.", (Throwable)e);
            StatusManager.getManager().handle((IStatus)status, 5);
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.navigatorSelection = selection;
        this.setWindowTitle("RPG Architecture Import Wizard");
        this.selectionPage = new ImportWizardPage("Import RPG Architecture", "Import an RPG architecture description file from the local file system into the selected alternative.");
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.selectionPage);
    }
}

