/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.transformations.rpg2sam.ide;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.transformations.rpg2sam.ide.Configuration;
import eu.qimpress.transformations.rpg2sam.ide.ImportWizard;
import eu.qimpress.transformations.rpg2sam.ide.ImportWizardPage;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.statushandlers.StatusManager;

public class ImportWizardMultiple
extends ImportWizard {
    public ImportWizardMultiple() {
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        try {
            Configuration configuration = this.configureImport();
            if (this.navigatorSelection.size() != 1 || !(this.navigatorSelection.getFirstElement() instanceof IQAlternative)) {
                throw new Exception("A single alternative to import into must be selected.");
            }
            IQAlternative parentAlternative = (IQAlternative)this.navigatorSelection.getFirstElement();
            String directoryName = this.selectionPage.directoryText.getText();
            File directoryFile = new File(directoryName);
            Object[] subdirectoryFiles = directoryFile.listFiles();
            Arrays.sort(subdirectoryFiles);
            this.getContainer().run(true, true, new IRunnableWithProgress((File[])subdirectoryFiles, parentAlternative, configuration){
                private final /* synthetic */ File[] val$subdirectoryFiles;
                private final /* synthetic */ IQAlternative val$parentAlternative;
                private final /* synthetic */ Configuration val$configuration;
                {
                    this.val$subdirectoryFiles = fileArray;
                    this.val$parentAlternative = iQAlternative;
                    this.val$configuration = configuration;
                }

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    boolean reportFailure = false;
                    try {
                        try {
                            monitor.beginTask("Importing multiple RPG architecture files", this.val$subdirectoryFiles.length + 1);
                            monitor.worked(1);
                            File[] fileArray = this.val$subdirectoryFiles;
                            int n = this.val$subdirectoryFiles.length;
                            int n2 = 0;
                            while (n2 < n) {
                                File subdirectoryFile = fileArray[n2];
                                if (monitor.isCanceled()) break;
                                monitor.subTask(String.valueOf(subdirectoryFile.getName()) + ".");
                                if (subdirectoryFile.isDirectory()) {
                                    String architectureName = String.valueOf(subdirectoryFile.getPath()) + File.separator + "main.xml";
                                    String measurementsName = String.valueOf(subdirectoryFile.getPath()) + File.separator + "main.out";
                                    IQAlternative childAlternative = this.val$parentAlternative.getRepository().createAlternative(this.val$parentAlternative, subdirectoryFile.getName(), true);
                                    try {
                                        ImportWizardMultiple.this.performImport(childAlternative, architectureName, measurementsName, this.val$configuration);
                                    }
                                    catch (Exception e) {
                                        Status status = new Status(4, "RPG2SAM", "Import of " + subdirectoryFile.getName() + " failed.", (Throwable)e);
                                        StatusManager.getManager().handle((IStatus)status, 1);
                                        reportFailure = true;
                                    }
                                }
                                monitor.worked(1);
                                ++n2;
                            }
                            if (reportFailure) {
                                throw new Exception("Check error log for details.");
                            }
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e, e.getMessage());
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (Exception e) {
            Status status = new Status(4, "RPG2SAM", "Import of some architectures has failed.", (Throwable)e);
            StatusManager.getManager().handle((IStatus)status, 5);
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.navigatorSelection = selection;
        this.setWindowTitle("RPG Architecture Import Wizard");
        this.selectionPage = new ImportWizardPage("Import Multiple RPG Architectures", "Import multiple RPG architecture description files from the local file system into the selected alternative.");
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.selectionPage);
    }
}

