/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.transformations.rpg2sam.ide;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.transformations.rpg2sam.ide.Configuration;
import eu.qimpress.transformations.rpg2sam.ide.ImportWizardPage;
import eu.qimpress.transformations.rpg2sam.sam.Importer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;

public abstract class ImportWizard
extends Wizard
implements IImportWizard {
    protected ImportWizardPage selectionPage;
    protected IStructuredSelection navigatorSelection;
    private static final String RPG_MODEL_FILE = "main";
    protected static final String PLUGIN_ID = "RPG2SAM";
    protected static final String RPG_ARCHITECTURE_FILE = "main.xml";
    protected static final String RPG_MEASUREMENTS_FILE = "main.out";

    protected Configuration configureImport() {
        int depthNumber;
        Configuration configuration = new Configuration();
        if (this.selectionPage.measurementsButtonRandom.getSelection()) {
            configuration.valueSourceSelection = Configuration.ValueSourceSelection.USE_RANDOM;
        } else if (this.selectionPage.measurementsButtonMeasured.getSelection()) {
            configuration.valueSourceSelection = Configuration.ValueSourceSelection.USE_MEASURED;
        } else {
            throw new AssertionError((Object)"An impossible configuration option value.");
        }
        if (this.selectionPage.timingButtonShared.getSelection()) {
            configuration.timingSourceSelection = Configuration.TimingSourceSelection.USE_SHARED;
        } else if (this.selectionPage.timingButtonIsolated.getSelection()) {
            configuration.timingSourceSelection = Configuration.TimingSourceSelection.USE_ISOLATED;
        } else {
            throw new AssertionError((Object)"An impossible configuration option value.");
        }
        if (this.selectionPage.annotationButtonMeans.getSelection()) {
            configuration.measurementAnnotationSelection = Configuration.MeasurementAnnotationSelection.USE_MEANS;
        } else if (this.selectionPage.annotationButtonDistributions.getSelection()) {
            configuration.measurementAnnotationSelection = Configuration.MeasurementAnnotationSelection.USE_DISTRIBUTIONS;
        } else {
            throw new AssertionError((Object)"An impossible configuration option value.");
        }
        String depthString = this.selectionPage.depthText.getText();
        configuration.maximumDepth = depthNumber = Integer.parseInt(depthString);
        return configuration;
    }

    protected void performImport(IQAlternative alternative, String architectureName, String measurementsName, Configuration configuration) throws Exception {
        Importer importer = new Importer(architectureName, measurementsName, configuration);
        alternative.storeEObject(new EObject[]{importer.domainModel.model, importer.hardwareModel.model, importer.architectureModel.model, importer.behaviorModel.model, importer.annotationsModel.model, importer.deploymentModel.model, importer.usageModel.model}, new String[]{RPG_MODEL_FILE, RPG_MODEL_FILE, RPG_MODEL_FILE, RPG_MODEL_FILE, RPG_MODEL_FILE, RPG_MODEL_FILE, RPG_MODEL_FILE}, new String[]{"samm_hardware", "samm_targetenvironment", "samm_repository", "samm_seff", "samm_qosannotation", "samm_servicearchitecturemodel", "samm_usagemodel"});
    }
}

