/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.core.wizard;

import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.xtext.ui.core.util.EclipseResourceUtil;
import org.eclipse.xtext.ui.core.wizard.IProjectCreator;
import org.eclipse.xtext.ui.core.wizard.IProjectInfo;

public abstract class XtextNewProjectWizard
extends Wizard
implements INewWizard {
    private static Logger logger = Logger.getLogger(XtextNewProjectWizard.class);
    protected IStructuredSelection selection;
    @Inject
    private IProjectCreator creator;

    public XtextNewProjectWizard() {
        this.setNeedsProgressMonitor(true);
    }

    protected abstract IProjectInfo getProjectInfo();

    public boolean performFinish() {
        final IProjectInfo projectInfo = this.getProjectInfo();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        XtextNewProjectWizard.this.doFinish(projectInfo, monitor);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(IProjectInfo projectInfo, IProgressMonitor monitor) {
        try {
            this.creator.setProjectInfo(projectInfo);
            this.creator.run(monitor);
            EclipseResourceUtil.openFileToEdit(this.getShell(), this.creator.getResult());
        }
        catch (InvocationTargetException e) {
            logger.error((Object)e);
        }
        catch (InterruptedException e) {
            logger.error((Object)e);
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

