/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.core.util;

import java.io.File;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ExternalPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.xtext.resource.ClasspathUriResolutionException;
import org.eclipse.xtext.resource.ClasspathUriUtil;
import org.eclipse.xtext.resource.IClasspathUriResolver;

public class JdtClasspathUriResolver
implements IClasspathUriResolver {
    private IJavaElement javaElement;

    public URI resolve(Object context, URI classpathUri) {
        if (!(context instanceof IJavaElement)) {
            throw new IllegalArgumentException("Context must implement IResource");
        }
        this.javaElement = (IJavaElement)context;
        try {
            if (ClasspathUriUtil.isClasspathUri((URI)classpathUri)) {
                IJavaProject javaProject = this.javaElement.getJavaProject();
                URI result = JdtClasspathUriResolver.findResourceInWorkspace(javaProject, classpathUri);
                if (classpathUri.fragment() != null) {
                    result = result.appendFragment(classpathUri.fragment());
                }
                return result;
            }
        }
        catch (Exception exc) {
            throw new ClasspathUriResolutionException(exc);
        }
        return classpathUri;
    }

    protected static URI findResourceInWorkspace(IJavaProject javaProject, URI classpathUri) throws JavaModelException, CoreException {
        Path fullPath = new Path(classpathUri.path());
        String projectRelativePath = fullPath.toString();
        if (javaProject.exists()) {
            IPackageFragmentRoot[] allPackageFragmentRoots;
            IPackageFragmentRoot[] iPackageFragmentRootArray = allPackageFragmentRoots = javaProject.getAllPackageFragmentRoots();
            int n = allPackageFragmentRoots.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n2];
                IResource correspondingResource = packageFragmentRoot.getCorrespondingResource();
                if (correspondingResource != null && correspondingResource instanceof IFile || packageFragmentRoot instanceof JarPackageFragmentRoot) {
                    URI resourceUri;
                    JarPackageFragmentRoot jarPackageFragmentRoot;
                    JarPackageFragmentRoot jarPackageFragmentRoot2 = jarPackageFragmentRoot = packageFragmentRoot instanceof JarPackageFragmentRoot ? (JarPackageFragmentRoot)packageFragmentRoot : (JarPackageFragmentRoot)JavaCore.createJarPackageFragmentRootFrom((IFile)((IFile)correspondingResource));
                    if (jarPackageFragmentRoot != null && (resourceUri = JdtClasspathUriResolver.findUriInJarFile(projectRelativePath, jarPackageFragmentRoot)) != null) {
                        return resourceUri;
                    }
                } else {
                    File f;
                    IResource modelFile;
                    IFolder rootFolder = null;
                    IPath path = null;
                    if (correspondingResource instanceof IFolder) {
                        rootFolder = (IFolder)correspondingResource;
                    } else if (packageFragmentRoot instanceof ExternalPackageFragmentRoot) {
                        IResource resource = ((ExternalPackageFragmentRoot)packageFragmentRoot).resource();
                        path = ((ExternalPackageFragmentRoot)packageFragmentRoot).getPath();
                        if (resource instanceof IFolder) {
                            rootFolder = (IFolder)resource;
                        }
                    }
                    if (rootFolder != null && (modelFile = rootFolder.findMember(projectRelativePath)) != null && modelFile.exists() && modelFile instanceof IFile) {
                        URI platformResourceUri = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)true);
                        return platformResourceUri;
                    }
                    if (path != null && (f = (path = path.append((IPath)fullPath)).toFile()).exists() && f.isFile()) {
                        URI fileUri = URI.createFileURI((String)f.getAbsolutePath());
                        return fileUri;
                    }
                }
                ++n2;
            }
        }
        return classpathUri;
    }

    private static URI findUriInJarFile(String projectRelativePath, JarPackageFragmentRoot jarPackageFragmentRoot) throws CoreException {
        ZipEntry zipEntry;
        ZipFile zipFile = jarPackageFragmentRoot.getJar();
        if (zipFile != null && (zipEntry = zipFile.getEntry(projectRelativePath.substring(1))) != null) {
            IResource resource = jarPackageFragmentRoot.resource();
            if (resource == null && (resource = jarPackageFragmentRoot.getUnderlyingResource()) == null) {
                String name = zipFile.getName();
                return JdtClasspathUriResolver.getZipEntryUri(projectRelativePath, name);
            }
            return URI.createURI((String)("jar:platform:/resource" + resource.getFullPath() + "!" + projectRelativePath), (boolean)true);
        }
        return null;
    }

    public static URI getZipEntryUri(String projectRelativePath, String osDependentName) {
        String name = osDependentName.replace('\\', '/');
        URI fileURI = URI.createFileURI((String)name);
        String uri = "jar:" + fileURI + "!" + projectRelativePath;
        return URI.createURI((String)uri);
    }
}

