/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.core.editor.utils;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.concurrent.IStateAccess;
import org.eclipse.xtext.concurrent.IUnitOfWork;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.core.editor.IXtextResourceChecker;
import org.eclipse.xtext.ui.core.editor.MarkerUtil;
import org.eclipse.xtext.validation.CheckMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationJob
extends Job {
    private static final Logger log = Logger.getLogger(ValidationJob.class);
    private final CheckMode checkMode;
    private final IFile iFile;
    private final boolean deleteOldMarkers;
    private final IXtextResourceChecker xtextResourceChecker;
    private final IStateAccess<XtextResource> xtextDocument;

    public ValidationJob(IXtextResourceChecker xtextResourceChecker, IStateAccess<XtextResource> xtextDocument, IFile iFile, CheckMode checkMode, boolean deleteOldMarkers) {
        super("Xtext validation");
        this.xtextDocument = xtextDocument;
        this.iFile = iFile;
        this.checkMode = checkMode;
        this.deleteOldMarkers = deleteOldMarkers;
        this.xtextResourceChecker = xtextResourceChecker;
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        log.debug((Object)("Starting Xtext Validation with CheckMode: " + this.checkMode));
        if (this.iFile == null) {
            log.debug((Object)("Aborting Xtext Validation with CheckMode: " + this.checkMode + " because file does not exist."));
            return Status.OK_STATUS;
        }
        List<Map<String, Object>> issues = this.createIssues(monitor);
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        MarkerUtil.addMarkers(this.iFile, issues, this.checkMode, this.deleteOldMarkers, monitor);
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    public List<Map<String, Object>> createIssues(final IProgressMonitor monitor) {
        List issues = (List)this.xtextDocument.readOnly((IUnitOfWork)new IUnitOfWork<List<Map<String, Object>>, XtextResource>(){

            public List<Map<String, Object>> exec(XtextResource resource) throws Exception {
                return ValidationJob.this.xtextResourceChecker.check((Resource)resource, ValidationJob.this.getValidationContext(), monitor);
            }
        });
        return issues;
    }

    protected IXtextResourceChecker getXtextResourceChecker() {
        return this.xtextResourceChecker;
    }

    protected IStateAccess<XtextResource> getXtextDocument() {
        return this.xtextDocument;
    }

    protected CheckMode getCheckMode() {
        return this.checkMode;
    }

    protected IFile getFile() {
        return this.iFile;
    }

    protected boolean isDeleteOldMarkers() {
        return this.deleteOldMarkers;
    }

    protected Map<Object, Object> getValidationContext() {
        return Collections.singletonMap("check.mode", this.checkMode);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Factory {
        public ValidationJob create(IStateAccess<XtextResource> var1, IFile var2, CheckMode var3, boolean var4);
    }
}

